/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.nettask;

import com.shield.android.ShieldException;
import com.shield.android.internal.CSLogger;
import com.shield.android.internal.CryptoUtils;
import com.shield.android.internal.InternalLogger;
import com.shield.android.nettask.NetTask;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SendAttributesNetTask
extends NetTask {
    private final HashMap<String, Object> params = new HashMap();
    private final CSLogger logger;
    private final CryptoUtils cryptoUtils;
    private Map<String, Object> currentParams;
    public boolean status = false;
    public ShieldException responseError;
    public String baseUrl;
    private final String siteId;
    private String version;
    private String environment;

    public SendAttributesNetTask(String siteId, CSLogger logger, CryptoUtils cryptoUtils, String environment) {
        this.siteId = siteId;
        this.logger = logger;
        this.cryptoUtils = cryptoUtils;
        this.environment = environment;
    }

    @Override
    public HashMap<String, String> getRequestHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Accept-Encoding", "gzip");
        return map;
    }

    @Override
    protected String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    protected String getSiteId() {
        return this.siteId;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    protected String getVersion() {
        return this.version;
    }

    @Override
    public String getUrl() {
        String url = "/shield-fp/v1/api/attributes";
        return url;
    }

    @Override
    public NetTask.Method getMethod() {
        return NetTask.Method.POST;
    }

    @Override
    public NetTask.RequestType getRequestType() {
        return NetTask.RequestType.TEXT;
    }

    public void setRequestObject(Map<String, Object> requestObject) {
        String encryptedPayload = "";
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("test", this.environment != null && this.environment.equalsIgnoreCase("Dev"));
            for (Map.Entry<String, Object> entry : requestObject.entrySet()) {
                if (entry.getValue() != null) {
                    jsonObject.put(entry.getKey(), (Object)entry.getValue().toString());
                    continue;
                }
                jsonObject.put(entry.getKey(), JSONObject.NULL);
            }
            String payload = jsonObject.toString();
            encryptedPayload = this.cryptoUtils.encryptPayload(payload);
        }
        catch (Exception e) {
            this.logger.error(e, "error serializing data", new Object[0]);
        }
        this.params.clear();
        this.params.put("data", encryptedPayload);
    }

    @Override
    public Map<String, Object> getRequestObject() {
        return this.params;
    }

    @Override
    public void onSuccess(String response) {
        try {
            this.responseError = null;
            InternalLogger.getInstance().debug("send attributes: " + response, new Object[0]);
            JSONObject statusObj = new JSONObject(response);
            this.status = statusObj.getBoolean("status");
        }
        catch (JSONException e) {
            this.responseError = ShieldException.unexpectedError(e);
            InternalLogger.getInstance().error(e);
        }
    }

    @Override
    public void onFail(ShieldException exception) {
        try {
            if (exception.kind == ShieldException.Kind.HTTP) {
                this.logger.error(exception, "%s - %s", exception.message, exception.body);
            } else {
                this.logger.error(exception, exception.message, new Object[0]);
            }
            this.responseError = exception;
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }
}

