/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.nettask;

import android.os.Process;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.shield.android.ShieldException;
import com.shield.android.internal.Utils;
import com.shield.android.nettask.Connection;
import com.shield.android.nettask.NetTask;
import com.shield.android.nettask.NetTaskListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPOutputStream;
import org.json.JSONObject;

public final class NetTaskQueue {
    private static final String TAG = NetTaskQueue.class.getSimpleName();
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 20000;
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 15000;
    private final ExecutorService networkExecutorService;

    private NetTaskQueue(ExecutorService service) {
        this.networkExecutorService = service;
    }

    public static synchronized NetTaskQueue create(ExecutorService service) {
        return new NetTaskQueue(service);
    }

    public void enqueue(NetTask netTask) {
        this.networkExecutorService.submit(() -> {
            try {
                this.startConnection(netTask);
            }
            catch (ShieldException e) {
                netTask.onFail(e);
            }
            catch (IOException e) {
                netTask.onFail(ShieldException.networkError(e));
            }
            catch (Exception e) {
                netTask.onFail(ShieldException.unexpectedError(e));
            }
        });
    }

    public void enqueue(NetTask netTask, @NonNull NetTaskListener listener) {
        listener.notifyState(State.PENDING);
        Runnable run = () -> {
            try {
                this.startConnection(netTask);
            }
            catch (ShieldException e) {
                netTask.onFail(e);
            }
            catch (IOException e) {
                netTask.onFail(ShieldException.networkError(e));
            }
            catch (Exception e) {
                netTask.onFail(ShieldException.unexpectedError(e));
            }
            finally {
                listener.notifyState(State.FINISHED);
            }
        };
        try {
            this.networkExecutorService.submit(run);
        }
        catch (Exception e) {
            netTask.onFail(ShieldException.unexpectedError(e));
            listener.notifyState(State.FINISHED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startConnection(NetTask currentNetTask) throws Exception {
        try (Connection connection = null;){
            HttpURLConnection httpURLConnection = this.openConnection(currentNetTask);
            switch (currentNetTask.getMethod()) {
                case POST: 
                case PUT: {
                    connection = this.createPostConnection(httpURLConnection, currentNetTask);
                    return;
                }
                case GET: {
                    connection = this.createGetConnection(httpURLConnection, currentNetTask);
                    return;
                }
            }
            return;
        }
    }

    private Connection createPostConnection(HttpURLConnection connection, final NetTask currentNetTask) throws Exception {
        byte[] body = this.getRequestBody(currentNetTask);
        OutputStream outputStream = connection.getOutputStream();
        String acceptEncoding = connection.getRequestProperty("Accept-Encoding");
        if (TextUtils.equals((CharSequence)"gzip", (CharSequence)acceptEncoding)) {
            body = NetTaskQueue.compress(body);
        }
        outputStream.write(body);
        return new Connection(connection, null, outputStream){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                block9: {
                    try {
                        String errorBody;
                        int responseCode = this.connection.getResponseCode();
                        if (responseCode < 300) {
                            try {
                                String responseBody = NetTaskQueue.this.read(this.connection.getInputStream());
                                currentNetTask.onSuccess(responseBody);
                                break block9;
                            }
                            catch (IOException e) {
                                throw ShieldException.networkError(e);
                            }
                            catch (Exception e) {
                                throw ShieldException.unexpectedError(e);
                            }
                        }
                        try {
                            errorBody = NetTaskQueue.this.read(this.connection.getInputStream());
                        }
                        catch (IOException exception) {
                            errorBody = NetTaskQueue.this.read(this.connection.getErrorStream());
                        }
                        throw ShieldException.httpError(NetTaskQueue.this.getUrl(currentNetTask), responseCode, responseCode + ": " + this.connection.getResponseMessage(), errorBody);
                    }
                    finally {
                        super.close();
                        this.os.close();
                    }
                }
            }
        };
    }

    private Connection createGetConnection(HttpURLConnection connection, final NetTask currentNetTask) throws Exception {
        InputStream resultInputStream;
        block3: {
            resultInputStream = null;
            try {
                resultInputStream = connection.getInputStream();
            }
            catch (Exception e) {
                InputStream errorStream = connection.getErrorStream();
                if (errorStream == null) break block3;
                throw ShieldException.httpError(this.getUrl(currentNetTask), connection.getResponseCode(), connection.getResponseMessage(), this.read(errorStream));
            }
        }
        if (resultInputStream != null) {
            return new Connection(connection, resultInputStream, null){

                @Override
                public void close() throws IOException {
                    block7: {
                        try {
                            int responseCode = this.connection.getResponseCode();
                            if (responseCode < 300) {
                                try {
                                    String responseBody = NetTaskQueue.this.read(this.connection.getInputStream());
                                    currentNetTask.onSuccess(responseBody);
                                    break block7;
                                }
                                catch (IOException e) {
                                    throw ShieldException.networkError(e);
                                }
                                catch (Exception e) {
                                    throw ShieldException.unexpectedError(e);
                                }
                            }
                            throw ShieldException.httpError(NetTaskQueue.this.getUrl(currentNetTask), responseCode, this.connection.getResponseMessage(), "Something went wrong. HTTP CODE:" + responseCode);
                        }
                        finally {
                            super.close();
                            this.is.close();
                        }
                    }
                }
            };
        }
        return null;
    }

    private String constructFullUrl(NetTask currentNetTask) {
        if (currentNetTask.getBaseUrl() != null && currentNetTask.getBaseUrl().length() > 0) {
            return currentNetTask.getBaseUrl() + currentNetTask.getUrl();
        }
        return currentNetTask.getUrl();
    }

    private String getUrl(NetTask currentNetTask) {
        Map<String, Object> requestParams = currentNetTask.getRequestObject();
        String fullUrl = this.constructFullUrl(currentNetTask);
        if (currentNetTask.getMethod() == NetTask.Method.POST || requestParams == null || requestParams.entrySet().size() == 0) {
            return fullUrl;
        }
        StringBuilder stringBuilder = new StringBuilder(fullUrl + "?");
        for (Map.Entry<String, Object> entry : requestParams.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String && Utils.isNullOrEmpty((CharSequence)value)) continue;
            if (stringBuilder.length() != fullUrl.length() + 1) {
                stringBuilder.append('&');
            }
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    private byte[] getRequestBody(NetTask currentNetTask) throws Exception {
        Map<String, Object> requestBody = currentNetTask.getRequestObject();
        if (currentNetTask.getRequestType() == NetTask.RequestType.JSON) {
            JSONObject jsonObject = new JSONObject();
            for (Map.Entry<String, Object> entry : requestBody.entrySet()) {
                jsonObject.put(entry.getKey(), entry.getValue());
            }
            String payload = jsonObject.toString();
            return payload.getBytes("UTF-8");
        }
        if (currentNetTask.getRequestType() == NetTask.RequestType.TEXT && requestBody.get("data") != null) {
            String payload = requestBody.get("data").toString();
            return payload.getBytes("UTF-8");
        }
        StringBuilder postData = new StringBuilder();
        for (Map.Entry<String, Object> entry : requestBody.entrySet()) {
            String value = entry.getValue() instanceof String ? (String)entry.getValue() : String.valueOf(entry.getValue());
            if (Utils.isNullOrEmpty(value)) continue;
            if (postData.length() != 0) {
                postData.append('&');
            }
            postData.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            postData.append('=');
            postData.append(URLEncoder.encode(value, "UTF-8"));
        }
        return postData.toString().getBytes("UTF-8");
    }

    private HttpURLConnection openConnection(NetTask currentNetTask) throws Exception {
        HashMap<String, String> headers;
        String url = this.getUrl(currentNetTask);
        if (Utils.isNullOrEmpty(url)) {
            throw new IllegalArgumentException("url must not be null or empty");
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod(currentNetTask.getMethod().toString());
        connection.setRequestProperty("Api-Version", String.valueOf(1));
        if (currentNetTask.getMethod() == NetTask.Method.POST) {
            connection.setRequestProperty("Content-Type", currentNetTask.getRequestType().value);
        } else {
            connection.setRequestProperty("Accept", "text/plain");
        }
        connection.setRequestProperty("Api-Req-Time", String.valueOf(System.currentTimeMillis()));
        connection.setRequestProperty("Site-Id", currentNetTask.getSiteId());
        connection.setRequestProperty("X-Endpoint-Version", currentNetTask.getVersion());
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(20000);
        connection.setDoInput(true);
        if (currentNetTask.getMethod() == NetTask.Method.POST) {
            connection.setDoOutput(true);
        }
        if ((headers = currentNetTask.getRequestHeaders()) != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                if (entry.getKey().equals("Accept-Encoding")) continue;
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return connection;
    }

    private String read(InputStream is) throws IOException {
        String line;
        BufferedReader bf = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((line = bf.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    private static byte[] compress(byte[] body) throws Exception {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        gzip.write(body);
        gzip.close();
        return obj.toByteArray();
    }

    private static class NetworkThread
    extends Thread {
        private static final AtomicInteger SEQUENCE_GENERATOR = new AtomicInteger(1);

        NetworkThread(Runnable r) {
            super(r, "Shield" + SEQUENCE_GENERATOR.getAndIncrement());
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    private static class NetTaskThreadFactory
    implements ThreadFactory {
        private NetTaskThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new NetworkThread(r);
        }
    }

    public static class NetworkExecutorService
    extends ThreadPoolExecutor {
        private static final int DEFAULT_THREAD_COUNT = 1;
        private static final int MAX_THREAD_COUNT = 2;

        public NetworkExecutorService() {
            super(1, 2, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NetTaskThreadFactory());
        }
    }

    public static enum State {
        PENDING,
        FINISHED;

    }
}

