/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.nettask;

import com.shield.android.internal.InternalLogger;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACUtils {
    private static final char[] LOOKUP_TABLE_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] LOOKUP_TABLE_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    static String getShieldSignature(Long timeStamp, String siteId, String shieldSecretKey) {
        String hash = "";
        try {
            String timeHash = HMACUtils.computeSignature(timeStamp.toString(), shieldSecretKey);
            hash = HMACUtils.computeSignature(siteId, timeHash);
        }
        catch (GeneralSecurityException e) {
            InternalLogger.getInstance().error(e);
        }
        return hash;
    }

    private static String computeSignature(String baseString, String keyString) throws GeneralSecurityException {
        SecretKeySpec keySpec = new SecretKeySpec(keyString.getBytes(), "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(keySpec);
        byte[] hashBytes = mac.doFinal(baseString.getBytes());
        return HMACUtils.encode(hashBytes);
    }

    public static String encode(byte[] byteArray, boolean upperCase, ByteOrder byteOrder) {
        char[] buffer = new char[byteArray.length * 2];
        char[] lookup = upperCase ? LOOKUP_TABLE_UPPER : LOOKUP_TABLE_LOWER;
        for (int i = 0; i < byteArray.length; ++i) {
            int index = byteOrder == ByteOrder.BIG_ENDIAN ? i : byteArray.length - i - 1;
            buffer[i << 1] = lookup[byteArray[index] >> 4 & 0xF];
            buffer[(i << 1) + 1] = lookup[byteArray[index] & 0xF];
        }
        return new String(buffer);
    }

    public static String encode(byte[] byteArray) {
        return HMACUtils.encode(byteArray, false, ByteOrder.BIG_ENDIAN);
    }
}

