/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.nettask;

import com.shield.android.ShieldException;
import com.shield.android.internal.CSLogger;
import com.shield.android.nettask.HMACUtils;
import com.shield.android.nettask.NetTask;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public final class GetRiskAssessmentNetTask
extends NetTask {
    private static final String RISK_URL = "risk_score.php";
    private final String siteId;
    private final String secretKey;
    private final String environment;
    private final Map<String, Object> params = new HashMap<String, Object>();
    private final CSLogger logger;
    private static final List<String> environments = Arrays.asList("PROD", "DEV");
    public JSONObject result;
    public ShieldException responseError;

    public GetRiskAssessmentNetTask(String siteId, String secretKey, String environment, CSLogger logger) {
        this.siteId = siteId;
        this.secretKey = secretKey;
        this.environment = environment;
        this.logger = logger;
    }

    @Override
    protected HashMap<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("SEND_FROM_SDK", "1");
        headers.put("Site-Id", this.siteId);
        long timeStamp = System.currentTimeMillis() / 1000L;
        headers.put("Timestamp", String.valueOf(timeStamp));
        String shieldSignature = HMACUtils.getShieldSignature(timeStamp, this.siteId, this.secretKey);
        headers.put("Shield-Signature", shieldSignature);
        return headers;
    }

    @Override
    protected String getBaseUrl() {
        return String.format("https://%s.cashshield.com", this.siteId);
    }

    @Override
    protected String getUrl() {
        String chosenEnv = !"PROD".equals(this.environment) && environments.contains(this.environment) ? "devtest" : "live";
        return String.format("/%s/%s", chosenEnv, RISK_URL);
    }

    @Override
    protected NetTask.Method getMethod() {
        return NetTask.Method.POST;
    }

    @Override
    protected NetTask.RequestType getRequestType() {
        return NetTask.RequestType.JSON;
    }

    public void setRequestObject(Map<String, Object> requestObject) {
        this.params.clear();
        this.params.putAll(requestObject);
    }

    @Override
    protected Map<String, Object> getRequestObject() {
        return this.params;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
    }

    @Override
    protected String getSiteId() {
        return null;
    }

    @Override
    public void setVersion(String version) {
    }

    @Override
    protected String getVersion() {
        return null;
    }

    @Override
    protected void onSuccess(String response) {
        this.logger.debug(response, new Object[0]);
        try {
            JSONObject jsonObject = new JSONObject(response);
            String code = jsonObject.getString("code");
            if ("001".equals(code)) {
                this.result = jsonObject.getJSONObject("result");
            } else {
                this.responseError = ShieldException.httpError(this.getUrl(), Integer.valueOf(code), jsonObject.getString("message"), response);
            }
        }
        catch (Exception e) {
            this.responseError = ShieldException.unexpectedError(e);
        }
    }

    @Override
    protected void onFail(ShieldException exception) {
        if (exception.kind == ShieldException.Kind.HTTP) {
            this.logger.error(exception, "%s - %s", exception.message, exception.body);
        } else {
            this.logger.error(exception, exception.message, new Object[0]);
        }
        this.responseError = exception;
    }
}

