/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.nettask;

import com.shield.android.ShieldException;
import com.shield.android.internal.InternalLogger;
import com.shield.android.nettask.HMACUtils;
import com.shield.android.nettask.NetTask;
import java.util.HashMap;
import java.util.Map;

public class APICountNetTask
extends NetTask {
    private String sessionId;
    private String siteId;
    private String secretKey;
    private String baseUrl;
    private String version;

    public APICountNetTask(String siteId, String secretKey, String sessionId) {
        this.sessionId = sessionId;
        this.siteId = siteId;
        this.secretKey = secretKey;
    }

    @Override
    protected HashMap<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        long timeStamp = System.currentTimeMillis() / 1000L;
        headers.put("Timestamp", String.valueOf(timeStamp));
        headers.put("Site-Id", this.siteId);
        String shieldSignature = HMACUtils.getShieldSignature(timeStamp, this.siteId, this.secretKey);
        headers.put("Shield-Signature", shieldSignature);
        return headers;
    }

    @Override
    protected String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    protected String getSiteId() {
        return this.siteId;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    protected String getVersion() {
        return this.version;
    }

    @Override
    protected String getUrl() {
        return String.format("/shield-fp/v1/api/intelligence/%s", this.sessionId);
    }

    @Override
    protected NetTask.Method getMethod() {
        return NetTask.Method.GET;
    }

    @Override
    protected NetTask.RequestType getRequestType() {
        return null;
    }

    @Override
    protected Map<String, Object> getRequestObject() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("platform", "APP");
        params.put("sdk", true);
        return params;
    }

    @Override
    protected void onSuccess(String response) {
        InternalLogger.getInstance().info(response, new Object[0]);
    }

    @Override
    protected void onFail(ShieldException exception) {
        InternalLogger.getInstance().error(exception);
    }
}

