/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.location.LocationManager;
import android.text.TextUtils;
import androidx.core.app.ActivityCompat;
import androidx.core.location.LocationManagerCompat;
import com.google.android.gms.common.GoogleApiAvailability;
import com.shield.android.nettask.HMACUtils;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Random;

public final class Utils {
    private static int[] COLORS = new int[]{-256, -65536, -16711681, -16776961, -16711936, -16777216};
    private static String[] FONTS = new String[]{"CarroisGothicSC-Regular.ttf", "ComingSoon.ttf", "CutiveMono.ttf", "DancingScript-Bold.ttf", "DancingScript-Regular.ttf", "DroidSans-Bold.ttf", "DroidSans.ttf", "DroidSansMono.ttf", "NotoSansGeorgian-Bold.otf", "NotoSansGeorgian-Medium.otf", "NotoSansGeorgian-Regular.otf", "Roboto-Black.ttf", "Roboto-BlackItalic.ttf", "Roboto-Bold.ttf", "Roboto-BoldItalic.ttf", "Roboto-Italic.ttf", "Roboto-Medium.ttf", "Roboto-MediumItalic.ttf", "Roboto-Regular.ttf", "RobotoCondensed-Medium.ttf", "RobotoCondensed-MediumItalic.ttf", "RobotoCondensed-Regular.ttf", "SourceSansPro-Bold.ttf", "SourceSansPro-BoldItalic.ttf", "SourceSansPro-Italic.ttf", "SourceSansPro-Regular.ttf", "SourceSansPro-SemiBold.ttf", "SourceSansPro-SemiBoldItalic.ttf"};
    private static final String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static boolean hasPermission(Context context, String permission2) {
        return context.checkCallingOrSelfPermission(permission2) == 0;
    }

    public static boolean isNullOrEmpty(CharSequence text) {
        return TextUtils.isEmpty((CharSequence)text) || TextUtils.getTrimmedLength((CharSequence)text) == 0;
    }

    public static boolean isMoreThan128Characters(CharSequence text) {
        return text.length() > 128;
    }

    public static <T> T getSystemService(Context context, String serviceConstant) {
        return (T)context.getSystemService(serviceConstant);
    }

    public static boolean hasSelfPermission(Context context, String permission2) {
        return ActivityCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    public static boolean hasPackageNameInstalled(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        try {
            packageManager.getInstallerPackageName(packageName);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @SuppressLint(value={"PrivateApi"})
    public static String getValueFromPrivateApi(String className, String propertyName) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getDeclaredMethod("get", String.class);
            return (String)method.invoke(null, propertyName);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static Bitmap getNoiseBitmap() {
        Bitmap image = Bitmap.createBitmap((int)200, (int)120, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        image.eraseColor(-7829368);
        return Utils.applyFleaEffect(image);
    }

    private static Bitmap applyFleaEffect(Bitmap source) {
        int width = source.getWidth();
        int height = source.getHeight();
        int[] pixels = new int[width * height];
        source.getPixels(pixels, 0, width, 0, 0, width, height);
        Random random = new Random();
        int index = 0;
        int c = 0;
        int randColor = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (random.nextInt(101) < 60) continue;
                index = y * width + x;
                c = random.nextInt(255);
                randColor = Color.rgb((int)c, (int)c, (int)c);
                int n = index;
                pixels[n] = pixels[n] | randColor;
            }
        }
        Bitmap bmOut = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)source.getConfig());
        bmOut.setPixels(pixels, 0, width, 0, 0, width, height);
        Canvas canvas = new Canvas(bmOut);
        canvas.drawBitmap(bmOut, 0.0f, 0.0f, null);
        return bmOut;
    }

    private static int getRandomColor() {
        return COLORS[new Random().nextInt(COLORS.length)];
    }

    private static String getRandomFont() {
        return FONTS[new Random().nextInt(FONTS.length)];
    }

    public static Bitmap drawRandomStringOnBitmap(String drawText) {
        Bitmap result = Utils.getNoiseBitmap();
        Canvas canvas = new Canvas(result);
        canvas.drawBitmap(result, 0.0f, 0.0f, null);
        Paint paint = new Paint();
        for (int i = 0; i < drawText.toCharArray().length; ++i) {
            char c = drawText.toCharArray()[i];
            paint.setColor(Utils.getRandomColor());
            try {
                String fontPath = "/system/fonts/" + Utils.getRandomFont();
                Typeface typeface = Typeface.createFromFile((String)fontPath);
                paint.setTypeface(typeface);
            }
            catch (Exception fontPath) {
                // empty catch block
            }
            int textSize = new Random().nextInt(8) + 24;
            paint.setTextSize((float)textSize);
            canvas.drawText(String.valueOf(c), (float)(30 + i * 24), (float)(50 + new Random().nextInt(10) - 5), paint);
        }
        return result;
    }

    public static Bitmap drawChallengeOnBitmap(int firstNo, int secondNo) {
        Bitmap result = Utils.getNoiseBitmap();
        Canvas canvas = new Canvas(result);
        canvas.drawBitmap(result, 0.0f, 0.0f, null);
        Paint paint = new Paint();
        paint.setColor(-16777216);
        paint.setTextSize(24.0f);
        String drawText = firstNo + " + " + secondNo + " = ";
        canvas.drawText(drawText, 30.0f, 50.0f, paint);
        return result;
    }

    public static String randomString() {
        StringBuilder sb = new StringBuilder(6);
        for (int i = 0; i < 6; ++i) {
            sb.append(AB.charAt(new Random().nextInt(AB.length())));
        }
        return sb.toString();
    }

    public static String generateHash(String original) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] encodedHash = digest.digest(original.getBytes(Charset.forName("UTF-8")));
        return HMACUtils.encode(encodedHash);
    }

    public static boolean isLocationEnabled(Context context) {
        try {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            return LocationManagerCompat.isLocationEnabled((LocationManager)locationManager);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isGoogleLocationServiceExists(Context context) {
        try {
            Class.forName("com.google.android.gms.common.GoogleApiAvailability");
            Class.forName("com.google.android.gms.location.FusedLocationProviderClient");
            GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
            int resultCode = googleApiAvailability.isGooglePlayServicesAvailable(context);
            return resultCode == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isGoogleAdvertisingIdClientExists(Context context) {
        try {
            Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
            GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
            int resultCode = googleApiAvailability.isGooglePlayServicesAvailable(context);
            return resultCode == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAndroidxAdvertisingIdClientExists() {
        try {
            Class.forName("androidx.ads.identifier.AdvertisingIdClient");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

