/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.internal;

import com.shield.android.internal.InternalLogger;

public class NativeUtils {
    private static final String LIB_NAME = "shield-native-lib";
    private static boolean isLoaded;

    public NativeUtils() {
        try {
            System.loadLibrary(LIB_NAME);
            isLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            InternalLogger.getInstance().error(e);
        }
    }

    public boolean isLibraryLoaded() {
        if (isLoaded) {
            return true;
        }
        try {
            System.loadLibrary(LIB_NAME);
            isLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            InternalLogger.getInstance().error(e);
        }
        return isLoaded;
    }

    public native String getPv();

    public native String getPb();

    public native String getPayloadFormat();

    public native String getKeyFormat();

    public native String getPayloadTransformation();

    public native boolean isDetectedDevKeys();

    public native boolean isDetectedTestKeys();

    public native boolean isNotFoundReleaseKeys();

    public native boolean isFoundDangerousProps();

    public native boolean isPermissiveSelinux();

    public native boolean isSuExists();

    public native boolean isAccessedSuperuserApk();

    public native boolean isFoundSuBinary();

    public native boolean isFoundBusyboxBinary();

    public native boolean isFoundXposed();

    public native boolean isFoundResetprop();

    public native boolean isFoundWrongPathPermission();

    public native boolean listenForFrida();

    public native boolean isFoundMagisk();

    public native boolean isFoundSubstrate();

    public native byte[] getSuspiciousPackages();

    public native boolean isFridaDetected();

    public native boolean isTaichDetected();

    public native boolean isVirtualXposedDetected();

    public native boolean isSandHookDetected();

    public native void setLogDebugMessages(boolean var1);
}

