/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.internal;

import android.app.Application;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.shield.android.BuildConfig;
import com.shield.android.ShieldCallback;
import com.shield.android.ShieldException;
import com.shield.android.internal.Utils;
import com.shield.android.nettask.ErrorReportingNetTask;
import com.shield.android.nettask.NetTaskQueue;
import com.shield.android.repository.URLProvider;
import java.util.HashMap;

public final class InternalLogger {
    private static final String DEFAULT_TAG = "Shield";
    private final String tag;
    private boolean isLoggable;
    private static InternalLogger logger;
    private static Application application;
    private static ErrorReportingNetTask errorReportingNetTask;
    private static NetTaskQueue netTaskQueue;
    private static URLProvider urlProvider;
    private static boolean isBotCheck;

    private InternalLogger(String tag) {
        this.tag = Utils.isNullOrEmpty(tag) ? DEFAULT_TAG : tag;
        this.isLoggable = BuildConfig.DEBUG;
    }

    public void verbose(String format, Object ... extra) {
        if (this.isLoggable) {
            Log.v((String)this.tag, (String)String.format(format, extra));
        }
    }

    public void info(String format, Object ... extra) {
        if (this.isLoggable) {
            Log.i((String)this.tag, (String)String.format(format, extra));
        }
    }

    public void debug(String format, Object ... extra) {
        if (this.isLoggable) {
            Log.d((String)this.tag, (String)String.format(format, extra));
        }
    }

    public void error(Throwable error, String format, Object ... extra) {
        InternalLogger.sendLogToServer(error, isBotCheck, this.tag);
        if (this.isLoggable) {
            Log.e((String)this.tag, (String)String.format(format, extra), (Throwable)error);
        }
    }

    public void error(Throwable error) {
        InternalLogger.sendLogToServer(error, isBotCheck, this.tag);
        if (this.isLoggable) {
            if (error.getMessage() != null) {
                Log.e((String)this.tag, (String)error.getLocalizedMessage(), (Throwable)error);
            } else {
                Log.e((String)this.tag, (String)"", (Throwable)error);
            }
        }
    }

    public static void init(Application app, URLProvider up, NetTaskQueue nt, ErrorReportingNetTask et, boolean bc) {
        if (application == null) {
            application = app;
        }
        if (errorReportingNetTask == null) {
            errorReportingNetTask = et;
        }
        if (urlProvider == null) {
            urlProvider = up;
        }
        if (netTaskQueue == null) {
            netTaskQueue = nt;
        }
        isBotCheck = bc;
    }

    public static InternalLogger tag(String tag) {
        if (logger == null || !InternalLogger.logger.tag.equals(tag)) {
            logger = new InternalLogger(tag);
        }
        if (application == null) {
            logger.debug("Application is not initialized. There'll be no app_version", new Object[0]);
        }
        return logger;
    }

    public static InternalLogger getInstance() {
        if (logger == null || !InternalLogger.logger.tag.equals(DEFAULT_TAG)) {
            logger = new InternalLogger(DEFAULT_TAG);
        }
        return logger;
    }

    private static void sendLogToServer(Throwable error, boolean isBotCheck, String tag) {
        HashMap<String, Object> errorData = new HashMap<String, Object>();
        try {
            if (isBotCheck) {
                errorData.put("BOT_CHECK", true);
            }
            if (tag != null && !tag.equals(DEFAULT_TAG)) {
                errorData.put("tag", tag);
            }
            errorData.put("error_class", error.getClass().toString());
            errorData.put("message", error.getMessage());
            errorData.put("platform", "Android");
            errorData.put("sdk_version", "1.5.6");
            if (application != null) {
                try {
                    PackageInfo pInfo = application.getPackageManager().getPackageInfo(application.getPackageName(), 0);
                    String version = pInfo.versionName;
                    errorData.put("app_version", version);
                }
                catch (PackageManager.NameNotFoundException e) {
                    InternalLogger.getInstance().debug("Version name can't be found. Failing silently", new Object[0]);
                }
            }
            StackTraceElement[] elements = error.getStackTrace();
            StringBuilder stacktraceBuilder = new StringBuilder("Caused by " + error.toString());
            for (StackTraceElement element : elements) {
                stacktraceBuilder.append("\nat ").append(element.toString());
            }
            String stacktrace = stacktraceBuilder.toString();
            errorData.put("stacktrace", stacktrace);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (errorReportingNetTask != null) {
            errorReportingNetTask.setRequestObject(errorData);
            if (urlProvider != null) {
                try {
                    urlProvider.getUrl(new ShieldCallback<Pair<String, String>>(){

                        @Override
                        public void onSuccess(@Nullable Pair<String, String> data) {
                            if (data != null) {
                                errorReportingNetTask.setBaseUrl((String)data.first);
                                errorReportingNetTask.setVersion((String)data.second);
                                netTaskQueue.enqueue(errorReportingNetTask);
                            }
                        }

                        @Override
                        public void onFailure(@Nullable ShieldException ignored) {
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

