/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.internal;

import android.util.Base64;
import androidx.annotation.NonNull;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.NativeUtils;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtils {
    private NativeUtils nativeUtils;

    public CryptoUtils(NativeUtils nativeUtils) {
        this.nativeUtils = nativeUtils;
    }

    public String decryptPayload(@NonNull String input) throws Exception {
        String token = new String(this.decodeString(input));
        String[] tokens = this.split(token);
        String encryptedPayload = tokens[0];
        String decryptedKeys = this.decryptRSA(this.decodeString(tokens[1]));
        String[] keys = this.split(decryptedKeys);
        return this.decryptUsingAES(encryptedPayload, keys[0], keys[1]);
    }

    public String encryptPayload(@NonNull String input) throws Exception {
        if (!this.loadNativeLibrary()) {
            throw new UnsatisfiedLinkError("ndk not found");
        }
        KeyGenerator generator = KeyGenerator.getInstance(this.nativeUtils.getPayloadFormat());
        generator.init(256);
        SecretKey key = generator.generateKey();
        int ivSize = 16;
        byte[] iv = new byte[ivSize];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        String encryptedPayload = this.encryptUsingAES(input, iv, key);
        String encodedKey = this.bytesToString(this.encode(key.getEncoded()));
        String encodedIv = this.bytesToString(this.encode(iv));
        String keys = encodedIv + ":" + encodedKey;
        String encryptedKeys = this.encryptRSA(keys.getBytes());
        return this.bytesToString(this.encodeString(encryptedPayload + ":" + encryptedKeys));
    }

    private boolean loadNativeLibrary() {
        return this.nativeUtils.isLibraryLoaded();
    }

    private PrivateKey getPrivateKey() throws Exception {
        if (!this.loadNativeLibrary()) {
            throw new UnsatisfiedLinkError("ndk not found");
        }
        String pkcs8Pem = this.nativeUtils.getPv();
        pkcs8Pem = pkcs8Pem.replaceAll("\\s+", "");
        byte[] pkcs8EncodedBytes = this.decodeString(pkcs8Pem);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8EncodedBytes);
        KeyFactory kf = KeyFactory.getInstance(this.nativeUtils.getKeyFormat());
        return kf.generatePrivate(keySpec);
    }

    private PublicKey getPublicKey() throws Exception {
        if (!this.loadNativeLibrary()) {
            throw new UnsatisfiedLinkError("ndk not found");
        }
        String pkcs8Pem = this.nativeUtils.getPb();
        pkcs8Pem = pkcs8Pem.replaceAll("\\s+", "");
        byte[] pkcs8EncodedBytes = this.decodeString(pkcs8Pem);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pkcs8EncodedBytes);
        KeyFactory kf = KeyFactory.getInstance(this.nativeUtils.getKeyFormat());
        return kf.generatePublic(keySpec);
    }

    private String decryptRSA(byte[] encryptedBytes) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
        cipher.init(2, this.getPrivateKey());
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        return new String(decryptedBytes);
    }

    private String encryptRSA(byte[] encodedBytes) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
        cipher.init(1, this.getPublicKey());
        byte[] encryptedBytes = cipher.doFinal(encodedBytes);
        return this.bytesToString(this.encode(encryptedBytes));
    }

    private String decryptUsingAES(@NonNull String input, @NonNull String ivString, @NonNull String keyString) {
        if (!this.loadNativeLibrary()) {
            throw new UnsatisfiedLinkError("ndk not found");
        }
        byte[] base64decodedByteArray = this.decodeString(input);
        try {
            byte[] keyBytes = this.decodeString(keyString);
            byte[] ivBytes = this.decodeString(ivString);
            SecretKeySpec key = new SecretKeySpec(keyBytes, this.nativeUtils.getPayloadFormat());
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes);
            Cipher cipher = Cipher.getInstance(this.nativeUtils.getPayloadTransformation());
            cipher.init(2, (Key)key, ivParameterSpec);
            byte[] decodedByteArray = cipher.doFinal(base64decodedByteArray);
            return this.bytesToString(decodedByteArray);
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
            return "";
        }
    }

    private String encryptUsingAES(@NonNull String input, byte[] iv, SecretKey key) throws Exception {
        if (!this.loadNativeLibrary()) {
            throw new UnsatisfiedLinkError("ndk not found");
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(this.nativeUtils.getPayloadTransformation());
        cipher.init(1, (Key)key, ivParameterSpec);
        byte[] encryptedByte = cipher.doFinal(input.getBytes());
        return this.bytesToString(this.encode(encryptedByte));
    }

    private String bytesToString(byte[] bytes) throws Exception {
        return new String(bytes, "UTF-8");
    }

    private byte[] decodeString(@NonNull String input) {
        return Base64.decode((String)input, (int)2);
    }

    private byte[] encodeString(@NonNull String str) throws Exception {
        return Base64.encode((byte[])str.getBytes("UTF-8"), (int)2);
    }

    private byte[] encode(@NonNull byte[] input) {
        return Base64.encode((byte[])input, (int)2);
    }

    private String[] split(String string) {
        return string.split(":");
    }
}

