/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.internal;

import com.shield.android.Shield;
import com.shield.android.internal.InternalLogger;

public final class CSLogger {
    private static final String DEFAULT_TAG = "Shield";
    private final Shield.LogLevel logLevel;
    private final String tag;
    private static CSLogger logger;

    private CSLogger(String tag, Shield.LogLevel logLevel) {
        this.tag = tag;
        this.logLevel = logLevel;
    }

    public void verbose(String format, Object ... extra) {
        if (this.shouldLog(Shield.LogLevel.VERBOSE)) {
            InternalLogger.getInstance().verbose(format, extra);
        }
    }

    public void info(String format, Object ... extra) {
        if (this.shouldLog(Shield.LogLevel.INFO)) {
            InternalLogger.getInstance().info(format, extra);
        }
    }

    public void debug(String format, Object ... extra) {
        if (this.shouldLog(Shield.LogLevel.DEBUG)) {
            InternalLogger.getInstance().debug(format, extra);
        }
    }

    public void error(Throwable error, String format, Object ... extra) {
        if (this.shouldLog(Shield.LogLevel.INFO)) {
            InternalLogger.getInstance().error(error, format, extra);
        }
    }

    public CSLogger subLog(String tag) {
        return new CSLogger("Shield-" + tag, this.logLevel);
    }

    public static CSLogger with(String tag, Shield.LogLevel level) {
        if (logger == null) {
            logger = new CSLogger(DEFAULT_TAG, level);
        }
        return logger;
    }

    public static CSLogger with(Shield.LogLevel level) {
        if (logger == null) {
            logger = new CSLogger(DEFAULT_TAG, level);
        }
        return logger;
    }

    private boolean shouldLog(Shield.LogLevel level) {
        return this.logLevel.ordinal() >= level.ordinal();
    }
}

