/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.installreferral;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import com.shield.android.installreferral.IGetInstallReferrerService;
import com.shield.android.installreferral.InstallReferrerClient;
import com.shield.android.installreferral.InstallReferrerStateListener;
import com.shield.android.installreferral.ReferrerDetails;
import com.shield.android.internal.InternalLogger;
import java.util.List;

class InstallReferrerClientImpl
extends InstallReferrerClient {
    private final Context mApplicationContext;
    private int mClientState = 0;
    private IGetInstallReferrerService mService;
    private ServiceConnection mServiceConnection;

    public InstallReferrerClientImpl(Context context) {
        this.mApplicationContext = context.getApplicationContext();
    }

    public boolean isReady() {
        return this.mClientState == 2 && this.mService != null && this.mServiceConnection != null;
    }

    @Override
    public void startConnection(InstallReferrerStateListener listener) {
        if (this.isReady()) {
            InternalLogger.getInstance().debug("InstallReferrerClient", "Service connection is valid. No need to re-initialize.");
            listener.onInstallReferrerSetupFinished(0);
        } else if (this.mClientState == 1) {
            InternalLogger.getInstance().debug("InstallReferrerClient", "Client is already in the process of connecting to the service.");
            listener.onInstallReferrerSetupFinished(3);
        } else if (this.mClientState == 3) {
            InternalLogger.getInstance().debug("InstallReferrerClient", "Client was already closed and can't be reused. Please create another instance.");
            listener.onInstallReferrerSetupFinished(3);
        } else {
            InternalLogger.getInstance().debug("InstallReferrerClient", "Starting install referrer service setup.");
            this.mServiceConnection = new InstallReferrerServiceConnection(listener);
            Intent serviceIntent = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
            serviceIntent.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
            List intentServices = this.mApplicationContext.getPackageManager().queryIntentServices(serviceIntent, 0);
            if (intentServices != null && !intentServices.isEmpty()) {
                ResolveInfo resolveInfo = (ResolveInfo)intentServices.get(0);
                if (resolveInfo.serviceInfo != null) {
                    String packageName = resolveInfo.serviceInfo.packageName;
                    String className = resolveInfo.serviceInfo.name;
                    if ("com.android.vending".equals(packageName) && className != null && this.isPlayStoreCompatible()) {
                        if (this.mApplicationContext.bindService(new Intent(serviceIntent), this.mServiceConnection, 1)) {
                            InternalLogger.getInstance().debug("InstallReferrerClient", "Service was bonded successfully.");
                            return;
                        }
                        InternalLogger.getInstance().debug("InstallReferrerClient", "Connection to service is blocked.");
                        this.mClientState = 0;
                        listener.onInstallReferrerSetupFinished(1);
                        return;
                    }
                    InternalLogger.getInstance().debug("InstallReferrerClient", "Play Store missing or incompatible. Version 8.3.73 or later required.");
                    this.mClientState = 0;
                    listener.onInstallReferrerSetupFinished(2);
                    return;
                }
            }
            this.mClientState = 0;
            InternalLogger.getInstance().debug("InstallReferrerClient", "Install Referrer service unavailable on device.");
            listener.onInstallReferrerSetupFinished(2);
        }
    }

    @Override
    public void endConnection() {
        this.mClientState = 3;
        if (this.mServiceConnection != null) {
            InternalLogger.getInstance().debug("InstallReferrerClient", "Unbinding from service.");
            this.mApplicationContext.unbindService(this.mServiceConnection);
            this.mServiceConnection = null;
        }
        this.mService = null;
    }

    @Override
    public ReferrerDetails getInstallReferrer() throws RemoteException {
        if (this.isReady()) {
            Bundle paramsBundle = new Bundle();
            paramsBundle.putString("package_name", this.mApplicationContext.getPackageName());
            try {
                return new ReferrerDetails(this.mService.getInstallReferrer(paramsBundle));
            }
            catch (RemoteException e) {
                InternalLogger.getInstance().debug("InstallReferrerClient", "RemoteException getting install referrer information");
                this.mClientState = 0;
                throw e;
            }
        }
        throw new IllegalStateException("Service not connected. Please start a connection before using the service.");
    }

    private boolean isPlayStoreCompatible() {
        try {
            return this.mApplicationContext.getPackageManager().getPackageInfo((String)"com.android.vending", (int)128).versionCode >= 80837300;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private final class InstallReferrerServiceConnection
    implements ServiceConnection {
        private final InstallReferrerStateListener mListener;

        private InstallReferrerServiceConnection(InstallReferrerStateListener listener) {
            if (listener == null) {
                throw new RuntimeException("Please specify a listener to know when setup is done.");
            }
            this.mListener = listener;
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InternalLogger.getInstance().debug("InstallReferrerClient", "Install Referrer service connected.");
            InstallReferrerClientImpl.this.mService = IGetInstallReferrerService.Stub.asInterface(iBinder);
            InstallReferrerClientImpl.this.mClientState = 2;
            this.mListener.onInstallReferrerSetupFinished(0);
        }

        public void onServiceDisconnected(ComponentName componentName) {
            InternalLogger.getInstance().debug("InstallReferrerClient", "Install Referrer service disconnected.");
            InstallReferrerClientImpl.this.mService = null;
            InstallReferrerClientImpl.this.mClientState = 0;
            this.mListener.onInstallReferrerServiceDisconnected();
        }
    }
}

