/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.context;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.os.Environment;
import android.provider.ContactsContract;
import android.provider.MediaStore;
import com.shield.android.context.ContextMapper;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.Utils;
import java.util.concurrent.ConcurrentMap;

class UserRelatedContext
extends ContextMapper {
    private static final String PHOTOS_KEY = "PHOTOS";
    private static final String CONTACTS_KEY = "CONTACTS";
    private static final String CLIP_TEXT = "CLIP_TEXT";
    private final Context context;
    private static final Object clipboardMonitor = new Object();
    private transient boolean clipboardCompleted;
    private transient String clipText = "";

    UserRelatedContext(Context context) {
        this.context = context;
    }

    ConcurrentMap<String, String> getUserRelatedContext() {
        try {
            this.put(PHOTOS_KEY, this.getPhotos(this.context));
            this.put(CONTACTS_KEY, this.getContacts(this.context));
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return this.map();
    }

    private String getPhotos(Context context) {
        if (Utils.hasPermission(context, "android.permission.READ_EXTERNAL_STORAGE")) {
            try {
                String cameraBucketName = Environment.getExternalStorageDirectory().toString() + "/DCIM/Camera";
                String bucketId = String.valueOf(cameraBucketName.toLowerCase().hashCode());
                String[] projection = new String[]{"_data"};
                String selection = "bucket_id = ?";
                String[] selectionArgs = new String[]{bucketId};
                Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, "bucket_id = ?", selectionArgs, null);
                int count = cursor.getCount();
                cursor.close();
                return String.valueOf(count);
            }
            catch (Exception e) {
                return "error";
            }
        }
        return "disabled";
    }

    private String getContacts(Context context) {
        try {
            if (Utils.hasPermission(context, "android.permission.READ_CONTACTS")) {
                int count = 0;
                ContentResolver cr = context.getContentResolver();
                Cursor cur = cr.query(ContactsContract.Contacts.CONTENT_URI, null, null, null, null);
                if ((cur != null ? cur.getCount() : 0) > 0) {
                    count = cur.getCount();
                    cur.close();
                }
                if (cur != null) {
                    cur.close();
                }
                return String.valueOf(count);
            }
            return "disabled";
        }
        catch (Exception e) {
            return "error";
        }
    }
}

