/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.context;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.ads.identifier.AdvertisingIdInfo;
import androidx.core.content.ContextCompat;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.common.util.concurrent.ListenableFuture;
import com.shield.android.context.AppContext;
import com.shield.android.context.ContextMapper;
import com.shield.android.context.DeviceContext;
import com.shield.android.context.HeavyDataContext;
import com.shield.android.context.HookContext;
import com.shield.android.context.LocationContext;
import com.shield.android.context.NetworkContext;
import com.shield.android.context.SystemContext;
import com.shield.android.context.UserRelatedContext;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.NativeUtils;
import com.shield.android.internal.Utils;
import com.shield.android.listener.SendSignatureListener;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONObject;

public final class ShieldContext
extends ContextMapper {
    private static final String FW_VERSION_KEY = "FWVERSION";
    private static final String FW_BUILD_KEY = "FWBUILD";
    private static final String FW_FLAVOR = "FWFLAVOR";
    private static final String SITE_ID_KEY = "SITE_ID";
    private static final String SESSION_ID_KEY = "SESSION_ID";
    private static final String SESSION_CREATED_KEY = "SESSION_CREATED";
    private static final String IDFA_KEY = "IDFA";
    private static final String EXTRA_KEY = "EXTRA";
    private final String TAG = ShieldContext.class.getSimpleName();
    private final Context context;
    private final AppContext appContext;
    private final DeviceContext deviceContext;
    private final LocationContext locationContext;
    private final NetworkContext networkContext;
    private final SystemContext systemContext;
    private final UserRelatedContext userRelatedContext;
    private final HookContext hookContext;
    private final HeavyDataContext heavyDataContext;
    private final String siteId;
    private final String sessionId;
    private final String sessionCreated;
    private boolean heavyCollectionDone = false;
    private final Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShieldContext(Context context, String siteId, String sessionId, String sessionCreated, ConcurrentMap<String, String> cache, AppContext appContext, DeviceContext deviceContext, LocationContext locationContext, NetworkContext networkContext, SystemContext systemContext, UserRelatedContext userRelatedContext, HookContext hookContext, HeavyDataContext heavyDataContext) {
        super(cache);
        this.context = context;
        this.siteId = siteId;
        this.sessionId = sessionId;
        this.sessionCreated = sessionCreated;
        this.appContext = appContext;
        this.deviceContext = deviceContext;
        this.locationContext = locationContext;
        this.networkContext = networkContext;
        this.systemContext = systemContext;
        this.userRelatedContext = userRelatedContext;
        this.hookContext = hookContext;
        this.heavyDataContext = heavyDataContext;
        this.getAdvertisingId();
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.mutex.wait(500L);
            }
            catch (InterruptedException e) {
                InternalLogger.getInstance().error(e);
            }
        }
    }

    public static ShieldContext create(Context context, String siteId, String sessionId, String sessionCreated, String bypassCode, NativeUtils nativeUtils, boolean needLocationBackgroundListener) {
        LocationContext locationContext = new LocationContext(context, needLocationBackgroundListener);
        return new ShieldContext(context, siteId, sessionId, sessionCreated, new ConcurrentHashMap<String, String>(), new AppContext(context), new DeviceContext(context, nativeUtils), locationContext, new NetworkContext(context), new SystemContext(context, locationContext, bypassCode), new UserRelatedContext(context), new HookContext(nativeUtils), new HeavyDataContext(context));
    }

    public ConcurrentMap<String, String> getShieldContext() {
        InternalLogger.getInstance().debug("current thread %s", Thread.currentThread().getName());
        if (this.map().size() <= 1) {
            this.collectUnchangedContexts();
        } else if (!this.heavyCollectionDone) {
            this.collectHeavyDatas();
            this.heavyCollectionDone = true;
        }
        this.putAll(this.locationContext.getLocationContext());
        this.putAll(this.networkContext.getNetworkContext());
        this.putAll(this.systemContext.getSystemContext());
        this.putAll(this.userRelatedContext.getUserRelatedContext());
        this.putAll(this.hookContext.getHookContext());
        return this.map();
    }

    private void collectHeavyDatas() {
        try {
            this.putAll(this.heavyDataContext.getHeavyDataContext());
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
    }

    private void collectUnchangedContexts() {
        this.put(SITE_ID_KEY, this.siteId);
        this.put(SESSION_ID_KEY, this.sessionId);
        this.put(SESSION_CREATED_KEY, this.sessionCreated);
        this.put(FW_VERSION_KEY, "1.5.6");
        this.put(FW_BUILD_KEY, String.valueOf(1050600));
        this.put(FW_FLAVOR, this.matchFlavors("fraud"));
        this.put(EXTRA_KEY, this.getExtraFp(this.context));
        this.putAll(this.appContext.getAppContext());
        this.putAll(this.deviceContext.getDeviceContext());
    }

    private String matchFlavors(String buildFlavor) {
        if (buildFlavor == null) {
            return "lite";
        }
        try {
            if (buildFlavor.equalsIgnoreCase("full")) {
                return "fraud";
            }
            return "lite";
        }
        catch (Exception e) {
            return "error";
        }
    }

    private void getAdvertisingId() {
        Runnable runnable = () -> {
            try {
                if (Utils.isGoogleAdvertisingIdClientExists(this.context)) {
                    AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
                    if (adInfo.getId() == null || adInfo.getId().length() == 0) {
                        this.put(IDFA_KEY, "error");
                    } else {
                        this.put(IDFA_KEY, adInfo.getId());
                    }
                } else if (Utils.isAndroidxAdvertisingIdClientExists() && androidx.ads.identifier.AdvertisingIdClient.isAdvertisingIdProviderAvailable((Context)this.context)) {
                    ListenableFuture advertisingIdInfoListenableFuture = androidx.ads.identifier.AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
                    ((AdvertisingIdInfo)advertisingIdInfoListenableFuture.get()).getId();
                    if (((AdvertisingIdInfo)advertisingIdInfoListenableFuture.get()).getId().length() == 0) {
                        this.put(IDFA_KEY, "error");
                    } else {
                        this.put(IDFA_KEY, ((AdvertisingIdInfo)advertisingIdInfoListenableFuture.get()).getId());
                    }
                } else {
                    this.put(IDFA_KEY, "disabled");
                }
            }
            catch (Exception exception) {
                this.put(IDFA_KEY, "error");
                InternalLogger.getInstance().error(exception);
            }
            try {
                Object exception = this.mutex;
                synchronized (exception) {
                    this.mutex.notifyAll();
                }
            }
            catch (Exception e) {
                InternalLogger.getInstance().error(e);
            }
        };
        new Thread(runnable).start();
    }

    private String getExtraFp(Context context) {
        HashMap<String, String> combinedInfo = new HashMap<String, String>();
        try {
            combinedInfo.putAll(this.getBuildInfo(context));
        }
        catch (Exception e) {
            InternalLogger.tag(this.TAG).error(e);
        }
        return new JSONObject(combinedInfo).toString();
    }

    private HashMap<String, String> getBuildInfo(Context context) {
        HashMap<String, String> buildInfo = new HashMap<String, String>();
        try {
            buildInfo.put("build_board", Build.BOARD);
            buildInfo.put("build_bootloader", Build.BOOTLOADER);
            buildInfo.put("build_brand", Build.BRAND);
            if (Build.VERSION.SDK_INT < 21) {
                buildInfo.put("build_CPU_ABI", Build.CPU_ABI + "," + Build.CPU_ABI2);
            } else {
                buildInfo.put("build_CPU_ABI", TextUtils.join((CharSequence)",", (Object[])Build.SUPPORTED_ABIS));
            }
            buildInfo.put("build_device", Build.DEVICE);
            buildInfo.put("build_display", Build.DISPLAY);
            buildInfo.put("build_fingerprint", Build.FINGERPRINT);
            buildInfo.put("build_hardware", Build.HARDWARE);
            buildInfo.put("build_host", Build.HOST);
            buildInfo.put("build_id", Build.ID);
            buildInfo.put("build_manufacturer", Build.MANUFACTURER);
            buildInfo.put("build_model", Build.MODEL);
            buildInfo.put("build_product", Build.PRODUCT);
            buildInfo.put("build_tags", Build.TAGS);
            buildInfo.put("build_time", String.valueOf(Build.TIME));
            buildInfo.put("build_type", Build.TYPE);
            buildInfo.put("build_version_codename", Build.VERSION.CODENAME);
            buildInfo.put("build_version_incremental", Build.VERSION.INCREMENTAL);
            buildInfo.put("build_version_release", Build.VERSION.RELEASE);
            if (Build.VERSION.SDK_INT < 26) {
                buildInfo.put("build_serial", Build.SERIAL);
            } else if (Build.VERSION.SDK_INT < 29 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0) {
                buildInfo.put("build_serial", Build.getSerial());
            }
        }
        catch (Exception e) {
            InternalLogger.tag(this.TAG).error(e);
        }
        return buildInfo;
    }

    public void startFridaListener(SendSignatureListener sendSignatureListener) {
        if (this.deviceContext != null) {
            this.deviceContext.startFridaListener(sendSignatureListener);
        }
    }

    public void stopFridaListener() {
        if (this.deviceContext != null) {
            this.deviceContext.stopFridaListener();
        }
    }
}

