/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.context;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.shield.android.context.ContextMapper;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.Utils;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.util.concurrent.ConcurrentMap;

class NetworkContext
extends ContextMapper {
    private static final String CARRIER_KEY = "CARRIER";
    private static final String CARRIER_ISO_CODE_KEY = "CARRIER_ISO_CODE";
    private static final String CARRIER_COUNTRY_CODE_KEY = "CARRIER_COUNTRY_CODE";
    private static final String CARRIER_NETWORK_CODE_KEY = "CARRIER_NETWORK_CODE";
    private static final String GSM_CONNECTION_KEY = "GSM_CONNECTION";
    private static final String TELEPHONY_DEVICE_ID_KEY = "TELEPHONY_DEVICE_ID";
    private static final String IMSI_KEY = "IMSI";
    private static final String SIM_STATE = "SIM_STATE";
    private static final String IS_ROAMING = "IS_ROAMING";
    private static final String WIFI_IP_KEY = "WIFI_IP";
    private static final String WIFI_SSID_KEY = "WIFI_SSID";
    private static final String WIFI_BSSID_KEY = "WIFI_BSSID";
    private final Context context;

    NetworkContext(Context context) {
        this.context = context;
    }

    ConcurrentMap<String, String> getNetworkContext() {
        try {
            this.getCarrierName(this.context);
            this.getIMSI(this.context);
            this.put(WIFI_IP_KEY, this.getWifiIp(this.context));
            this.put(WIFI_SSID_KEY, this.getWifiSSID(this.context));
            this.put(WIFI_BSSID_KEY, this.getWifiBSSID(this.context));
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return this.map();
    }

    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    private void getCarrierName(Context context) {
        try {
            String mnc;
            String mcc;
            TelephonyManager manager = (TelephonyManager)Utils.getSystemService(context, "phone");
            String networkType = "disabled";
            if (Utils.hasSelfPermission(context, "android.permission.READ_PHONE_STATE")) {
                int nType = manager.getNetworkType();
                switch (nType) {
                    case 7: {
                        networkType = "1xRTT";
                        break;
                    }
                    case 4: {
                        networkType = "CDMA";
                        break;
                    }
                    case 2: {
                        networkType = "EDGE";
                        break;
                    }
                    case 14: {
                        networkType = "eHRPD";
                        break;
                    }
                    case 5: {
                        networkType = "EVDO rev. 0";
                        break;
                    }
                    case 6: {
                        networkType = "EVDO rev. A";
                        break;
                    }
                    case 12: {
                        networkType = "EVDO rev. B";
                        break;
                    }
                    case 1: {
                        networkType = "GPRS";
                        break;
                    }
                    case 8: {
                        networkType = "HSDPA";
                        break;
                    }
                    case 10: {
                        networkType = "HSPA";
                        break;
                    }
                    case 15: {
                        networkType = "HSPA+";
                        break;
                    }
                    case 9: {
                        networkType = "HSUPA";
                        break;
                    }
                    case 11: {
                        networkType = "iDen";
                        break;
                    }
                    case 13: {
                        networkType = "LTE";
                        break;
                    }
                    case 3: {
                        networkType = "UMTS";
                        break;
                    }
                    case 0: {
                        networkType = String.valueOf(nType);
                        break;
                    }
                    default: {
                        networkType = "";
                    }
                }
            }
            this.put(CARRIER_KEY, manager.getNetworkOperatorName());
            this.put(CARRIER_ISO_CODE_KEY, manager.getNetworkCountryIso());
            this.put(GSM_CONNECTION_KEY, networkType);
            String nOperator = this.getPrivateData("gsm.operator.numeric");
            if (!Utils.isNullOrEmpty(nOperator) && nOperator.length() > 3) {
                mcc = nOperator.substring(0, 3).replace(",", "");
                mnc = nOperator.substring(3).replace(",", "");
            } else {
                mnc = "";
                mcc = "";
            }
            this.put(CARRIER_COUNTRY_CODE_KEY, mcc);
            this.put(CARRIER_NETWORK_CODE_KEY, mnc);
            this.put(SIM_STATE, this.getPrivateData("gsm.sim.state"));
            this.put(IS_ROAMING, this.getPrivateData("gsm.operator.isroaming"));
            if (Utils.hasSelfPermission(context, "android.permission.READ_PHONE_STATE") && Build.VERSION.SDK_INT < 29) {
                if (Build.VERSION.SDK_INT < 26) {
                    this.put(TELEPHONY_DEVICE_ID_KEY, manager.getDeviceId());
                } else if (manager.getPhoneType() == 1) {
                    this.put(TELEPHONY_DEVICE_ID_KEY, manager.getImei());
                } else if (manager.getPhoneType() == 2) {
                    this.put(TELEPHONY_DEVICE_ID_KEY, manager.getMeid());
                }
            }
        }
        catch (Exception e) {
            InternalLogger.tag("CARRIER EXCEPTION").error(e);
        }
    }

    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    private void getIMSI(Context context) {
        TelephonyManager manager = (TelephonyManager)Utils.getSystemService(context, "phone");
        try {
            if (Utils.hasSelfPermission(context, "android.permission.READ_PHONE_STATE") && Build.VERSION.SDK_INT < 29 && manager.getSubscriberId() != null) {
                this.put(IMSI_KEY, manager.getSubscriberId());
            }
        }
        catch (Exception e) {
            InternalLogger.tag("CARRIER EXCEPTION").error(e);
        }
    }

    private String getWifiIp(Context context) {
        try {
            String ipAddressString;
            WifiManager wifiManager = (WifiManager)Utils.getSystemService(context, "wifi");
            if (!Utils.hasPermission(context, "android.permission.ACCESS_WIFI_STATE") || wifiManager.getConnectionInfo() == null) {
                return "disabled";
            }
            int ipAddress = wifiManager.getConnectionInfo().getIpAddress();
            if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                ipAddress = Integer.reverseBytes(ipAddress);
            }
            byte[] ipByteArray = BigInteger.valueOf(ipAddress).toByteArray();
            try {
                ipAddressString = InetAddress.getByAddress(ipByteArray).getHostAddress();
            }
            catch (UnknownHostException ex) {
                ipAddressString = "error";
            }
            return ipAddressString;
        }
        catch (Exception e) {
            return "error";
        }
    }

    private String getWifiSSID(Context context) {
        try {
            WifiManager wifiManager = (WifiManager)Utils.getSystemService(context, "wifi");
            if (Utils.hasPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                String ssid = Utils.isNullOrEmpty(wifiInfo.getSSID()) || "<unknown ssid>".equals(wifiInfo.getSSID()) ? "" : wifiInfo.getSSID();
                ssid = ssid.replaceAll("\"", "");
                return ssid;
            }
            return "disabled";
        }
        catch (Exception e) {
            return "error";
        }
    }

    private String getWifiBSSID(Context context) {
        try {
            WifiManager wifiManager = (WifiManager)Utils.getSystemService(context, "wifi");
            if (Utils.hasPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                return Utils.isNullOrEmpty(wifiInfo.getBSSID()) || "00:00:00:00:00:00".equals(wifiInfo.getBSSID()) ? "" : wifiInfo.getBSSID();
            }
            return "disabled";
        }
        catch (Exception e) {
            return "error";
        }
    }

    private String getPrivateData(String key) {
        return Utils.getValueFromPrivateApi("android.os.SystemProperties", key);
    }
}

