/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.context;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import com.shield.android.context.LocationRequestHelper;
import com.shield.android.context.LocationRequestHelperCallback;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.Utils;

public class LocationManagerRequestHelper
implements LocationRequestHelper {
    private final String TAG = LocationManagerRequestHelper.class.getSimpleName();
    private LocationRequestHelperCallback helperCallback;
    private LocationListener locationListener;
    private LocationManager locationManager;
    private Context context;
    private final int TIME_INTERVAL = 2000;
    private final int DISTANCE_INTERVAL = 0;

    public LocationManagerRequestHelper(Context context) {
        this.context = context;
        this.locationManager = (LocationManager)Utils.getSystemService(context, "location");
        this.locationListener = new LocationListener(){

            public void onLocationChanged(Location location) {
                if (LocationManagerRequestHelper.this.helperCallback != null && location != null) {
                    LocationManagerRequestHelper.this.helperCallback.getLocation(location);
                } else {
                    LocationManagerRequestHelper.this.startLocationRequest();
                }
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }

            public void onProviderEnabled(String provider) {
                InternalLogger.tag(LocationManagerRequestHelper.this.TAG).debug("Request updates from %s provider enabled.", provider);
            }

            public void onProviderDisabled(String provider) {
                InternalLogger.tag(LocationManagerRequestHelper.this.TAG).debug("Request updates from %s provider disabled", provider);
            }
        };
    }

    @Override
    public void setCallBack(LocationRequestHelperCallback callBack) {
        this.helperCallback = callBack;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void startLocationRequest() {
        Criteria criteria;
        String provider;
        if ((Utils.hasSelfPermission(this.context, "android.permission.ACCESS_FINE_LOCATION") || Utils.hasSelfPermission(this.context, "android.permission.ACCESS_COARSE_LOCATION")) && (provider = this.locationManager.getBestProvider(criteria = new Criteria(), true)) != null) {
            this.locationManager.requestLocationUpdates(provider, 2000L, 0.0f, this.locationListener, Looper.getMainLooper());
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void stopLocationRequest() {
        this.locationManager.removeUpdates(this.locationListener);
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public Location getLastKnownLocation() {
        try {
            Criteria criteria;
            String provider;
            if ((Utils.hasSelfPermission(this.context, "android.permission.ACCESS_FINE_LOCATION") || Utils.hasSelfPermission(this.context, "android.permission.ACCESS_COARSE_LOCATION")) && (provider = this.locationManager.getBestProvider(criteria = new Criteria(), true)) != null) {
                return this.locationManager.getLastKnownLocation(provider);
            }
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return null;
    }
}

