/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.context;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.shield.android.Shield;
import com.shield.android.context.ContextMapper;
import com.shield.android.context.FusedLocationRequestHelper;
import com.shield.android.context.LocationManagerRequestHelper;
import com.shield.android.context.LocationRequestHelper;
import com.shield.android.context.LocationRequestHelperCallback;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.Utils;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;

class LocationContext
extends ContextMapper
implements LocationRequestHelperCallback {
    private static final String LAT_LNG_KEY = "LATLNG";
    private LocationRequestHelper requestHelper;
    private final Context context;
    private Location lastKnownLocation;
    private boolean needLocationBackgroundListener;

    LocationContext(Context context, boolean needLocationBackgroundListener) {
        this.context = context;
        this.needLocationBackgroundListener = needLocationBackgroundListener;
        this.init();
    }

    private void init() {
        try {
            this.requestHelper = Utils.isGoogleLocationServiceExists(this.context) ? new FusedLocationRequestHelper(this.context) : new LocationManagerRequestHelper(this.context);
            this.requestHelper.setCallBack(this);
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
    }

    ConcurrentMap<String, String> getLocationContext() {
        try {
            if (!Utils.hasPermission(this.context, "android.permission.ACCESS_FINE_LOCATION") && !Utils.hasPermission(this.context, "android.permission.ACCESS_COARSE_LOCATION") || !Utils.isLocationEnabled(this.context)) {
                this.put(LAT_LNG_KEY, "disabled");
            } else {
                this.startCollectingLocation();
            }
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return this.map();
    }

    @RequiresApi(api=18)
    public boolean isLocationFake() {
        try {
            if (this.lastKnownLocation == null) {
                this.lastKnownLocation = this.requestHelper.getLastKnownLocation();
            }
            return this.lastKnownLocation != null && this.lastKnownLocation.isFromMockProvider();
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
            return false;
        }
    }

    private void startCollectingLocation() {
        try {
            this.requestHelper.startLocationRequest();
            this.lastKnownLocation = this.requestHelper.getLastKnownLocation();
            if (this.lastKnownLocation != null) {
                this.put(LAT_LNG_KEY, String.format("%.6f,%.6f", this.lastKnownLocation.getLatitude(), this.lastKnownLocation.getLongitude()));
            }
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public void getLocation(Location location) {
        try {
            if (location != null && this.lastKnownLocation != null && Build.VERSION.SDK_INT >= 18 && location.isFromMockProvider() != this.lastKnownLocation.isFromMockProvider()) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("event_name", "gps_provider_change_detected");
                Shield.getInstance().sendDeviceSignature("gps_provider", data);
            }
            this.lastKnownLocation = location;
            if (!this.needLocationBackgroundListener || Build.VERSION.SDK_INT >= 29 && !Utils.hasSelfPermission(this.context, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
                this.requestHelper.stopLocationRequest();
            }
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
    }
}

