/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.context;

import com.shield.android.BuildConfig;
import com.shield.android.context.ContextMapper;
import com.shield.android.internal.Hook;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.NativeUtils;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class HookContext
extends ContextMapper {
    private NativeUtils nativeUtils;
    private String regex = "([A-Za-z]{1}[A-Za-z\\d_]*\\.)+[A-Za-z][A-Za-z\\d_]*";

    public HookContext(NativeUtils nativeUtils) {
        this.nativeUtils = nativeUtils;
    }

    public ConcurrentMap<String, String> getHookContext() {
        try {
            if (this.nativeUtils.isLibraryLoaded()) {
                try {
                    this.nativeUtils.setLogDebugMessages(BuildConfig.DEBUG);
                    String REVERSED_TOOLS = "reversed_tools";
                    this.put(REVERSED_TOOLS, this.findHooks());
                }
                catch (Exception e) {
                    InternalLogger.getInstance().error(e);
                }
            }
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return this.map();
    }

    private String findHooks() {
        if (this.nativeUtils.isLibraryLoaded()) {
            try {
                Hook hook = new Hook();
                hook.isFoundFrida = this.nativeUtils.isFridaDetected();
                hook.isSandhookFound = this.nativeUtils.isSandHookDetected();
                hook.isFoundSubstrate = this.nativeUtils.isFoundSubstrate();
                hook.isFoundVirtualXposed = this.nativeUtils.isVirtualXposedDetected();
                hook.isFoundTaichi = this.nativeUtils.isTaichDetected();
                hook.suspiciousPackageNames = this.nativeUtils.getSuspiciousPackages();
                JSONObject jsonObject = new JSONObject();
                try {
                    String IS_FOUND_FRIDA = "is_found_frida";
                    jsonObject.put(IS_FOUND_FRIDA, hook.isFoundFrida || this.nativeUtils.isFridaDetected());
                    String IS_FOUND_SUBSTRATE = "is_found_substrate";
                    jsonObject.put(IS_FOUND_SUBSTRATE, hook.isFoundSubstrate);
                    String IS_SAND_HOOK_FFOUND = "is_found_sandhook";
                    jsonObject.put(IS_SAND_HOOK_FFOUND, hook.isSandhookFound);
                    String IS_VIRTUAL_XPOSED_FOUND = "is_found_virtual_xposed";
                    jsonObject.put(IS_VIRTUAL_XPOSED_FOUND, hook.isFoundVirtualXposed);
                    String IS_TAICHI_FOUND = "is_found_taichi";
                    jsonObject.put(IS_TAICHI_FOUND, hook.isFoundTaichi);
                    String SUSPICIOUS_PACKAGES = "suspicious_packages";
                    String rawSuspiciousPackages = "";
                    StringBuilder suspiciousPackages = new StringBuilder();
                    try {
                        rawSuspiciousPackages = new String(hook.suspiciousPackageNames);
                        if (rawSuspiciousPackages.length() > 0) {
                            String[] suspiciousPackagesList;
                            Pattern pattern = Pattern.compile(this.regex);
                            for (String packageString : suspiciousPackagesList = rawSuspiciousPackages.split("#")) {
                                String suspiciousPackage;
                                Matcher matcher = pattern.matcher(packageString);
                                if (!matcher.find() || (suspiciousPackage = matcher.toMatchResult().group(0)).contains("classes.dex") || suspiciousPackage.contains("base.apk") || suspiciousPackages.indexOf(suspiciousPackage) != -1) continue;
                                if (suspiciousPackages.length() > 0) {
                                    suspiciousPackages.append(", ").append(matcher.toMatchResult().group(0));
                                    continue;
                                }
                                suspiciousPackages.append(matcher.toMatchResult().group(0));
                            }
                        }
                    }
                    catch (Exception e) {
                        InternalLogger.getInstance().error(e);
                    }
                    jsonObject.put(SUSPICIOUS_PACKAGES, (Object)suspiciousPackages.toString());
                }
                catch (Exception e) {
                    InternalLogger.getInstance().error(e);
                }
                return jsonObject.toString();
            }
            catch (Exception e) {
                InternalLogger.getInstance().error(e);
            }
        }
        return "";
    }
}

