/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.context;

import android.app.usage.StorageStatsManager;
import android.content.Context;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import com.shield.android.context.ContextMapper;
import com.shield.android.internal.InternalLogger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONException;
import org.json.JSONObject;

class HeavyDataContext
extends ContextMapper {
    private Context context;
    private static final String CURRENT_RINGTONE = "CURRENT_RINGTONE";

    public HeavyDataContext(Context context) {
        this.context = context;
    }

    ConcurrentMap<String, String> getHeavyDataContext() {
        try {
            this.put(CURRENT_RINGTONE, this.getCurrentRingTone(this.context));
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return this.map();
    }

    private String getDiskSpace() {
        try {
            JSONObject data = new JSONObject();
            StatFs systemStatFs = new StatFs(Environment.getRootDirectory().getAbsolutePath());
            long systemTotal = 0L;
            long systemFree = 0L;
            StatFs internalStatFs = new StatFs(Environment.getDataDirectory().getAbsolutePath());
            long internalTotal = 0L;
            long internalFree = 0L;
            if (Build.VERSION.SDK_INT >= 26) {
                StorageStatsManager storageStatsManager = (StorageStatsManager)this.context.getSystemService("storagestats");
                StorageManager storageManager = (StorageManager)this.context.getSystemService("storage");
                try {
                    List storageVolumes = storageManager.getStorageVolumes();
                    for (StorageVolume storageVolume : storageVolumes) {
                        String uuidStr = storageVolume.getUuid();
                        UUID uuid = uuidStr == null ? StorageManager.UUID_DEFAULT : UUID.fromString(uuidStr);
                        internalTotal = storageStatsManager.getTotalBytes(uuid);
                        internalFree = storageStatsManager.getFreeBytes(uuid);
                    }
                }
                catch (Exception e) {
                    InternalLogger.getInstance().error(e);
                }
            } else if (Build.VERSION.SDK_INT >= 18) {
                systemTotal = systemStatFs.getBlockCountLong() * systemStatFs.getBlockSizeLong();
                systemFree = systemStatFs.getAvailableBlocksLong() * systemStatFs.getBlockSizeLong();
                internalTotal = internalStatFs.getBlockCountLong() * internalStatFs.getBlockSizeLong();
                internalFree = internalStatFs.getAvailableBlocksLong() * internalStatFs.getBlockSizeLong();
            } else {
                systemTotal = (long)systemStatFs.getBlockCount() * (long)systemStatFs.getBlockSize();
                systemFree = (long)systemStatFs.getAvailableBlocks() * (long)systemStatFs.getBlockSize();
                internalTotal = (long)internalStatFs.getBlockCount() * (long)internalStatFs.getBlockSize();
                internalFree = (long)internalStatFs.getAvailableBlocks() * (long)internalStatFs.getBlockSize();
            }
            NumberFormat formatter = DecimalFormat.getNumberInstance();
            formatter.setMinimumFractionDigits(2);
            formatter.setMaximumFractionDigits(2);
            String total = formatter.format((float)(internalTotal + systemTotal) / 1.0E9f);
            String free = formatter.format((float)(internalFree + systemFree) / 1.0E9f);
            try {
                data.put("total", (Object)total);
                data.put("free", (Object)free);
            }
            catch (JSONException e) {
                InternalLogger.getInstance().error(e);
            }
            return data.toString();
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
            return "";
        }
    }

    private String getCurrentRingTone(Context context) {
        try {
            Uri defaultRingtoneUri = RingtoneManager.getActualDefaultRingtoneUri((Context)context.getApplicationContext(), (int)1);
            Ringtone defaultRingtone = RingtoneManager.getRingtone((Context)context, (Uri)defaultRingtoneUri);
            return defaultRingtone.getTitle(context);
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
            return "";
        }
    }
}

