/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.context;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.SettingsClient;
import com.shield.android.context.LocationRequestHelper;
import com.shield.android.context.LocationRequestHelperCallback;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.Utils;

public class FusedLocationRequestHelper
implements LocationRequestHelper {
    private static final long UPDATE_INTERVAL_IN_MILLISECONDS = 400L;
    private static final long FASTEST_UPDATE_INTERVAL_IN_MILLISECONDS = 200L;
    private FusedLocationProviderClient locationProviderClient;
    private LocationRequest locationRequest;
    private LocationSettingsRequest locationSettingsRequest;
    private LocationCallback locationCallback;
    private Context context;
    private SettingsClient settingsClient;
    private boolean mRequestingLocationUpdates = false;
    private LocationRequestHelperCallback helperCallback;
    private final Object mutex = new Object();
    private Location lastLocation = null;

    public FusedLocationRequestHelper(Context context) {
        this.context = context;
        this.init();
    }

    private void init() {
        this.locationProviderClient = LocationServices.getFusedLocationProviderClient((Context)this.context);
        this.settingsClient = LocationServices.getSettingsClient((Context)this.context);
        this.locationRequest = LocationRequest.create();
        this.locationRequest.setPriority(100);
        this.locationRequest.setInterval(400L);
        this.locationRequest.setFastestInterval(200L);
        this.locationCallback = new LocationCallback(){

            public void onLocationResult(LocationResult locationResult) {
                super.onLocationResult(locationResult);
                if (locationResult != null && locationResult.getLastLocation() != null && FusedLocationRequestHelper.this.helperCallback != null) {
                    Location currentLocation = locationResult.getLastLocation();
                    FusedLocationRequestHelper.this.helperCallback.getLocation(currentLocation);
                } else {
                    FusedLocationRequestHelper.this.startLocationRequest();
                }
            }
        };
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder();
        builder.addLocationRequest(this.locationRequest);
        this.locationSettingsRequest = builder.build();
    }

    @Override
    public void setCallBack(LocationRequestHelperCallback helperCallback) {
        this.helperCallback = helperCallback;
    }

    @Override
    public void startLocationRequest() {
        if (Utils.hasPermission(this.context, "android.permission.ACCESS_FINE_LOCATION") && Utils.hasPermission(this.context, "android.permission.ACCESS_COARSE_LOCATION")) {
            this.mRequestingLocationUpdates = true;
            this.startLocationUpdates();
        }
    }

    @Override
    public void stopLocationRequest() {
        this.stopLocationUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressLint(value={"MissingPermission"})
    public Location getLastKnownLocation() {
        try {
            this.locationProviderClient.getLastLocation().addOnCompleteListener(task -> {
                try {
                    this.lastLocation = (Location)task.getResult();
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
                Object object = this.mutex;
                synchronized (object) {
                    try {
                        this.mutex.notifyAll();
                    }
                    catch (Exception e) {
                        InternalLogger.getInstance().error(e);
                    }
                }
            });
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.mutex.wait(2000L);
                }
                catch (InterruptedException e) {
                    InternalLogger.getInstance().error(e);
                }
            }
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return this.lastLocation;
    }

    @SuppressLint(value={"MissingPermission"})
    private void startLocationUpdates() {
        if (!this.mRequestingLocationUpdates) {
            return;
        }
        this.settingsClient.checkLocationSettings(this.locationSettingsRequest).addOnSuccessListener(locationSettingsResponse -> {
            try {
                this.locationProviderClient.requestLocationUpdates(this.locationRequest, this.locationCallback, Looper.getMainLooper());
            }
            catch (Exception e) {
                InternalLogger.getInstance().error(e);
            }
        });
    }

    private void stopLocationUpdates() {
        if (!this.mRequestingLocationUpdates) {
            return;
        }
        try {
            this.locationProviderClient.removeLocationUpdates(this.locationCallback).addOnCompleteListener(task -> {
                this.mRequestingLocationUpdates = false;
            });
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
    }
}

