/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.context;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.UiModeManager;
import android.app.WallpaperManager;
import android.app.usage.StorageStatsManager;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.SensorManager;
import android.media.MediaDrm;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.provider.Settings;
import android.util.Base64;
import com.shield.android.context.ContextMapper;
import com.shield.android.context.FindTaint;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.NativeUtils;
import com.shield.android.internal.Utils;
import com.shield.android.listener.SendSignatureListener;
import com.shield.android.nettask.HMACUtils;
import com.shield.android.rootchecker.RootChecker;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.NetworkInterface;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

class DeviceContext
extends ContextMapper {
    private static final String DEVICE_UUID_KEY = "DEVICE_UUID";
    private static final String BRAND_KEY = "BRAND";
    private static final String DEVICE_MODEL_KEY = "DEVICE_MODEL";
    private static final String OS_BUILD_NUMBER_KEY = "OS_BUILD_NUMBER";
    private static final String CPU_KEY = "CPU";
    private static final String DEVICE_NAME_KEY = "DEVICE_NAME";
    private static final String JAIL_BROKEN_KEY = "JAILBROKEN";
    private static final String CPU_INFO_KEY = "CPU_INFO";
    private static final String PROXIMITY_KEY = "PROXIMITY";
    private static final String TAINT_DROID_KEY = "TAINT_DETECTED";
    private static final String MAC_ADDRESSES_KEY = "MAC_ADDRESSES";
    private static final String DEVICE_TYPE = "DEVICE_TYPE";
    private static final String DISKSPACE = "DISKSPACE";
    private static final String RAMSIZE = "RAMSIZE";
    private static final String FILEPATHS = "FILE_PATHS";
    private static final String WALLPAPER = "WALLPAPER";
    private static final String DRM_ID = "DRM_ID";
    private static final String TAG = DeviceContext.class.getSimpleName();
    private final Context context;
    private final NativeUtils nativeUtils;
    private RootChecker rootChecker;
    private ScheduledThreadPoolExecutor threadPoolExecutor;

    DeviceContext(Context context, NativeUtils nativeUtils) {
        this.context = context;
        this.nativeUtils = nativeUtils;
        if (this.nativeUtils.isLibraryLoaded()) {
            this.rootChecker = new RootChecker(nativeUtils);
        }
    }

    void startFridaListener(SendSignatureListener sendSignatureListener) {
        if (this.shouldRunFridaListener()) {
            if (this.threadPoolExecutor == null) {
                this.threadPoolExecutor = new ScheduledThreadPoolExecutor(1);
            }
            this.threadPoolExecutor.scheduleWithFixedDelay(() -> {
                boolean frida_detected = this.nativeUtils.listenForFrida();
                if (frida_detected) {
                    if (sendSignatureListener != null) {
                        sendSignatureListener.shouldSendSignature();
                    }
                    this.threadPoolExecutor.shutdownNow();
                    this.threadPoolExecutor = null;
                }
            }, 5000L, 5000L, TimeUnit.MILLISECONDS);
        }
    }

    void stopFridaListener() {
        if (this.threadPoolExecutor != null && !this.threadPoolExecutor.isShutdown()) {
            this.threadPoolExecutor.shutdownNow();
            this.threadPoolExecutor = null;
        }
    }

    private boolean shouldRunFridaListener() {
        return this.rootChecker != null && this.rootChecker.shouldRunFridaListener();
    }

    ConcurrentMap<String, String> getDeviceContext() {
        try {
            this.put(JAIL_BROKEN_KEY, this.getJailbroken());
            this.put(FILEPATHS, this.getStoragePaths(this.context));
            this.put(DEVICE_UUID_KEY, this.getDeviceId(this.context));
            this.put(BRAND_KEY, Build.BRAND);
            this.put(DEVICE_MODEL_KEY, Build.MODEL);
            this.put(DEVICE_TYPE, this.getDeviceType(this.context));
            this.put(OS_BUILD_NUMBER_KEY, Build.FINGERPRINT);
            this.put(CPU_KEY, System.getProperty("os.arch"));
            this.put(DEVICE_NAME_KEY, this.getDeviceName(this.context));
            this.put(CPU_INFO_KEY, this.getCpuInfo());
            this.put(PROXIMITY_KEY, this.getProximitySensor(this.context));
            this.put(TAINT_DROID_KEY, this.isTaintTrackingDetected(this.context));
            this.put(MAC_ADDRESSES_KEY, this.getMACAddresses(this.context));
            this.put(WALLPAPER, DeviceContext.compress(this.getWallpaper(this.context)));
            this.put(DISKSPACE, this.getDiskSpace());
            this.put(RAMSIZE, this.getRamSize());
            this.put(DRM_ID, this.getDrmId());
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return this.map();
    }

    private String getStoragePaths(Context context) {
        JSONObject pathObj = new JSONObject();
        try {
            String filePath = context.getFilesDir().getAbsolutePath();
            String cachePath = context.getCacheDir().getAbsolutePath();
            String externalFileDir = "";
            String externalCacheDir = "";
            String dataDir = "";
            try {
                if (context.getExternalFilesDir(null) != null) {
                    externalFileDir = Objects.requireNonNull(context.getExternalFilesDir(null)).getAbsolutePath();
                }
            }
            catch (Exception e) {
                InternalLogger.getInstance().error(e);
            }
            if (context.getExternalCacheDir() != null) {
                externalCacheDir = context.getExternalCacheDir().getAbsolutePath();
            }
            if (Build.VERSION.SDK_INT >= 24) {
                dataDir = context.getDataDir().getAbsolutePath();
            }
            pathObj.put("file_path", (Object)filePath);
            pathObj.put("cache_path", (Object)cachePath);
            pathObj.put("external_file_dir", (Object)externalFileDir);
            pathObj.put("external_cache_dir", (Object)externalCacheDir);
            pathObj.put("data_dir", (Object)dataDir);
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return pathObj.toString();
    }

    @SuppressLint(value={"HardwareIds"})
    private String getDeviceId(Context context) {
        try {
            String deviceId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            if (Utils.isNullOrEmpty(deviceId)) {
                return "";
            }
            return deviceId;
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
            return "";
        }
    }

    private String getDeviceName(Context context) {
        try {
            if (Utils.hasPermission(context, "android.permission.BLUETOOTH")) {
                try {
                    BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                    return mBluetoothAdapter == null ? "" : (mBluetoothAdapter.getName() == null ? "" : mBluetoothAdapter.getName());
                }
                catch (Throwable e) {
                    return "error";
                }
            }
            return "disabled";
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
            return "";
        }
    }

    private String getJailbroken() {
        InternalLogger.getInstance().debug("Getting Jail Broken", new Object[0]);
        try {
            InternalLogger.getInstance().debug("Calling Jail  Broken", new Object[0]);
            return this.rootChecker.isRooted();
        }
        catch (Exception e) {
            InternalLogger.tag(TAG).error(e);
            return "";
        }
    }

    private String getCpuInfo() {
        try {
            String[] data = new String[]{"/system/bin/cat", "/proc/cpuinfo"};
            return this.readSysFile(data).replaceAll("[^A-Za-z0-9 \\s\\-_.]+", "");
        }
        catch (Exception e) {
            InternalLogger.tag(TAG).error(e);
            return "";
        }
    }

    private String readSysFile(String[] data) {
        try {
            StringBuilder result = new StringBuilder();
            byte[] byteArr = new byte[1024];
            ProcessBuilder processBuilder = new ProcessBuilder(data);
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            while (inputStream.read(byteArr) != -1) {
                result.append(new String(byteArr));
            }
            inputStream.close();
            return result.toString();
        }
        catch (Exception e) {
            InternalLogger.tag(TAG).error(e);
            return "";
        }
    }

    private String getProximitySensor(Context context) {
        try {
            SensorManager mSensorManager = (SensorManager)Utils.getSystemService(context, "sensor");
            return mSensorManager.getDefaultSensor(8) == null ? "0" : "1";
        }
        catch (Exception e) {
            InternalLogger.tag(TAG).error(e);
            return "";
        }
    }

    private String isTaintTrackingDetected(Context context) {
        JSONObject payload = new JSONObject();
        try {
            payload.put("has_package", FindTaint.hasAppAnalysisPackage(context));
            payload.put("has_class", FindTaint.hasTaintClass());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return payload.toString();
    }

    @SuppressLint(value={"HardwareIds"})
    private String getMACAddresses(Context context) {
        String value;
        ArrayList<String> addresses = new ArrayList<String>();
        try {
            WifiManager wifiManager = (WifiManager)Utils.getSystemService(context, "wifi");
            if (wifiManager != null && Utils.hasPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
                WifiInfo wifi = wifiManager.getConnectionInfo();
                if (wifi != null) {
                    value = wifi.getMacAddress();
                    if (value != null) {
                        addresses.add(value.replace(":", ""));
                    } else {
                        InternalLogger.tag(TAG).debug("Fail to get wifi message", new Object[0]);
                    }
                } else {
                    InternalLogger.tag(TAG).debug("Wi-Fi not enabled, skipping.", new Object[0]);
                }
            } else {
                InternalLogger.tag(TAG).debug("Wi-Fi is not a supported system service", new Object[0]);
                addresses.add("disabled");
            }
        }
        catch (Exception e) {
            InternalLogger.tag(TAG).debug("Wi-Fi permission denied.", new Object[0]);
            addresses.add("error");
        }
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> niEnum = NetworkInterface.getNetworkInterfaces();
            while (niEnum.hasMoreElements()) {
                NetworkInterface ni = niEnum.nextElement();
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                for (byte b : mac) {
                    sb.append(String.format("%02X", b));
                }
            }
            addresses.add(sb.toString());
        }
        catch (Exception e) {
            InternalLogger.tag(TAG).error(e);
            addresses.add("error");
        }
        Collections.sort(addresses);
        if (addresses.size() <= 0) {
            return "";
        }
        StringBuilder macList = new StringBuilder("{");
        for (String address : addresses) {
            if (macList.length() > 1) {
                macList.append(",");
            }
            value = address;
            macList.append(value);
        }
        macList.append("}");
        return macList.toString();
    }

    private String getDeviceType(Context context) {
        try {
            UiModeManager uiModeManager = (UiModeManager)context.getSystemService("uimode");
            if (uiModeManager.getCurrentModeType() == 4) {
                return "tv";
            }
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        if (this.isTablet(context)) {
            return "tablet";
        }
        return "phone";
    }

    private boolean isTablet(Context context) {
        try {
            return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getDiskSpace() {
        try {
            JSONObject data = new JSONObject();
            StatFs systemStatFs = new StatFs(Environment.getRootDirectory().getAbsolutePath());
            long systemTotal = 0L;
            long systemFree = 0L;
            StatFs internalStatFs = new StatFs(Environment.getDataDirectory().getAbsolutePath());
            long internalTotal = 0L;
            long internalFree = 0L;
            if (Build.VERSION.SDK_INT >= 26) {
                StorageStatsManager storageStatsManager = (StorageStatsManager)this.context.getSystemService("storagestats");
                StorageManager storageManager = (StorageManager)this.context.getSystemService("storage");
                try {
                    List storageVolumes = storageManager.getStorageVolumes();
                    for (StorageVolume storageVolume : storageVolumes) {
                        String uuidStr = storageVolume.getUuid();
                        UUID uuid = uuidStr == null ? StorageManager.UUID_DEFAULT : UUID.fromString(uuidStr);
                        internalTotal = storageStatsManager.getTotalBytes(uuid);
                        internalFree = storageStatsManager.getFreeBytes(uuid);
                    }
                }
                catch (Exception e) {
                    InternalLogger.getInstance().error(e);
                }
            } else if (Build.VERSION.SDK_INT >= 18) {
                systemTotal = systemStatFs.getBlockCountLong() * systemStatFs.getBlockSizeLong();
                systemFree = systemStatFs.getAvailableBlocksLong() * systemStatFs.getBlockSizeLong();
                internalTotal = internalStatFs.getBlockCountLong() * internalStatFs.getBlockSizeLong();
                internalFree = internalStatFs.getAvailableBlocksLong() * internalStatFs.getBlockSizeLong();
            } else {
                systemTotal = (long)systemStatFs.getBlockCount() * (long)systemStatFs.getBlockSize();
                systemFree = (long)systemStatFs.getAvailableBlocks() * (long)systemStatFs.getBlockSize();
                internalTotal = (long)internalStatFs.getBlockCount() * (long)internalStatFs.getBlockSize();
                internalFree = (long)internalStatFs.getAvailableBlocks() * (long)internalStatFs.getBlockSize();
            }
            NumberFormat formatter = DecimalFormat.getNumberInstance(Locale.ENGLISH);
            formatter.setMinimumFractionDigits(2);
            formatter.setMaximumFractionDigits(2);
            String total = formatter.format((float)(internalTotal + systemTotal) / 1.0E9f);
            String free = formatter.format((float)(internalFree + systemFree) / 1.0E9f);
            String userStorageTotalString = "error";
            try {
                long userStorageTotal = (long)internalStatFs.getBlockCount() * (long)internalStatFs.getBlockSize();
                userStorageTotalString = formatter.format((float)userStorageTotal / 1.0E9f);
            }
            catch (Exception userStorageTotal) {
                // empty catch block
            }
            try {
                data.put("total", (Object)total);
                data.put("free", (Object)free);
                data.put("user_storage_total", (Object)userStorageTotalString);
            }
            catch (JSONException e) {
                InternalLogger.getInstance().error(e);
            }
            return data.toString();
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
            return "";
        }
    }

    private String getRamSize() {
        try {
            if (Build.VERSION.SDK_INT >= 16) {
                JSONObject data = new JSONObject();
                ActivityManager actManager = (ActivityManager)this.context.getSystemService("activity");
                ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
                actManager.getMemoryInfo(memInfo);
                long totalMemory = memInfo.totalMem;
                long freeMemory = memInfo.availMem;
                NumberFormat formatter = DecimalFormat.getNumberInstance();
                formatter.setMinimumFractionDigits(2);
                formatter.setMaximumFractionDigits(2);
                String total = formatter.format((float)totalMemory / 1.0E9f);
                String free = formatter.format((float)freeMemory / 1.0E9f);
                try {
                    data.put("total", (Object)total);
                    data.put("free", (Object)free);
                    return data.toString();
                }
                catch (JSONException e) {
                    InternalLogger.getInstance().error(e);
                    return "";
                }
            }
            return this.getTotalRAMOldAndroid();
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
            return "";
        }
    }

    private String getTotalRAMOldAndroid() {
        RandomAccessFile reader = null;
        String load = null;
        DecimalFormat twoDecimalForm = new DecimalFormat("#.##");
        double totRam = 0.0;
        double freeRam = 0.0;
        JSONObject data = new JSONObject();
        try {
            reader = new RandomAccessFile("/proc/meminfo", "r");
            load = reader.readLine();
            Pattern p = Pattern.compile("(\\d+)");
            Matcher m = p.matcher(load);
            String value = "";
            String freeValue = "";
            while (m.find()) {
                value = m.group(1);
            }
            load = reader.readLine();
            m = p.matcher(load);
            while (m.find()) {
                freeValue = m.group(1);
            }
            reader.close();
            if (value != null) {
                totRam = Double.parseDouble(value);
            }
            if (freeValue != null) {
                freeRam = Double.parseDouble(freeValue);
            }
            double gb = totRam / 1000000.0;
            double freeGb = freeRam / 1000000.0;
            data.put("total", (Object)twoDecimalForm.format(gb));
            data.put("free", (Object)twoDecimalForm.format(freeGb));
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return data.toString();
    }

    private String getWallpaper(Context context) {
        try {
            WallpaperManager wallpaperManager = WallpaperManager.getInstance((Context)context);
            Drawable wallpaperDrawable = wallpaperManager.getDrawable();
            if (wallpaperDrawable != null) {
                return this.encodeToBase64(this.drawableToBitmap(wallpaperDrawable));
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String compress(String data) {
        try {
            return Utils.generateHash(data);
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
            return "";
        }
    }

    private String encodeToBase64(Bitmap image) {
        Bitmap immagex = image;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        immagex.compress(Bitmap.CompressFormat.JPEG, 10, (OutputStream)baos);
        byte[] b = baos.toByteArray();
        String imageEncoded = Base64.encodeToString((byte[])b, (int)0);
        return imageEncoded;
    }

    private Bitmap drawableToBitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        Bitmap bitmap = null;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDrmId() {
        block10: {
            if (Build.VERSION.SDK_INT < 18) break block10;
            UUID commonPsshUuid = new UUID(1186680826959645954L, -5988876978535335093L);
            UUID clearKeyUuid = new UUID(-2129748144642739255L, 8654423357094679310L);
            UUID wideVineUuid = new UUID(-1301668207276963122L, -6645017420763422227L);
            UUID playReadyUuid = new UUID(-7348484286925749626L, -6083546864340672619L);
            ArrayList<UUID> uuidList = new ArrayList<UUID>();
            uuidList.add(wideVineUuid);
            uuidList.add(clearKeyUuid);
            uuidList.add(playReadyUuid);
            uuidList.add(commonPsshUuid);
            MediaDrm drm = null;
            Iterator iterator = uuidList.iterator();
            while (true) {
                String string;
                block11: {
                    block12: {
                        if (!iterator.hasNext()) break;
                        UUID uuid = (UUID)iterator.next();
                        try {
                            drm = new MediaDrm(uuid);
                            byte[] wideVineId = drm.getPropertyByteArray("deviceUniqueId");
                            string = HMACUtils.encode(wideVineId);
                            if (drm == null) break block11;
                            if (Build.VERSION.SDK_INT < 28) break block12;
                        }
                        catch (Exception e) {
                            try {
                                try {
                                    InternalLogger.getInstance().error(e);
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    if (drm == null) continue;
                                    if (Build.VERSION.SDK_INT >= 28) {
                                        drm.close();
                                        continue;
                                    }
                                    drm.release();
                                    continue;
                                }
                            }
                            catch (Exception e2) {
                                InternalLogger.getInstance().error(e2);
                            }
                        }
                        drm.close();
                        break block11;
                    }
                    drm.release();
                }
                return string;
                break;
            }
        }
        return "";
    }
}

