/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.context;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.admin.DevicePolicyManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.graphics.Typeface;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import android.os.Debug;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import com.shield.android.context.ContextMapper;
import com.shield.android.context.LocationContext;
import com.shield.android.context.Screen;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.Utils;
import java.io.File;
import java.lang.reflect.Field;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

class BaseSystemContext
extends ContextMapper {
    String TAG = BaseSystemContext.class.getSimpleName();
    static final String APPS_KEY = "APPS";
    static final String VPN_APPS = "VPN_APPS";
    static final String FAKEGPS_APPS = "FAKEGPS_APPS";
    private static final String LANGUAGE_KEY = "LANGUAGE";
    private static final String FONTS_KEY = "FONTS";
    private static final String OS_KEY = "OS";
    private static final String DISPLAY_KEY = "DISPLAY";
    private static final String BROWSER_KEY = "BROWSER";
    private static final String GMT_KEY = "GMT";
    private static final String RUNNING_TASKS_KEY = "RUNNING_TASKS";
    private static final String BATTERY_KEY = "BATTERY";
    private static final String TIME_SINCE_BOOT_KEY = "TIME_SINCE_BOOT";
    private static final String BACKGROUND_APP_USAGE = "BACKGROUND_APP_USAGE";
    private static final String IS_DEBUGGING = "IS_DEBUGGING";
    private static final String INSTALLED_ACCESSIBILITY_SERVICES = "INSTALLED_ACCESSIBILITY_SERVICES";
    private static final String ENABLED_ACCESSIBILITY_SERVICES = "ENABLED_ACCESSIBILITY_SERVICES";
    private static final String DEVICE_ADMINS = "DEVICE_ADMINS";
    private static final String PLATFORM = "PLATFORM";
    protected final Context context;
    final String bypassCode;
    private LocationContext locationContext;
    private boolean fromMock = false;

    BaseSystemContext(Context context, LocationContext locationContext, String bypassCode) {
        this.context = context;
        this.bypassCode = bypassCode;
        this.locationContext = locationContext;
    }

    ConcurrentMap<String, String> getSystemContext() {
        this.put(LANGUAGE_KEY, Locale.getDefault().getDisplayLanguage());
        this.put(FONTS_KEY, this.getSSystemFontMap());
        this.put(OS_KEY, Build.VERSION.RELEASE);
        this.put(DISPLAY_KEY, this.getScreenInformation(this.context));
        this.put(BROWSER_KEY, this.getUserAgent());
        this.put(GMT_KEY, this.getTimeZone());
        this.put(RUNNING_TASKS_KEY, this.getRunningTasks(this.context));
        this.put(BATTERY_KEY, this.getBatteryInfo(this.context));
        this.put(TIME_SINCE_BOOT_KEY, this.getTimeSinceBoot());
        this.put(BACKGROUND_APP_USAGE, this.getBackgroundAppUsage(this.context));
        this.put(INSTALLED_ACCESSIBILITY_SERVICES, TextUtils.join((CharSequence)",", this.getAccessibilityServicesInstalled(this.context)));
        this.put(ENABLED_ACCESSIBILITY_SERVICES, TextUtils.join((CharSequence)",", this.getAccessibilityServicesEnabled(this.context)));
        this.put(IS_DEBUGGING, this.isDebugging(this.context));
        this.put(DEVICE_ADMINS, this.getDeviceAdmin(this.context));
        this.put(PLATFORM, "2");
        return this.map();
    }

    private boolean isDebuggable(Context context) {
        try {
            return (context.getApplicationContext().getApplicationInfo().flags & 2) != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isDebuggerConnected() {
        try {
            return Debug.isDebuggerConnected();
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getDeviceAdmin(Context context) {
        String deviceAdminResult = "";
        try {
            ArrayList<String> deviceAdmins = new ArrayList<String>();
            DevicePolicyManager devicePolicyManager = (DevicePolicyManager)context.getSystemService("device_policy");
            if (devicePolicyManager.getActiveAdmins() != null) {
                for (ComponentName componentName : devicePolicyManager.getActiveAdmins()) {
                    deviceAdmins.add(componentName.getPackageName());
                }
            }
            if (!deviceAdmins.isEmpty()) {
                deviceAdminResult = TextUtils.join((CharSequence)",", deviceAdmins);
            }
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return deviceAdminResult;
    }

    private String isDebugging(Context context) {
        StackTraceElement[] stacks;
        for (StackTraceElement st : stacks = Thread.currentThread().getStackTrace()) {
            String className = st.getClassName();
            String string = st.getMethodName();
        }
        return "{ \"debuggable\": " + this.isDebuggable(context) + ", \"debugger_connected\": " + this.isDebuggerConnected() + " }";
    }

    private String getSSystemFontMap() {
        Map sSystemFontMap = null;
        String fonts = "";
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                Typeface typeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
                Field f = Typeface.class.getDeclaredField("sSystemFontMap");
                f.setAccessible(true);
                sSystemFontMap = (Map)f.get(typeface);
                for (Map.Entry entry : sSystemFontMap.entrySet()) {
                    fonts = fonts + (String)entry.getKey() + ",";
                }
            } else {
                File[] ff;
                String path = "/system/fonts";
                File file = new File(path);
                for (File f : ff = file.listFiles()) {
                    String fname = f.getName();
                    int pos = fname.lastIndexOf(".");
                    if (pos > 0) {
                        fname = fname.substring(0, pos);
                    }
                    fonts = fonts + fname + ",";
                }
            }
        }
        catch (Exception e) {
            InternalLogger.tag(this.TAG).error(e);
        }
        return fonts.length() > 0 ? fonts.substring(0, fonts.length() - 1) : "";
    }

    private String getScreenInformation(Context context) {
        try {
            WindowManager wm = (WindowManager)Utils.getSystemService(context, "window");
            Display display = wm.getDefaultDisplay();
            DisplayMetrics realMetrics = new DisplayMetrics();
            Object mGetRawH = null;
            Object mGetRawW = null;
            if (Build.VERSION.SDK_INT >= 17) {
                display.getRealMetrics(realMetrics);
            } else {
                display.getMetrics(realMetrics);
            }
            int realWidth = realMetrics.widthPixels;
            int realHeight = realMetrics.heightPixels;
            int densityDpi = realMetrics.densityDpi;
            float xdpi = realMetrics.xdpi;
            float ydpi = realMetrics.ydpi;
            Screen screen = new Screen(realWidth, realHeight, densityDpi, xdpi, ydpi);
            int orientation = context.getResources().getConfiguration().orientation;
            double wi = (double)screen.getRealWidth() / (double)screen.getXdpi();
            double hi = (double)screen.getRealHeight() / (double)screen.getYdpi();
            double x = Math.pow(wi, 2.0);
            double y = Math.pow(hi, 2.0);
            double screenInches = Math.sqrt(x + y);
            return screen.getRealWidth() + "|" + screen.getRealHeight() + "|" + screenInches + "|" + screen.getDensityDpi();
        }
        catch (Exception e) {
            InternalLogger.tag(this.TAG).error(e);
            return "";
        }
    }

    private String getTimeZone() {
        GregorianCalendar mCalendar = new GregorianCalendar();
        TimeZone mTimeZone = ((Calendar)mCalendar).getTimeZone();
        int mGMTOffset = mTimeZone.getRawOffset();
        return String.valueOf(TimeUnit.HOURS.convert(mGMTOffset, TimeUnit.MILLISECONDS));
    }

    private String getUserAgent() {
        return System.getProperty("http.agent");
    }

    private String getRunningTasks(Context context) {
        try {
            long time;
            UsageStatsManager usm;
            List appStatsList;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (Build.VERSION.SDK_INT >= 21 || Utils.hasSelfPermission(context, "android.permission.GET_TASKS")) {
                ActivityManager am = (ActivityManager)context.getSystemService("activity");
                if (am != null) {
                    List tasks = am.getRunningTasks(Integer.MAX_VALUE);
                    for (ActivityManager.RunningTaskInfo task : tasks) {
                        arrayList.add(task.baseActivity.toShortString() + ":" + task.numRunning);
                    }
                }
            } else {
                return "disabled";
            }
            if (Build.VERSION.SDK_INT >= 21 && (appStatsList = (usm = (UsageStatsManager)context.getSystemService("usagestats")).queryUsageStats(0, (time = System.currentTimeMillis()) - 60000L, time)) != null && !appStatsList.isEmpty()) {
                for (UsageStats usageStats : appStatsList) {
                    String packageName = usageStats.getPackageName();
                    arrayList.add(this.getApplicationName(context, packageName));
                }
            }
            return TextUtils.join((CharSequence)"|", arrayList);
        }
        catch (Exception e) {
            InternalLogger.tag(this.TAG).error(e, RUNNING_TASKS_KEY, new Object[0]);
            return "error";
        }
    }

    private String getBatteryInfo(Context context) {
        HashMap<String, String> batteryInfo = new HashMap<String, String>();
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent battery = context.registerReceiver(null, ifilter);
            batteryInfo.put("health", String.valueOf(battery.getIntExtra("health", -1)));
            batteryInfo.put("plugged", String.valueOf(battery.getIntExtra("plugged", -1)));
            batteryInfo.put("status", String.valueOf(battery.getIntExtra("status", -1)));
            int batteryLevel = battery.getIntExtra("level", -1);
            int batteryScale = battery.getIntExtra("scale", -1);
            batteryInfo.put("level", String.valueOf(batteryLevel));
            batteryInfo.put("scale", String.valueOf(batteryScale));
            batteryInfo.put("percentage", String.valueOf((float)batteryLevel / (float)batteryScale * 100.0f));
            batteryInfo.put("present", String.valueOf(battery.getBooleanExtra("present", true)));
            batteryInfo.put("technology", battery.getStringExtra("technology"));
            batteryInfo.put("temperature", String.valueOf(battery.getIntExtra("temperature", -1)));
            int batteryVoltage = battery.getIntExtra("voltage", -1);
            if (batteryVoltage < 1000) {
                batteryVoltage *= 1000;
            }
            batteryInfo.put("voltage", String.valueOf(batteryVoltage));
        }
        catch (Exception e) {
            InternalLogger.tag(this.TAG).error(e);
        }
        return new JSONObject(batteryInfo).toString();
    }

    private String getTimeSinceBoot() {
        try {
            return "realtime:" + SystemClock.elapsedRealtime() + ",uptime:" + SystemClock.uptimeMillis();
        }
        catch (Exception e) {
            InternalLogger.tag(this.TAG).error(e);
            return "";
        }
    }

    private String getBackgroundAppUsage(Context context) {
        try {
            JSONObject object = new JSONObject();
            object.put("using_vpn", (Object)String.valueOf(this.isUsingVPN(context)));
            object.put("vpn_port", (Object)this.getVPNPorts());
            object.put("using_fakegps", (Object)String.valueOf(this.isLocationFake(context)));
            return object.toString();
        }
        catch (Exception e) {
            InternalLogger.tag(this.TAG).error(e);
            return "";
        }
    }

    private String getVPNPorts() {
        String name = "";
        try {
            Enumeration<NetworkInterface> niEnum = NetworkInterface.getNetworkInterfaces();
            while (niEnum.hasMoreElements()) {
                NetworkInterface networkInterface = niEnum.nextElement();
                if (networkInterface.isUp()) {
                    name = networkInterface.getName();
                }
                if (!name.contains("tun") && !name.contains("ppp") && !name.contains("pptp")) continue;
                return name;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "tun0";
    }

    private boolean isUsingVPN(Context context) {
        try {
            Network activeNetwork;
            ConnectivityManager connectivityManager;
            NetworkCapabilities caps;
            if (Build.VERSION.SDK_INT >= 23 && Utils.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE") && (caps = (connectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkCapabilities(activeNetwork = connectivityManager.getActiveNetwork())) != null) {
                return caps.hasTransport(4);
            }
            String name = "";
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (networkInterface.isUp()) {
                    name = networkInterface.getName();
                }
                if (!name.contains("tun") && !name.contains("ppp") && !name.contains("pptp")) continue;
                return true;
            }
        }
        catch (Exception e) {
            InternalLogger.tag(this.TAG).error(e, "checking vpn", new Object[0]);
        }
        return false;
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean isLocationFake(Context context) {
        if ((Utils.hasSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION") || Utils.hasSelfPermission(context, "android.permission.ACCESS_COARSE_LOCATION")) && Utils.isLocationEnabled(context)) {
            if (Build.VERSION.SDK_INT >= 18) {
                return this.locationContext.isLocationFake();
            }
            String mockLocation = "0";
            try {
                mockLocation = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"mock_location");
            }
            catch (Exception e) {
                InternalLogger.tag(this.TAG).error(e, "checking fake gps", new Object[0]);
            }
            return !mockLocation.equals("0");
        }
        return this.fromMock;
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean isProviderMocked() {
        block6: {
            try {
                Criteria criteria = new Criteria();
                LocationManager locationManager = (LocationManager)Utils.getSystemService(this.context, "location");
                String provider = locationManager.getBestProvider(criteria, true);
                Location myLocation = null;
                if (provider != null) {
                    myLocation = locationManager.getLastKnownLocation(provider);
                }
                if (myLocation == null) break block6;
                if (Build.VERSION.SDK_INT >= 18) {
                    return myLocation.isFromMockProvider();
                }
                String mockLocation = "0";
                try {
                    mockLocation = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"mock_location");
                }
                catch (Exception e) {
                    InternalLogger.tag(this.TAG).error(e, "checking fake gps", new Object[0]);
                }
                return !mockLocation.equals("0");
            }
            catch (Exception e) {
                InternalLogger.getInstance().error(e);
            }
        }
        return false;
    }

    private List<String> getAccessibilityServicesInstalled(Context context) {
        ArrayList<String> accessibilityApps = new ArrayList<String>();
        try {
            AccessibilityManager am = (AccessibilityManager)context.getSystemService("accessibility");
            List installedServices = am.getInstalledAccessibilityServiceList();
            for (AccessibilityServiceInfo installedService : installedServices) {
                ServiceInfo installedServiceInfo = installedService.getResolveInfo().serviceInfo;
                accessibilityApps.add(installedServiceInfo.packageName);
            }
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return accessibilityApps;
    }

    private List<String> getAccessibilityServicesEnabled(Context context) {
        ArrayList<String> accessibilityApps = new ArrayList<String>();
        try {
            AccessibilityManager am = (AccessibilityManager)context.getSystemService("accessibility");
            List enabledServices = am.getEnabledAccessibilityServiceList(-1);
            for (AccessibilityServiceInfo enabledService : enabledServices) {
                ServiceInfo enabledServiceInfo = enabledService.getResolveInfo().serviceInfo;
                accessibilityApps.add(enabledServiceInfo.packageName);
            }
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return accessibilityApps;
    }

    boolean hasAppPermission(Context context, String app, String permission2) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(app, 4096);
            if (packageInfo.requestedPermissions != null) {
                for (String requestedPermission : packageInfo.requestedPermissions) {
                    if (!permission2.equals(requestedPermission)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            InternalLogger.tag(this.TAG).error(e);
        }
        return false;
    }

    boolean hasAppService(Context context, String app, String permission2) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(app, 4);
            if (packageInfo.services != null) {
                for (ServiceInfo service : packageInfo.services) {
                    if (!permission2.equals(service.permission)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            InternalLogger.tag(this.TAG).error(e);
        }
        return false;
    }

    String getApplicationName(Context context, String packageName) {
        String appName = "";
        String className = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            appName = packageManager.getApplicationLabel(packageManager.getApplicationInfo(packageName, 128)).toString();
            Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(packageName);
            if (launchIntent != null && launchIntent.getComponent() != null) {
                className = launchIntent.getComponent().getShortClassName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Utils.isNullOrEmpty(appName)) {
            return packageName;
        }
        return appName + ":" + packageName + ":" + className;
    }
}

