/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android.context;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.text.TextUtils;
import com.shield.android.context.ContextMapper;
import com.shield.android.internal.InternalLogger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONObject;

class AppContext
extends ContextMapper {
    private static final String TAG = AppContext.class.getSimpleName();
    private static final String APP_VERSION_KEY = "APPVERSION";
    private static final String APP_BUILD_KEY = "APPBUILD";
    private static final String APP_INFO_KEY = "APP_INFO";
    private final Context context;

    AppContext(Context context) {
        this.context = context;
    }

    ConcurrentMap<String, String> getAppContext() {
        try {
            this.getAppInformation(this.context);
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
        return this.map();
    }

    private void getAppInformation(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            String packageName = context.getPackageName();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            this.put(APP_VERSION_KEY, packageInfo.versionName);
            this.put(APP_BUILD_KEY, String.valueOf(packageInfo.versionCode));
            String installer = packageManager.getInstallerPackageName(packageName);
            boolean isOfficial = false;
            if (installer != null && installer.startsWith("com.android.vending")) {
                isOfficial = true;
            }
            JSONObject object = new JSONObject();
            object.put("package_name", (Object)packageName);
            object.put("keys", (Object)this.getSigningSignatures(context));
            object.put("is_official", isOfficial);
            ArrayList<String> permissions = new ArrayList<String>();
            try {
                PackageInfo permissionPackageInfo;
                if (Build.VERSION.SDK_INT > 15 && (permissionPackageInfo = packageManager.getPackageInfo(packageName, 4096)) != null && permissionPackageInfo.requestedPermissions != null && permissionPackageInfo.requestedPermissions.length > 0) {
                    for (int i = 0; i < permissionPackageInfo.requestedPermissions.length; ++i) {
                        if ((permissionPackageInfo.requestedPermissionsFlags[i] & 2) == 0) continue;
                        String permission2 = permissionPackageInfo.requestedPermissions[i];
                        int permissionSubStringIndex = permission2.lastIndexOf(".") + 1;
                        if (permission2.length() <= permissionSubStringIndex) continue;
                        permission2 = permission2.substring(permissionSubStringIndex).toLowerCase();
                        permissions.add(permission2);
                    }
                }
            }
            catch (Exception e) {
                InternalLogger.getInstance().error(e);
            }
            object.put("permissions", (Object)TextUtils.join((CharSequence)",", permissions));
            this.put(APP_INFO_KEY, object.toString());
        }
        catch (Exception e) {
            InternalLogger.tag(TAG).error(e);
        }
    }

    private String getSigningSignatures(Context context) {
        ArrayList<String> signingKeys = new ArrayList<String>();
        try {
            Signature[] signatures = null;
            PackageManager packageManager = context.getPackageManager();
            String packageName = context.getPackageName();
            if (Build.VERSION.SDK_INT >= 28) {
                try {
                    signatures = packageManager.getPackageInfo((String)packageName, (int)0x8000000).signingInfo.getApkContentsSigners();
                }
                catch (Throwable e) {
                    InternalLogger.tag(TAG).error(e);
                    return "";
                }
            }
            if (signatures == null) {
                signatures = context.getPackageManager().getPackageInfo((String)packageName, (int)64).signatures;
            }
            for (Signature signature : signatures) {
                String sha1 = this.getSHA1(signature.toByteArray());
                if (TextUtils.isEmpty((CharSequence)sha1)) continue;
                signingKeys.add(sha1);
            }
            return TextUtils.join((CharSequence)",", signingKeys);
        }
        catch (Exception e) {
            InternalLogger.tag(TAG).error(e);
            return "";
        }
    }

    private String getSHA1(byte[] sig) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(sig);
            byte[] hash = digest.digest();
            return this.bytesToHex(hash);
        }
        catch (Exception e) {
            InternalLogger.tag(TAG).error(e);
            return "";
        }
    }

    private String bytesToHex(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

