/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android;

import java.io.IOException;

public class ShieldException
extends RuntimeException {
    public final String url;
    public final Kind kind;
    public final int code;
    public final String message;
    public final String body;

    public static ShieldException httpError(String url, int code, String message, String body) {
        return new ShieldException(url, code, message, body, Kind.HTTP, null);
    }

    public static ShieldException networkError(IOException exception) {
        return new ShieldException(null, 0, exception.getMessage(), null, Kind.NETWORK, exception);
    }

    public static ShieldException unexpectedError(Throwable exception) {
        return new ShieldException(null, 0, exception.getMessage(), null, Kind.UNEXPECTED, exception);
    }

    private ShieldException(String url, int code, String message, String body, Kind kind, Throwable exception) {
        super(message, exception);
        this.url = url;
        this.kind = kind;
        this.message = message;
        this.body = body;
        this.code = code;
    }

    public static enum Kind {
        NETWORK,
        HTTP,
        UNEXPECTED;

    }
}

