/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.location.Criteria;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.shield.android.ScreenshotChecker;
import com.shield.android.Shield;
import com.shield.android.context.ShieldContext;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.Utils;
import com.shield.android.listener.FusedModeChangedListener;
import com.shield.android.listener.GPSProviderListener;
import com.shield.android.listener.NetworkChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

class ShieldApplicationLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private static final AtomicBoolean isApplicationInBackground = new AtomicBoolean(false);
    private static final long INTERVAL_BACKGROUND_STATE_CHANGE = 750L;
    private static final long INTERVAL_FOREGROUND_STATE_CHANGE = 300L;
    private static WeakReference<Activity> currentActivityReference;
    public static WeakReference<String> screenNameReference;
    private Shield shield;
    private ShieldContext shieldContext;
    private boolean hasActiveNetwork = true;
    private boolean hasVPNDetected = false;
    private boolean isInitializedCalled = false;
    private String bestProvider = "";
    private int locationMode = -1;
    private Application application;
    private NetworkChangeListener networkChangeListener;
    private GPSProviderListener gpsProviderListener;
    private FusedModeChangedListener fusedModeChangedListener;
    private long lastProviderChangedDetected = 0L;
    private boolean screenshotDetectListening = false;
    private ConnectivityManager.NetworkCallback networkCallback;

    ShieldApplicationLifecycleCallbacks(Shield shield, Application application, ShieldContext shieldContext) {
        this.shield = shield;
        this.application = application;
        this.shieldContext = shieldContext;
    }

    private void determineForegroundStatus() {
        if (isApplicationInBackground.get()) {
            InternalLogger.tag("Shield: ApplicationLifecycle").debug("foreground at %s", screenNameReference.get());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("event_name", "application_on_resumed");
            this.shield.sendDeviceSignature((String)screenNameReference.get(), data);
            isApplicationInBackground.set(false);
            this.shield.appInBackground = false;
            if (!this.screenshotDetectListening) {
                ScreenshotChecker.start(this.application);
                this.screenshotDetectListening = true;
            }
            this.shieldContext.startFridaListener(() -> {
                HashMap<String, String> data1 = new HashMap<String, String>();
                data1.put("event_name", "tools_change_detected");
                this.shield.sendDeviceSignature((String)screenNameReference.get(), data1);
            });
        }
    }

    private void determineBackgroundStatus() {
        new Handler().postDelayed(() -> {
            if (!isApplicationInBackground.get() && currentActivityReference == null) {
                isApplicationInBackground.set(true);
                this.shield.appInBackground = true;
                if (this.screenshotDetectListening) {
                    ScreenshotChecker.stop(this.application);
                    this.screenshotDetectListening = false;
                }
                this.shieldContext.stopFridaListener();
                InternalLogger.tag("Shield: ApplicationLifecycle").debug("isBackgrounded at %s", screenNameReference.get());
            }
        }, 750L);
    }

    @SuppressLint(value={"MissingPermission"})
    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        block17: {
            try {
                screenNameReference = new WeakReference<String>(activity.getLocalClassName());
                if (this.isInitializedCalled) break block17;
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("event_name", "sdk_initialized");
                this.shield.sendDeviceSignature((String)screenNameReference.get(), data);
                this.shieldContext.startFridaListener(() -> {
                    HashMap<String, String> data1 = new HashMap<String, String>();
                    data1.put("event_name", "tools_change_detected");
                    this.shield.sendDeviceSignature((String)screenNameReference.get(), data1);
                });
                if (!this.screenshotDetectListening) {
                    ScreenshotChecker.start(this.application);
                }
                if (this.shield.needBackgroundListener) {
                    try {
                        if (Build.VERSION.SDK_INT >= 24) {
                            final ConnectivityManager cm = (ConnectivityManager)activity.getSystemService("connectivity");
                            if (cm != null) {
                                if (this.networkCallback == null) {
                                    this.networkCallback = new ConnectivityManager.NetworkCallback(){

                                        public void onAvailable(@NonNull Network network) {
                                            NetworkCapabilities caps = cm.getNetworkCapabilities(network);
                                            if (!ShieldApplicationLifecycleCallbacks.this.hasActiveNetwork || caps != null && caps.hasTransport(4) && !ShieldApplicationLifecycleCallbacks.this.hasVPNDetected) {
                                                ShieldApplicationLifecycleCallbacks.this.hasVPNDetected = caps != null && caps.hasTransport(4);
                                                HashMap<String, String> data = new HashMap<String, String>();
                                                data.put("event_name", "network_change_detected");
                                                ShieldApplicationLifecycleCallbacks.this.shield.sendDeviceSignature((String)screenNameReference.get(), data);
                                            }
                                            ShieldApplicationLifecycleCallbacks.this.hasActiveNetwork = true;
                                            super.onAvailable(network);
                                        }

                                        public void onLost(@NonNull Network network) {
                                            super.onLost(network);
                                            ShieldApplicationLifecycleCallbacks.this.hasActiveNetwork = false;
                                        }

                                        public void onUnavailable() {
                                            super.onUnavailable();
                                            ShieldApplicationLifecycleCallbacks.this.hasActiveNetwork = false;
                                        }
                                    };
                                }
                                cm.registerDefaultNetworkCallback(this.networkCallback);
                            }
                        } else {
                            this.networkChangeListener = new NetworkChangeListener(() -> {
                                HashMap<String, String> networkData = new HashMap<String, String>();
                                networkData.put("event_name", "network_change_detected");
                                this.shield.sendDeviceSignature((String)screenNameReference.get(), networkData);
                            });
                            try {
                                activity.registerReceiver((BroadcastReceiver)this.networkChangeListener, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.gpsProviderListener = new GPSProviderListener(() -> {
                            try {
                                LocationManager locationManager = (LocationManager)this.application.getSystemService("location");
                                Criteria criteria = new Criteria();
                                String provider = locationManager.getBestProvider(criteria, true);
                                long currentProviderChangeDetected = System.currentTimeMillis();
                                if (provider != this.bestProvider && currentProviderChangeDetected - this.lastProviderChangedDetected > 300L) {
                                    HashMap<String, String> gpsData = new HashMap<String, String>();
                                    gpsData.put("event_name", "gps_provider_change_detected");
                                    this.shield.sendDeviceSignature((String)screenNameReference.get(), gpsData);
                                    this.checkLocation();
                                }
                                this.lastProviderChangedDetected = currentProviderChangeDetected;
                                this.bestProvider = provider;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                        this.fusedModeChangedListener = new FusedModeChangedListener(() -> {
                            HashMap<String, String> fusedModeData = new HashMap<String, String>();
                            fusedModeData.put("event_name", "gps_provider_change_detected");
                            this.shield.sendDeviceSignature((String)screenNameReference.get(), fusedModeData);
                            this.checkLocation();
                        });
                        if (Build.VERSION.SDK_INT >= 19 && Utils.isGoogleLocationServiceExists((Context)this.application)) {
                            try {
                                activity.registerReceiver((BroadcastReceiver)this.fusedModeChangedListener, new IntentFilter("android.location.MODE_CHANGED"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        try {
                            activity.registerReceiver((BroadcastReceiver)this.gpsProviderListener, new IntentFilter("android.location.PROVIDERS_CHANGED"));
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.isInitializedCalled = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onActivityStarted(@NonNull Activity activity) {
    }

    public void onActivityPreDestroyed(@NonNull Activity activity) {
        if (this.shield.needBackgroundListener) {
            try {
                try {
                    ConnectivityManager cm;
                    if (this.networkCallback != null && Build.VERSION.SDK_INT >= 21 && (cm = (ConnectivityManager)activity.getSystemService("connectivity")) != null) {
                        cm.unregisterNetworkCallback(this.networkCallback);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.networkChangeListener != null) {
                        activity.unregisterReceiver((BroadcastReceiver)this.networkChangeListener);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (Build.VERSION.SDK_INT >= 19 && Utils.isGoogleLocationServiceExists((Context)this.application)) {
                    try {
                        if (this.fusedModeChangedListener != null) {
                            activity.unregisterReceiver((BroadcastReceiver)this.fusedModeChangedListener);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    if (this.gpsProviderListener != null) {
                        activity.unregisterReceiver((BroadcastReceiver)this.gpsProviderListener);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.networkChangeListener = null;
                this.gpsProviderListener = null;
                this.fusedModeChangedListener = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void onActivityResumed(@NonNull Activity activity) {
        block13: {
            InternalLogger.tag("Shield: ApplicationLifecycle").debug("onResumed", new Object[0]);
            screenNameReference = new WeakReference<String>(activity.getLocalClassName());
            currentActivityReference = new WeakReference<Activity>(activity);
            this.determineForegroundStatus();
            try {
                if (this.shield.needBackgroundListener) break block13;
                if (Build.VERSION.SDK_INT >= 24) {
                    final ConnectivityManager cm = (ConnectivityManager)activity.getSystemService("connectivity");
                    if (cm != null) {
                        if (this.networkCallback == null) {
                            this.networkCallback = new ConnectivityManager.NetworkCallback(){

                                public void onAvailable(@NonNull Network network) {
                                    NetworkCapabilities caps = cm.getNetworkCapabilities(network);
                                    if (!ShieldApplicationLifecycleCallbacks.this.hasActiveNetwork || caps != null && caps.hasTransport(4) && !ShieldApplicationLifecycleCallbacks.this.hasVPNDetected) {
                                        ShieldApplicationLifecycleCallbacks.this.hasVPNDetected = caps != null && caps.hasTransport(4);
                                        HashMap<String, String> data = new HashMap<String, String>();
                                        data.put("event_name", "network_change_detected");
                                        ShieldApplicationLifecycleCallbacks.this.shield.sendDeviceSignature((String)screenNameReference.get(), data);
                                    }
                                    ShieldApplicationLifecycleCallbacks.this.hasActiveNetwork = true;
                                    super.onAvailable(network);
                                }

                                public void onLost(@NonNull Network network) {
                                    super.onLost(network);
                                    ShieldApplicationLifecycleCallbacks.this.hasActiveNetwork = false;
                                }

                                public void onUnavailable() {
                                    super.onUnavailable();
                                    ShieldApplicationLifecycleCallbacks.this.hasActiveNetwork = false;
                                }
                            };
                        }
                        cm.registerDefaultNetworkCallback(this.networkCallback);
                    }
                } else {
                    this.networkChangeListener = new NetworkChangeListener(() -> {
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("event_name", "network_change_detected");
                        this.shield.sendDeviceSignature((String)screenNameReference.get(), data);
                    });
                    try {
                        activity.registerReceiver((BroadcastReceiver)this.networkChangeListener, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.gpsProviderListener = new GPSProviderListener(() -> {
                    try {
                        LocationManager locationManager = (LocationManager)this.application.getSystemService("location");
                        Criteria criteria = new Criteria();
                        String provider = locationManager.getBestProvider(criteria, true);
                        long currentProviderChangeDetected = System.currentTimeMillis();
                        if (provider != this.bestProvider && currentProviderChangeDetected - this.lastProviderChangedDetected > 300L) {
                            HashMap<String, String> data = new HashMap<String, String>();
                            data.put("event_name", "gps_provider_change_detected");
                            this.shield.sendDeviceSignature((String)screenNameReference.get(), data);
                            this.checkLocation();
                        }
                        this.lastProviderChangedDetected = currentProviderChangeDetected;
                        this.bestProvider = provider;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                this.fusedModeChangedListener = new FusedModeChangedListener(() -> {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("event_name", "gps_provider_change_detected");
                    this.shield.sendDeviceSignature((String)screenNameReference.get(), data);
                    this.checkLocation();
                });
                if (Build.VERSION.SDK_INT >= 19 && Utils.isGoogleLocationServiceExists((Context)this.application)) {
                    try {
                        activity.registerReceiver((BroadcastReceiver)this.fusedModeChangedListener, new IntentFilter("android.location.MODE_CHANGED"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    activity.registerReceiver((BroadcastReceiver)this.gpsProviderListener, new IntentFilter("android.location.PROVIDERS_CHANGED"));
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onActivityPaused(@NonNull Activity activity) {
        if (!this.shield.needBackgroundListener) {
            try {
                try {
                    ConnectivityManager cm;
                    if (this.networkCallback != null && Build.VERSION.SDK_INT >= 21 && (cm = (ConnectivityManager)activity.getSystemService("connectivity")) != null) {
                        cm.unregisterNetworkCallback(this.networkCallback);
                    }
                }
                catch (Exception cm) {
                    // empty catch block
                }
                try {
                    if (this.networkChangeListener != null) {
                        activity.unregisterReceiver((BroadcastReceiver)this.networkChangeListener);
                    }
                }
                catch (Exception cm) {
                    // empty catch block
                }
                if (Build.VERSION.SDK_INT >= 19 && Utils.isGoogleLocationServiceExists((Context)this.application)) {
                    try {
                        if (this.fusedModeChangedListener != null) {
                            activity.unregisterReceiver((BroadcastReceiver)this.fusedModeChangedListener);
                        }
                    }
                    catch (Exception cm) {
                        // empty catch block
                    }
                }
                try {
                    if (this.gpsProviderListener != null) {
                        activity.unregisterReceiver((BroadcastReceiver)this.gpsProviderListener);
                    }
                }
                catch (Exception cm) {
                    // empty catch block
                }
                this.networkChangeListener = null;
                this.gpsProviderListener = null;
                this.fusedModeChangedListener = null;
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        InternalLogger.tag("Shield: ApplicationLifecycle").debug("onPaused", new Object[0]);
        screenNameReference = new WeakReference<String>(activity.getLocalClassName());
        currentActivityReference = null;
        this.determineBackgroundStatus();
    }

    public void onActivityStopped(@NonNull Activity activity) {
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
    }

    private void checkLocation() {
        try {
            if (Utils.hasSelfPermission((Context)this.application, "android.permission.ACCESS_FINE_LOCATION") || Utils.hasSelfPermission((Context)this.application, "android.permission.ACCESS_COARSE_LOCATION") && Utils.isLocationEnabled((Context)this.application)) {
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("event_name", "gps_provider_change_detected");
                    this.shield.sendDeviceSignature((String)screenNameReference.get(), data);
                }, 8000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

