/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.preference.PreferenceManager;
import com.shield.android.CaptchaType;
import com.shield.android.ShieldApplicationLifecycleCallbacks;
import com.shield.android.ShieldCallback;
import com.shield.android.ShieldException;
import com.shield.android.context.ShieldContext;
import com.shield.android.installreferral.InstallReferrerClient;
import com.shield.android.installreferral.InstallReferrerStateListener;
import com.shield.android.installreferral.ReferrerDetails;
import com.shield.android.internal.CSLogger;
import com.shield.android.internal.Config;
import com.shield.android.internal.CryptoUtils;
import com.shield.android.internal.InternalLogger;
import com.shield.android.internal.MockUtils;
import com.shield.android.internal.NativeUtils;
import com.shield.android.internal.Utils;
import com.shield.android.nettask.APICountNetTask;
import com.shield.android.nettask.ErrorReportingNetTask;
import com.shield.android.nettask.GetRiskAssessmentNetTask;
import com.shield.android.nettask.NetTaskQueue;
import com.shield.android.nettask.SendAttributesNetTask;
import com.shield.android.nettask.SendDeviceSignatureNetTask;
import com.shield.android.nettask.ShieldCookieManager;
import com.shield.android.nettask.UpdateCaptchaNetTask;
import com.shield.android.repository.IShieldRepository;
import com.shield.android.repository.ShieldRepositoryImpl;
import com.shield.android.repository.URLProvider;
import com.shield.android.view.CaptchaDialog;
import com.shield.android.view.InternalBlockedDialog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class Shield {
    public static final String ENVIRONMENT_DEV = "DEV";
    public static final String ENVIRONMENT_PROD = "PROD";
    private static final String REGION = "US";
    private static final String ENVIRONMENT = "PROD";
    private static final List<String> INSTANCES = new ArrayList<String>(1);
    private static volatile Shield singleton = null;
    private final String sessionId;
    private final IShieldRepository shieldRepository;
    private final Application application;
    private String siteId;
    private CSLogger logger;
    private int failedSignatureCallCount = 0;
    private ShieldCallback<JSONObject> deviceShieldCallback;
    @Nullable
    private JSONObject deviceResult;
    @Nullable
    private ShieldException responseError;
    private boolean isCallbackEnabled = true;
    boolean appInBackground = false;
    private Thread deviceCallbackThread;
    private boolean isMockingEnabled = false;
    private MockUtils mockUtils;
    boolean needBackgroundListener = false;
    private String partnerId = "";
    public DeviceResultStateListener deviceResultStateListener;

    private Shield(Application application, String sessionId, String siteId, boolean sendSignatureAutomatically, IShieldRepository shieldRepository, CSLogger logger, ShieldCallback<JSONObject> deviceShieldCallback, ShieldContext shieldContext, Thread thread, boolean isMockingEnabled, boolean needBackgroundListener) {
        this.application = application;
        this.sessionId = sessionId;
        this.shieldRepository = shieldRepository;
        this.logger = logger;
        this.siteId = siteId;
        this.deviceShieldCallback = deviceShieldCallback;
        this.deviceCallbackThread = thread;
        this.isMockingEnabled = isMockingEnabled;
        this.needBackgroundListener = needBackgroundListener;
        if (this.isMockingEnabled) {
            this.mockUtils = new MockUtils();
        }
        ShieldCookieManager.initialize();
        ShieldApplicationLifecycleCallbacks callbacks = new ShieldApplicationLifecycleCallbacks(this, application, shieldContext);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)callbacks);
        try {
            boolean installReferralCollected = PreferenceManager.getDefaultSharedPreferences((Context)application).getBoolean("install_referral_collected", false);
            if (Utils.hasSelfPermission((Context)application, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE") && !installReferralCollected) {
                final InstallReferrerClient referrerClient = InstallReferrerClient.newBuilder((Context)application).build();
                referrerClient.startConnection(new InstallReferrerStateListener(){

                    @Override
                    public void onInstallReferrerSetupFinished(int responseCode) {
                        JSONObject referrerObject = new JSONObject();
                        try {
                            switch (responseCode) {
                                case 0: {
                                    ReferrerDetails referrerDetails = referrerClient.getInstallReferrer();
                                    if (referrerDetails != null) {
                                        referrerObject.put("referral_params", (Object)referrerDetails.getInstallReferrer());
                                        referrerObject.put("install_begin_timestamps", referrerDetails.getInstallBeginTimestampSeconds());
                                        referrerObject.put("referrer_click_timestamps", referrerDetails.getReferrerClickTimestampSeconds());
                                    }
                                    break;
                                }
                                case 2: {
                                    referrerObject.put("error", (Object)"feature_not_supported");
                                    break;
                                }
                                case 1: {
                                    referrerObject.put("error", (Object)"service_unavailable");
                                    break;
                                }
                                case -1: {
                                    referrerObject.put("error", (Object)"service_disconnected");
                                    break;
                                }
                                case 3: {
                                    referrerObject.put("error", (Object)"developer_error");
                                    break;
                                }
                                default: {
                                    referrerObject.put("error", (Object)"unknown_error");
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            InternalLogger.getInstance().error(e);
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("INSTALL_REFERRAL", referrerObject.toString());
                        hashMap.put("event_name", "app_install");
                        Shield.this.sendDeviceSignature("app_install", hashMap);
                    }

                    @Override
                    public void onInstallReferrerServiceDisconnected() {
                    }
                });
            }
            PreferenceManager.getDefaultSharedPreferences((Context)application).edit().putBoolean("install_referral_collected", true).apply();
        }
        catch (Exception e) {
            InternalLogger.getInstance().error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSingletonInstance(Shield shieldClient) {
        Class<Shield> clazz = Shield.class;
        synchronized (Shield.class) {
            if (singleton != null) {
                throw new IllegalStateException("Singleton instance already exists.");
            }
            singleton = shieldClient;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Shield getInstance() {
        if (singleton == null) {
            throw new IllegalStateException("Singleton instance hasn't created yet. Please set singleton instance after building via builder");
        }
        return singleton;
    }

    @AnyThread
    public void sendAttributes(String screenName, HashMap<String, String> data) {
        if (!this.isMockingEnabled) {
            this.shieldRepository.sendAttributes(screenName, data);
        }
    }

    @AnyThread
    public void sendAttributes(@NonNull String screenName, @Nullable HashMap<String, String> data, final @NonNull ShieldCallback<Boolean> shieldCallback) {
        if (this.isMockingEnabled) {
            shieldCallback.onSuccess(true);
        } else {
            this.shieldRepository.sendAttributes(screenName, data, new ShieldCallback<Boolean>(){

                @Override
                public void onSuccess(@Nullable Boolean status) {
                    shieldCallback.onSuccess(status);
                }

                @Override
                public void onFailure(@Nullable ShieldException e) {
                    shieldCallback.onFailure(e);
                }
            });
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    @Nullable
    public JSONObject getLatestDeviceResult() {
        this.shieldRepository.sendAPICount();
        return this.deviceResult;
    }

    @Nullable
    public ShieldException getResponseError() {
        return this.responseError;
    }

    @AnyThread
    protected void sendDeviceSignature(@NonNull String screenName, @Nullable HashMap<String, String> data, @NonNull ShieldCallback<JSONObject> shieldCallback) {
        this.sendDeviceSignature(screenName, data, shieldCallback, false);
    }

    @AnyThread
    protected void sendDeviceSignature(final @NonNull String screenName, final @Nullable HashMap<String, String> data, final @NonNull ShieldCallback<JSONObject> shieldCallback, final boolean defaultCallback) {
        if (this.isMockingEnabled) {
            try {
                JSONObject result = this.mockUtils.getMockObject();
                this.setLatestDeviceResult(result);
                shieldCallback.onSuccess(result);
            }
            catch (Exception exception) {}
        } else {
            this.shieldRepository.sendDeviceSignature(screenName, data, new ShieldCallback<Pair<Config, JSONObject>>(){

                @Override
                public void onSuccess(@Nullable Pair<Config, JSONObject> result) {
                    boolean callback = true;
                    boolean autoBlock = false;
                    boolean autoCaptcha = false;
                    long featureVersion = 1050600L;
                    if (result == null) {
                        return;
                    }
                    if (result.first != null) {
                        try {
                            callback = ((Config)result.first).callback;
                            Shield.this.isCallbackEnabled = callback;
                            autoBlock = ((Config)result.first).autoBlock;
                            autoCaptcha = ((Config)result.first).autoCaptcha;
                            featureVersion = ((Config)result.first).featureVersion;
                        }
                        catch (Exception e) {
                            InternalLogger.getInstance().error(e);
                        }
                    }
                    if (result.second != null) {
                        Shield.this.setLatestDeviceResult((JSONObject)result.second);
                        if (callback) {
                            shieldCallback.onSuccess(result.second);
                        }
                    } else if (callback && !defaultCallback) {
                        shieldCallback.onFailure(ShieldException.unexpectedError(new Throwable("Failed to get device result")));
                    }
                    if (autoBlock) {
                        if (Shield.this.appInBackground) {
                            return;
                        }
                        new Handler(Looper.getMainLooper()).post(() -> {
                            Intent intent = new Intent(Shield.this.application.getApplicationContext(), InternalBlockedDialog.class);
                            intent.addFlags(0x14000000);
                            Shield.this.application.startActivity(intent);
                        });
                    } else if (autoCaptcha) {
                        if (Shield.this.appInBackground) {
                            return;
                        }
                        new Handler(Looper.getMainLooper()).post(() -> {
                            IntentFilter intentFilter = new IntentFilter();
                            intentFilter.addAction("captcha_broadcast");
                            LocalBroadcastManager.getInstance((Context)Shield.this.application).registerReceiver((BroadcastReceiver)new CaptchaReceiver(), intentFilter);
                            Intent intent = CaptchaDialog.getCaptchaIntent(Shield.this.application.getApplicationContext(), CaptchaType.TEXT_CAPTCHA, false);
                            intent.addFlags(0x14000000);
                            Shield.this.application.startActivity(intent);
                        });
                    }
                }

                @Override
                public void onFailure(@Nullable ShieldException e) {
                    if (e == null) {
                        return;
                    }
                    if (e.code == 301) {
                        InternalLogger.getInstance().info(e.body, new Object[0]);
                        if (e.body != null) {
                            try {
                                JSONObject endpointObj = new JSONObject(e.body);
                                if (endpointObj.has("endpoint")) {
                                    PreferenceManager.getDefaultSharedPreferences((Context)Shield.this.application).edit().putString("endpoint", endpointObj.optString("endpoint", "")).apply();
                                }
                                if (endpointObj.has("version")) {
                                    PreferenceManager.getDefaultSharedPreferences((Context)Shield.this.application).edit().putString("version", String.valueOf(endpointObj.optInt("version", 0))).apply();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (Shield.this.failedSignatureCallCount < 3) {
                            Shield.this.sendDeviceSignature(screenName, data, shieldCallback, defaultCallback);
                            Shield.this.failedSignatureCallCount++;
                        } else {
                            shieldCallback.onFailure(e);
                        }
                    } else {
                        if (Shield.this.isCallbackEnabled) {
                            shieldCallback.onFailure(e);
                        }
                        if (Shield.this.deviceResult == null) {
                            Shield.this.setResponseError(e);
                        }
                    }
                }
            });
        }
    }

    @AnyThread
    public void sendDeviceSignature(@NonNull String screenName, @Nullable HashMap<String, String> data) {
        if (this.deviceShieldCallback != null) {
            if (this.deviceCallbackThread != null) {
                new Thread(() -> this.sendDeviceSignature(screenName, data, this.deviceShieldCallback, true), this.deviceCallbackThread.getName()).start();
            } else {
                new Handler(Looper.getMainLooper()).post(() -> this.sendDeviceSignature(screenName, data, this.deviceShieldCallback, true));
            }
        } else {
            this.sendDeviceSignature(screenName, data, new ShieldCallback<JSONObject>(){

                @Override
                public void onSuccess(@Nullable JSONObject data) {
                    if (data != null) {
                        Shield.this.setLatestDeviceResult(data);
                    }
                }

                @Override
                public void onFailure(@Nullable ShieldException e) {
                    InternalLogger.getInstance().error(e);
                    if (Shield.this.deviceResult == null) {
                        Shield.this.setResponseError(e);
                    }
                }
            });
        }
    }

    private void updateChallenge(boolean result) {
        this.shieldRepository.updateChallenge(result);
    }

    private void setLatestDeviceResult(JSONObject deviceResult) {
        if (deviceResult != null) {
            this.responseError = null;
            boolean shouldCallIsReady = this.deviceResult == null;
            this.deviceResult = deviceResult;
            if (this.deviceResultStateListener != null && shouldCallIsReady) {
                this.deviceResultStateListener.isReady();
            }
        } else if (this.deviceResult == null) {
            this.responseError = ShieldException.unexpectedError(new Throwable("unexpected error"));
            if (this.deviceResultStateListener != null) {
                this.deviceResultStateListener.isReady();
            }
        }
    }

    private void setResponseError(ShieldException exception) {
        this.responseError = exception;
        if (this.deviceResultStateListener != null) {
            this.deviceResultStateListener.isReady();
        }
    }

    public void setDeviceResultStateListener(DeviceResultStateListener deviceResultStateListener) {
        this.deviceResultStateListener = deviceResultStateListener;
        if (this.deviceResult != null || this.responseError != null) {
            this.deviceResultStateListener.isReady();
        }
    }

    public static interface DeviceResultStateListener {
        public void isReady();
    }

    public static enum LogLevel {
        NONE,
        INFO,
        DEBUG,
        VERBOSE;

    }

    private class CaptchaReceiver
    extends BroadcastReceiver {
        private CaptchaReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            boolean resultOk = intent.getBooleanExtra("RESULT_OK", false);
            Shield.this.updateChallenge(resultOk);
            if (!resultOk) {
                intent = new Intent(Shield.this.application.getApplicationContext(), InternalBlockedDialog.class);
                intent.addFlags(0x10000000);
                Shield.this.application.startActivity(intent);
            }
        }
    }

    public static class Builder {
        private final Application application;
        private String siteId;
        private String sessionId;
        private String sessionCreated;
        private String region;
        private String environment;
        private String bypassCode;
        private String secretKey;
        private String tag;
        private LogLevel logLevel;
        private Boolean sendSignatureAutomatically;
        private ShieldCallback<JSONObject> deviceShieldCallback;
        private Boolean isMockingEnabled = false;
        private Thread thread;
        private String partnerId;
        private Boolean needBackgroundListener = false;

        @RequiresPermission(value="android.permission.INTERNET")
        public Builder(@NonNull Context context, @NonNull String siteId, @NonNull String secretKey) {
            this.application = (Application)context.getApplicationContext();
            if (this.application == null) {
                throw new IllegalArgumentException("Application context must not be null.");
            }
            if (!Utils.hasPermission(context, "android.permission.INTERNET")) {
                throw new IllegalArgumentException("INTERNET permission is required.");
            }
            if (Utils.isNullOrEmpty(siteId)) {
                throw new IllegalArgumentException("siteId must not be null or empty.");
            }
            this.siteId = siteId;
            if (Utils.isNullOrEmpty(secretKey)) {
                throw new IllegalArgumentException("secretKey must not be null or empty.");
            }
            this.secretKey = secretKey;
        }

        @AnyThread
        public Builder setEnvironment(String environment) {
            if (Utils.isNullOrEmpty(environment)) {
                throw new IllegalArgumentException("environment must not be null or empty.");
            }
            this.environment = environment;
            return this;
        }

        public Builder setLogLevel(@NonNull LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder registerDeviceShieldCallback(ShieldCallback<JSONObject> deviceShieldCallback) {
            this.deviceShieldCallback = deviceShieldCallback;
            Looper currentLooper = Looper.myLooper();
            this.thread = currentLooper == null || currentLooper != Looper.getMainLooper() ? Thread.currentThread() : null;
            return this;
        }

        public Builder enableMocking() {
            this.isMockingEnabled = true;
            return this;
        }

        public Builder enableBackgroundListener() {
            this.needBackgroundListener = true;
            return this;
        }

        public Builder setPartnerId(String partnerId) {
            this.partnerId = partnerId;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Shield build() {
            if (Utils.isNullOrEmpty(this.tag)) {
                this.tag = this.siteId;
            }
            List list = INSTANCES;
            synchronized (list) {
                if (INSTANCES.contains(this.siteId)) {
                    throw new IllegalStateException("Duplicate Shield client created with siteId: " + this.siteId);
                }
                INSTANCES.add(this.tag);
            }
            try {
                this.sessionId = UUID.randomUUID().toString().replaceAll("[^a-zA-Z0-9]", "");
            }
            catch (Exception e) {
                this.sessionId = UUID.randomUUID().toString();
            }
            try {
                this.sessionCreated = String.valueOf(System.currentTimeMillis() / 1000L);
            }
            catch (Exception e) {
                this.sessionCreated = "";
            }
            if (Utils.isNullOrEmpty(this.region)) {
                this.region = Shield.REGION;
            }
            if (Utils.isNullOrEmpty(this.environment)) {
                this.environment = "PROD";
            }
            if (this.logLevel == null) {
                this.logLevel = LogLevel.NONE;
            }
            if (this.sendSignatureAutomatically == null) {
                this.sendSignatureAutomatically = true;
            }
            if (this.isMockingEnabled == null) {
                this.isMockingEnabled = false;
            }
            if (this.partnerId == null) {
                this.partnerId = "";
            }
            CSLogger logger = CSLogger.with(this.logLevel);
            NetTaskQueue.NetworkExecutorService networkExecutorService = new NetTaskQueue.NetworkExecutorService();
            NetTaskQueue netTaskQueue = NetTaskQueue.create(networkExecutorService);
            NativeUtils nativeUtils = new NativeUtils();
            CryptoUtils cryptoUtils = new CryptoUtils(nativeUtils);
            SendAttributesNetTask sendAttributesNetTask = new SendAttributesNetTask(this.siteId, logger, cryptoUtils, this.environment);
            SendDeviceSignatureNetTask sendDeviceSignatureNetTask = new SendDeviceSignatureNetTask(this.siteId, logger, cryptoUtils, this.environment);
            ShieldContext shieldContext = ShieldContext.create(this.application.getApplicationContext(), this.siteId, this.sessionId, this.sessionCreated, this.bypassCode, nativeUtils, this.needBackgroundListener);
            ExecutorService contextExecutorService = Executors.newSingleThreadExecutor();
            GetRiskAssessmentNetTask getRiskAssessmentNetTask = new GetRiskAssessmentNetTask(this.siteId, this.secretKey, this.environment, logger);
            APICountNetTask apiCountNetTask = new APICountNetTask(this.siteId, this.secretKey, this.sessionId);
            UpdateCaptchaNetTask updateCaptchaNetTask = new UpdateCaptchaNetTask(this.siteId, this.secretKey, this.sessionId);
            URLProvider urlProvider = new URLProvider((Context)this.application, netTaskQueue, this.siteId, this.secretKey, logger);
            ErrorReportingNetTask errorReportingNetTask = new ErrorReportingNetTask(this.siteId, this.sessionId, true);
            InternalLogger.init(this.application, urlProvider, netTaskQueue, errorReportingNetTask, false);
            ShieldRepositoryImpl shieldRepository = new ShieldRepositoryImpl(this.siteId, this.sessionId, this.secretKey, this.partnerId, netTaskQueue, getRiskAssessmentNetTask, sendDeviceSignatureNetTask, sendAttributesNetTask, updateCaptchaNetTask, apiCountNetTask, shieldContext, contextExecutorService, urlProvider, logger);
            return new Shield(this.application, this.sessionId, this.siteId, true, shieldRepository, logger, this.deviceShieldCallback, shieldContext, this.thread, this.isMockingEnabled, this.needBackgroundListener);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Environment {
    }
}

