/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android;

import android.app.Application;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import com.shield.android.Shield;
import com.shield.android.ShieldApplicationLifecycleCallbacks;
import java.util.HashMap;

public class ScreenshotChecker {
    private static ContentObserver contentObserver;

    private static void queryRelativeDataColumn(Application application, Uri uri) {
        ContentResolver resolver;
        Cursor query;
        String[] projection = new String[2];
        projection[0] = "_display_name";
        if (Build.VERSION.SDK_INT >= 29) {
            projection[1] = "relative_path";
        }
        if ((query = (resolver = application.getContentResolver()).query(uri, projection, null, null, null)) != null && query.moveToFirst()) {
            int relativePathColumnIndex = 0;
            if (Build.VERSION.SDK_INT >= 29) {
                relativePathColumnIndex = query.getColumnIndex("relative_path");
            }
            int displayNameColumnIndex = query.getColumnIndex("_display_name");
            do {
                String name = query.getString(displayNameColumnIndex);
                String relativePath = query.getString(relativePathColumnIndex);
                if (!name.toLowerCase().contains("screenshot") && !relativePath.toLowerCase().contains("screenshot")) continue;
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("event_name", "screenshot");
                String screenName = "screenshot";
                if (ShieldApplicationLifecycleCallbacks.screenNameReference != null) {
                    screenName = (String)ShieldApplicationLifecycleCallbacks.screenNameReference.get();
                }
                Shield.getInstance().sendDeviceSignature(screenName, data);
            } while (query.moveToNext());
        }
    }

    private static void checkScreenshot(Application application, Uri uri) {
        ScreenshotChecker.queryRelativeDataColumn(application, uri);
    }

    public static void start(Application application) {
        if (contentObserver == null) {
            contentObserver = ScreenshotChecker.registerResolver(application, application.getContentResolver());
        }
    }

    public static void stop(Application application) {
        if (contentObserver != null) {
            application.getContentResolver().unregisterContentObserver(contentObserver);
        }
    }

    private static ContentObserver registerResolver(final Application application, ContentResolver contentResolver) {
        ContentObserver contentObserver = new ContentObserver(new Handler(Looper.getMainLooper())){

            public void onChange(boolean selfChange, Uri uri) {
                super.onChange(selfChange, uri);
                if (uri != null) {
                    ScreenshotChecker.checkScreenshot(application, uri);
                }
            }
        };
        contentResolver.registerContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, true, contentObserver);
        return contentObserver;
    }
}

