/*
 * Decompiled with CFR 0.152.
 */
package com.shield.android;

import java.io.IOException;

public class ShieldException
extends RuntimeException {
    public final String url;
    public final Kind kind;
    public final int code;
    public final String message;
    public final String body;

    public static ShieldException httpError(String url, int code, String message, String body) {
        Kind kind = Kind.HTTP;
        return new ShieldException(url, code, message, body, kind, null);
    }

    public static ShieldException networkError(IOException exception) {
        String string = exception.getMessage();
        Kind kind = Kind.NETWORK;
        return new ShieldException(null, 0, string, null, kind, exception);
    }

    public static ShieldException unexpectedError(Throwable exception) {
        String string = exception.getMessage();
        Kind kind = Kind.UNEXPECTED;
        return new ShieldException(null, 0, string, null, kind, exception);
    }

    private ShieldException(String url, int code, String message, String body, Kind kind, Throwable exception) {
        super(message, exception);
        this.url = url;
        this.kind = kind;
        this.message = message;
        this.body = body;
        this.code = code;
    }

    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind NETWORK;
        public static final /* enum */ Kind HTTP;
        public static final /* enum */ Kind UNEXPECTED;
        private static final /* synthetic */ Kind[] a;

        public static Kind[] values() {
            return (Kind[])a.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        static {
            Kind kind;
            NETWORK = new Kind();
            HTTP = new Kind();
            Kind kind2 = kind;
            UNEXPECTED = new Kind();
            a = new Kind[]{NETWORK, HTTP, kind2};
        }
    }
}

