/*
 * Decompiled with CFR 0.152.
 */
package com.shenhua.libs.sensocketcore.message;

import com.shenhua.libs.sensocketcore.MessagePool;
import com.shenhua.libs.sensocketcore.message.Message;
import java.util.LinkedList;

public final class MessageBuffer {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    private static int capacity_small = 8192;
    private static int capacity_middle = 131072;
    private static int capacity_large = 0x100000;
    private static int size_small = 5;
    private static int size_middle = 2;
    private static int size_large = 0;
    private byte[] bufferSmall;
    private byte[] bufferMiddle;
    private byte[] bufferLarge;
    private MessageBufferTracker trackerBufferSmall;
    private MessageBufferTracker trackerBufferMiddle;
    private MessageBufferTracker trackerBufferLarge;
    private static int max_size_temporary_cache = 2;
    private LinkedList<byte[]> mTemporaryCacheList = new LinkedList();
    private final int REUSE_SMALL = 1;
    private final int REUSE_MIDDLE = 2;
    private final int REUSE_LARGE = 3;
    private final int REUSE_TEMP = 4;

    public static void init(int capacitySmall, int capacityMiddle, int capacityLarge, int sizeSmall, int sizeMiddle, int sizeLarge, int maxTemporaryCacheSize) {
        capacity_small = capacitySmall;
        capacity_middle = capacityMiddle;
        capacity_large = capacityLarge;
        size_small = sizeSmall;
        size_middle = sizeMiddle;
        size_large = sizeLarge;
        max_size_temporary_cache = maxTemporaryCacheSize;
    }

    public MessageBuffer() {
        this.bufferSmall = new byte[size_small * capacity_small];
        this.bufferMiddle = new byte[size_middle * capacity_middle];
        this.bufferLarge = new byte[size_large * capacity_large];
        this.trackerBufferSmall = new MessageBufferTracker(size_small);
        this.trackerBufferMiddle = new MessageBufferTracker(size_middle);
        this.trackerBufferLarge = new MessageBufferTracker(size_large);
    }

    public Message build(byte[] src, int offset, int length) {
        Message msg = this.build(length);
        System.arraycopy(src, offset, msg.data, msg.offset, length);
        msg.length = length;
        return msg;
    }

    private Message build(int length) {
        int blockIndex;
        Message ret = MessagePool.get();
        ret.srcReuseType = length <= capacity_small ? 1 : (length <= capacity_middle ? 2 : (length <= capacity_large ? 3 : 4));
        if (length <= capacity_small && (blockIndex = this.trackerBufferSmall.get()) != -1) {
            ret.blockIndex = blockIndex;
            ret.data = this.bufferSmall;
            ret.capacity = capacity_small;
            ret.offset = capacity_small * ret.blockIndex;
            ret.length = 0;
            ret.dstReuseType = 1;
            return ret;
        }
        if (length <= capacity_middle && (blockIndex = this.trackerBufferMiddle.get()) != -1) {
            ret.blockIndex = blockIndex;
            ret.data = this.bufferMiddle;
            ret.capacity = capacity_middle;
            ret.offset = capacity_middle * ret.blockIndex;
            ret.length = 0;
            ret.dstReuseType = 2;
            return ret;
        }
        if (length <= capacity_large && (blockIndex = this.trackerBufferLarge.get()) != -1) {
            ret.blockIndex = blockIndex;
            ret.data = this.bufferLarge;
            ret.capacity = capacity_large;
            ret.offset = capacity_large * ret.blockIndex;
            ret.length = 0;
            ret.dstReuseType = 3;
            return ret;
        }
        int mTemporaryCacheListSize = this.mTemporaryCacheList.size();
        for (int i = 0; i < mTemporaryCacheListSize; ++i) {
            if (length > this.mTemporaryCacheList.get(i).length) continue;
            ret.blockIndex = 0;
            ret.data = this.mTemporaryCacheList.remove(i);
            ret.capacity = ret.data.length;
            ret.offset = 0;
            ret.length = 0;
            ret.dstReuseType = 4;
            return ret;
        }
        ret.blockIndex = 0;
        ret.data = new byte[length];
        ret.capacity = ret.data.length;
        ret.offset = 0;
        ret.length = 0;
        ret.dstReuseType = 4;
        return ret;
    }

    public void release(Message msg) {
        if (msg.dstReuseType == 1) {
            this.trackerBufferSmall.release(msg.blockIndex);
            MessagePool.put(msg);
        } else if (msg.dstReuseType == 2) {
            this.trackerBufferMiddle.release(msg.blockIndex);
            MessagePool.put(msg);
        } else if (msg.dstReuseType == 3) {
            this.trackerBufferLarge.release(msg.blockIndex);
            MessagePool.put(msg);
        } else if (msg.dstReuseType == 4) {
            if (max_size_temporary_cache > 0) {
                while (this.mTemporaryCacheList.size() >= max_size_temporary_cache) {
                    this.mTemporaryCacheList.poll();
                }
                this.mTemporaryCacheList.add(msg.data);
                msg.reset();
            } else {
                this.mTemporaryCacheList.clear();
                msg.reset();
            }
        }
    }

    public class MessageBufferTracker {
        private int size;
        private byte[] arrayAvailableIndex;
        private int usedCount;
        private int nextAvailableIndex;

        public MessageBufferTracker(int size) {
            this.size = size;
            this.arrayAvailableIndex = new byte[size];
            for (int i = 0; i < size; ++i) {
                this.arrayAvailableIndex[i] = 1;
            }
            this.usedCount = 0;
            this.nextAvailableIndex = 0;
        }

        private int findAvailableIndex() {
            if (this.usedCount < this.size) {
                int i;
                for (i = this.nextAvailableIndex; i >= 0 && i < this.size; ++i) {
                    if (this.arrayAvailableIndex[i] != 1) continue;
                    return i;
                }
                for (i = 0; i >= 0 && i < this.nextAvailableIndex; ++i) {
                    if (this.arrayAvailableIndex[i] != 1) continue;
                    return i;
                }
            }
            return -1;
        }

        public int get() {
            int index = this.findAvailableIndex();
            if (index != -1) {
                this.arrayAvailableIndex[index] = 0;
                ++this.usedCount;
                ++this.nextAvailableIndex;
                if (this.nextAvailableIndex >= this.size) {
                    this.nextAvailableIndex = 0;
                }
            }
            return index;
        }

        public void release(int index) {
            if (index < 0 || index >= this.size) {
                return;
            }
            if (this.arrayAvailableIndex[index] == 0) {
                this.arrayAvailableIndex[index] = 1;
                --this.usedCount;
            }
        }
    }
}

