/*
 * Decompiled with CFR 0.152.
 */
package com.shenhua.libs.sensocketcore;

import com.shenhua.libs.sensocketcore.BaseMessageProcessor;
import com.shenhua.libs.sensocketcore.message.Message;
import com.shenhua.libs.sensocketcore.message.MessageReadQueen;
import com.shenhua.libs.sensocketcore.message.MessageWriteQueen;

public abstract class BaseClient {
    public MessageReadQueen mReadMessageQueen = new MessageReadQueen();
    public MessageWriteQueen mWriteMessageQueen = new MessageWriteQueen();
    protected BaseMessageProcessor mMessageProcessor;

    public BaseClient(BaseMessageProcessor mMessageProcessor) {
        this.mMessageProcessor = mMessageProcessor;
    }

    public void clearUnreachableMessages() {
        Message msg = this.pollWriteMessage();
        while (null != msg) {
            this.removeWriteMessage(msg);
            msg = this.pollWriteMessage();
        }
    }

    public void onReceiveData(byte[] src, int offset, int length) {
        Message msg = this.mReadMessageQueen.build(src, offset, length);
        this.mReadMessageQueen.add(msg);
    }

    public void onReceiveMessageClear() {
        Message msg = this.mReadMessageQueen.mReadQueen.poll();
        while (null != msg) {
            this.mReadMessageQueen.remove(msg);
            msg = this.mReadMessageQueen.mReadQueen.poll();
        }
    }

    public void onSendMessage(byte[] src, int offset, int length) {
        Message msg = this.mWriteMessageQueen.build(src, offset, length);
        this.mWriteMessageQueen.add(msg);
        this.onCheckConnect();
    }

    protected Message pollWriteMessage() {
        return this.mWriteMessageQueen.mWriteQueen.poll();
    }

    protected void removeWriteMessage(Message msg) {
        this.mWriteMessageQueen.remove(msg);
    }

    public abstract void onCheckConnect();

    public abstract void onClose();

    public abstract boolean onRead();

    public abstract boolean onWrite();
}

