/*
 * Decompiled with CFR 0.152.
 */
package com.shenhua.libs.bannerview;

import android.content.Context;
import android.os.Handler;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.shenhua.libs.bannerview.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class BannerView
extends FrameLayout
implements ViewPager.OnPageChangeListener {
    private int bannerStyle = 0;
    private int delayTime = 2000;
    private int mIndicatorSelectedResId = R.drawable.indicator_gray_circle;
    private int mIndicatorUnselectedResId = R.drawable.indicator_white_circle;
    private int titleHeight;
    private int titleBackground;
    private int titleTextColor;
    private int titleTextSize;
    private int defaultImage = -1;
    private int count = 0;
    private int currentItem;
    private int gravity = -1;
    private int lastPosition = 1;
    private boolean isAutoPlay = true;
    private List<ImageView> imageViews;
    private List<ImageView> indicatorImages;
    private Context context;
    private ViewPager viewPager;
    private LinearLayout indicator;
    private LinearLayout indicatorInside;
    private LinearLayout titleView;
    private Handler handler = new Handler();
    private OnBannerItemClickListener listener;
    private String[] titles;
    private TextView bannerTitle;
    private TextView numIndicatorInside;
    private TextView numIndicator;
    private BannerPagerAdapter adapter;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private final Runnable task = new Runnable(){

        @Override
        public void run() {
            if (BannerView.this.isAutoPlay && BannerView.this.count > 1) {
                BannerView.this.currentItem = BannerView.this.currentItem % (BannerView.this.count + 1) + 1;
                if (BannerView.this.currentItem == 1) {
                    BannerView.this.viewPager.setCurrentItem(BannerView.this.currentItem, false);
                } else {
                    BannerView.this.viewPager.setCurrentItem(BannerView.this.currentItem);
                }
                BannerView.this.handler.postDelayed(BannerView.this.task, (long)BannerView.this.delayTime);
            }
        }
    };

    public BannerView(Context context) {
        this(context, null);
    }

    public BannerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BannerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.imageViews = new ArrayList<ImageView>();
        this.indicatorImages = new ArrayList<ImageView>();
        this.initView();
    }

    private void initView() {
        this.imageViews.clear();
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.banner, (ViewGroup)this, true);
        this.viewPager = (ViewPager)view.findViewById(R.id.viewpager);
        this.titleView = (LinearLayout)view.findViewById(R.id.titleView);
        this.indicator = (LinearLayout)view.findViewById(R.id.indicator);
        this.indicatorInside = (LinearLayout)view.findViewById(R.id.indicatorInside);
        this.bannerTitle = (TextView)view.findViewById(R.id.bannerTitle);
        this.numIndicator = (TextView)view.findViewById(R.id.numIndicator);
        this.numIndicatorInside = (TextView)view.findViewById(R.id.numIndicatorInside);
        this.mIndicatorSelectedResId = R.drawable.indicator_gray_circle;
        this.mIndicatorUnselectedResId = R.drawable.indicator_white_circle;
        this.titleBackground = -1;
        this.titleHeight = -1;
        this.titleTextColor = -1;
        this.titleTextSize = -1;
    }

    private void initImages() {
        this.imageViews.clear();
        if (this.bannerStyle == 1 || this.bannerStyle == 4 || this.bannerStyle == 5) {
            this.createIndicator();
        } else if (this.bannerStyle == 3) {
            this.numIndicatorInside.setText((CharSequence)("1/" + this.count));
        } else if (this.bannerStyle == 2) {
            this.numIndicator.setText((CharSequence)("1/" + this.count));
        }
    }

    private void createIndicator() {
        this.indicatorImages.clear();
        this.indicator.removeAllViews();
        this.indicatorInside.removeAllViews();
        for (int i = 0; i < this.count; ++i) {
            int mIndicatorMargin;
            ImageView imageView = new ImageView(this.context);
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            int mIndicatorWidth = 8;
            int mIndicatorHeight = 8;
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(mIndicatorWidth, mIndicatorHeight);
            params.leftMargin = mIndicatorMargin = 5;
            params.rightMargin = mIndicatorMargin;
            if (i == 0) {
                imageView.setImageResource(this.mIndicatorSelectedResId);
            } else {
                imageView.setImageResource(this.mIndicatorUnselectedResId);
            }
            this.indicatorImages.add(imageView);
            if (this.bannerStyle == 1 || this.bannerStyle == 4) {
                this.indicator.addView((View)imageView, (ViewGroup.LayoutParams)params);
                continue;
            }
            if (this.bannerStyle != 5) continue;
            this.indicatorInside.addView((View)imageView, (ViewGroup.LayoutParams)params);
        }
    }

    private void startAutoPlay() {
        if (this.isAutoPlay) {
            this.handler.removeCallbacks(this.task);
            this.handler.postDelayed(this.task, (long)this.delayTime);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.count > 1) {
            switch (ev.getAction()) {
                case 0: {
                    this.isAutoPlay(false);
                    break;
                }
                case 1: 
                case 3: {
                    this.isAutoPlay(true);
                }
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(position);
        }
        if (this.bannerStyle == 1 || this.bannerStyle == 4 || this.bannerStyle == 5) {
            this.indicatorImages.get((this.lastPosition - 1 + this.count) % this.count).setImageResource(this.mIndicatorUnselectedResId);
            this.indicatorImages.get((position - 1 + this.count) % this.count).setImageResource(this.mIndicatorSelectedResId);
            this.lastPosition = position;
        }
        if (position == 0) {
            position = 1;
        }
        switch (this.bannerStyle) {
            case 1: {
                break;
            }
            case 2: {
                if (position > this.count) {
                    position = this.count;
                }
                this.numIndicator.setText((CharSequence)(position + "/" + this.count));
                break;
            }
            case 3: {
                if (position > this.count) {
                    position = this.count;
                }
                this.numIndicatorInside.setText((CharSequence)(position + "/" + this.count));
                if (this.titles == null || this.titles.length <= 0) break;
                if (position > this.titles.length) {
                    position = this.titles.length;
                }
                this.bannerTitle.setText((CharSequence)this.titles[position - 1]);
                break;
            }
            case 4: {
                if (this.titles == null || this.titles.length <= 0) break;
                if (position > this.titles.length) {
                    position = this.titles.length;
                }
                this.bannerTitle.setText((CharSequence)this.titles[position - 1]);
                break;
            }
            case 5: {
                if (this.titles == null || this.titles.length <= 0) break;
                if (position > this.titles.length) {
                    position = this.titles.length;
                }
                this.bannerTitle.setText((CharSequence)this.titles[position - 1]);
            }
        }
    }

    public void onPageScrollStateChanged(int state) {
        switch (state) {
            case 1: {
                this.isAutoPlay = false;
                break;
            }
            case 2: {
                this.isAutoPlay = true;
                break;
            }
            case 0: {
                if (this.viewPager.getCurrentItem() == 0) {
                    this.viewPager.setCurrentItem(this.count, false);
                } else if (this.viewPager.getCurrentItem() == this.count + 1) {
                    this.viewPager.setCurrentItem(1, false);
                }
                this.currentItem = this.viewPager.getCurrentItem();
                this.isAutoPlay = true;
            }
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(state);
        }
    }

    private void setData() {
        this.currentItem = 1;
        if (this.adapter == null) {
            this.adapter = new BannerPagerAdapter();
            this.viewPager.setAdapter((PagerAdapter)this.adapter);
        } else {
            this.adapter.notifyDataSetChanged();
        }
        this.viewPager.setFocusable(true);
        this.viewPager.setCurrentItem(1);
        this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        if (this.gravity != -1) {
            this.indicator.setGravity(this.gravity);
        }
        this.startAutoPlay();
    }

    public void isAutoPlay(boolean isAutoPlay) {
        this.isAutoPlay = isAutoPlay;
        this.startAutoPlay();
    }

    public void setBannerStyle(int bannerStyle) {
        this.bannerStyle = bannerStyle;
        switch (bannerStyle) {
            case 1: {
                this.indicator.setVisibility(0);
                break;
            }
            case 2: {
                this.numIndicator.setVisibility(0);
                break;
            }
            case 3: {
                this.numIndicatorInside.setVisibility(0);
                break;
            }
            case 4: {
                this.indicator.setVisibility(0);
                break;
            }
            case 5: {
                this.indicatorInside.setVisibility(0);
                break;
            }
        }
    }

    public void setBannerTitleArray(String[] titles) {
        this.titles = titles;
        if (this.bannerStyle == 4 || this.bannerStyle == 3 || this.bannerStyle == 5) {
            if (this.titleBackground != -1) {
                this.titleView.setBackgroundColor(this.titleBackground);
            }
            if (this.titleHeight != -1) {
                this.titleView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.titleHeight));
            }
            if (this.titleTextColor != -1) {
                this.bannerTitle.setTextColor(this.titleTextColor);
            }
            if (this.titleTextSize != -1) {
                this.bannerTitle.setTextSize((float)this.titleTextSize);
            }
            if (titles != null && titles.length > 0) {
                this.bannerTitle.setText((CharSequence)titles[0]);
                this.bannerTitle.setVisibility(0);
                this.titleView.setVisibility(0);
            }
        }
    }

    public void setBannerTitleList(List<String> titles) {
        this.setBannerTitleArray(titles.toArray(new String[titles.size()]));
    }

    public void setImageArray(Object[] imagesUrl) {
        if (imagesUrl == null || imagesUrl.length <= 0) {
            return;
        }
        this.count = imagesUrl.length;
        this.initImages();
        for (int i = 0; i <= this.count + 1; ++i) {
            ImageView iv = new ImageView(this.context);
            iv.setScaleType(ImageView.ScaleType.FIT_XY);
            Object url = i == 0 ? imagesUrl[this.count - 1] : (i == this.count + 1 ? imagesUrl[0] : imagesUrl[i - 1]);
            this.imageViews.add(iv);
            if (this.defaultImage != -1) {
                Glide.with((Context)this.context).load(url).centerCrop().crossFade().into(iv);
                continue;
            }
            Glide.with((Context)this.context).load(url).centerCrop().crossFade().placeholder(this.defaultImage).into(iv);
        }
        this.setData();
    }

    public void setImageList(List<?> imagesUrl) {
        if (imagesUrl == null || imagesUrl.size() <= 0) {
            return;
        }
        this.count = imagesUrl.size();
        this.initImages();
        for (int i = 0; i <= this.count + 1; ++i) {
            ImageView iv = new ImageView(this.context);
            iv.setScaleType(ImageView.ScaleType.FIT_XY);
            Object url = i == 0 ? imagesUrl.get(this.count - 1) : (i == this.count + 1 ? imagesUrl.get(0) : imagesUrl.get(i - 1));
            this.imageViews.add(iv);
            if (this.defaultImage != -1) {
                Glide.with((Context)this.context).load(url).centerCrop().crossFade().into(iv);
                continue;
            }
            Glide.with((Context)this.context).load(url).centerCrop().crossFade().placeholder(this.defaultImage).into(iv);
        }
        this.setData();
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public void setIndicatorGravity(int type) {
        switch (type) {
            case 5: {
                this.gravity = 8388627;
                break;
            }
            case 6: {
                this.gravity = 17;
                break;
            }
            case 7: {
                this.gravity = 8388629;
            }
        }
    }

    public void setOnBannerClickListener(OnBannerItemClickListener listener) {
        this.listener = listener;
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
    }

    public static class BannerViewConfig {
        public static final int NOT_INDICATOR = 0;
        public static final int CIRCLE_INDICATOR = 1;
        public static final int NUM_INDICATOR = 2;
        public static final int NUM_INDICATOR_TITLE = 3;
        public static final int CIRCLE_INDICATOR_TITLE_VERTICAL = 4;
        public static final int CIRCLE_INDICATOR_TITLE_HORIZONTAL = 5;
        public static final int LEFT = 5;
        public static final int CENTER = 6;
        public static final int RIGHT = 7;
        public static final int INDICATOR_SIZE = 8;
        public static final int PADDING_SIZE = 5;
        public static final int TITLE_BACKGROUND = -1;
        public static final int TITLE_HEIGHT = -1;
        public static final int TITLE_TEXT_COLOR = -1;
        public static final int TITLE_TEXT_SIZE = -1;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface BannerTypeChecker {
        }
    }

    public static interface OnBannerItemClickListener {
        public void OnBannerClick(View var1, int var2);
    }

    private class BannerPagerAdapter
    extends PagerAdapter {
        private BannerPagerAdapter() {
        }

        public int getCount() {
            return BannerView.this.imageViews.size();
        }

        public boolean isViewFromObject(View arg0, Object arg1) {
            return arg0 == arg1;
        }

        public Object instantiateItem(ViewGroup container, final int position) {
            container.addView((View)BannerView.this.imageViews.get(position));
            ImageView view = (ImageView)BannerView.this.imageViews.get(position);
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (BannerView.this.listener != null) {
                        BannerView.this.listener.OnBannerClick(v, position);
                    }
                }
            });
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)BannerView.this.imageViews.get(position));
        }
    }
}

