/*
 * Decompiled with CFR 0.152.
 */
package com.sha.kamel.rxlocationsettingsrequest;

import android.app.Activity;
import android.content.IntentSender;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.annimon.stream.function.Consumer;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.sha.kamel.rxlocationsettingsrequest.RxLocationSettingsRequestFrag;
import io.reactivex.Single;
import io.reactivex.subjects.PublishSubject;

public class RxGps {
    static final int REQUEST_CHECK_SETTINGS = 0;
    private RxLocationSettingsRequestFrag frag;
    private PublishSubject<Boolean> ps = PublishSubject.create();
    private IntentSender intentSender;

    private synchronized void addFragment(@NonNull FragmentManager fragmentManager) {
        this.frag = this.findFragment(fragmentManager);
        if (this.frag == null) {
            this.frag = RxLocationSettingsRequestFrag.newInstance((Consumer<RxLocationSettingsRequestFrag>)((Consumer)this::startResolutionForResult));
            fragmentManager.beginTransaction().add((Fragment)this.frag, RxLocationSettingsRequestFrag.class.getSimpleName()).commitAllowingStateLoss();
            return;
        }
        this.startResolutionForResult(this.frag);
    }

    private void startResolutionForResult(RxLocationSettingsRequestFrag frag) {
        try {
            frag.startIntentSenderForResult(this.intentSender, 0, null, 0, 0, 0, null);
            frag.listenToPeResolutionResult(this::onResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RxLocationSettingsRequestFrag findFragment(@NonNull FragmentManager fragmentManager) {
        return (RxLocationSettingsRequestFrag)fragmentManager.findFragmentByTag(RxLocationSettingsRequestFrag.class.getSimpleName());
    }

    public Single<Boolean> enable(LocationRequest locationRequest, FragmentActivity fragmentActivity) {
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest).setAlwaysShow(true);
        LocationServices.getSettingsClient((Activity)fragmentActivity).checkLocationSettings(builder.build()).addOnSuccessListener((Activity)fragmentActivity, locationSettingsResponse -> this.onResult(true)).addOnFailureListener((Activity)fragmentActivity, e -> {
            e.printStackTrace();
            int statusCode = ((ApiException)e).getStatusCode();
            switch (statusCode) {
                case 6: {
                    this.intentSender = ((ResolvableApiException)e).getResolution().getIntentSender();
                    this.addFragment(fragmentActivity.getSupportFragmentManager());
                    break;
                }
                case 8502: {
                    this.onResult(false);
                }
            }
        });
        return Single.fromObservable(this.ps);
    }

    private void onResult(boolean result) {
        this.ps.onNext((Object)result);
        this.ps.onComplete();
    }
}

