/*
 * Decompiled with CFR 0.152.
 */
package com.sha.kamel.rxlocationsettingsrequest;

import android.app.Activity;
import android.content.IntentSender;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.sha.kamel.rxlocationsettingsrequest.RxLocationSettingsRequestFrag;
import io.reactivex.subjects.PublishSubject;

public class RxLocationSettingsRequest {
    static final int REQUEST_CHECK_SETTINGS = 0;
    private RxLocationSettingsRequestFrag frag;
    private PublishSubject<Boolean> ps = PublishSubject.create();

    private synchronized void addFragment(@NonNull FragmentManager fragmentManager) {
        this.frag = this.findFragment(fragmentManager);
        if (this.frag == null) {
            this.frag = RxLocationSettingsRequestFrag.newInstance();
            fragmentManager.beginTransaction().add((Fragment)this.frag, RxLocationSettingsRequestFrag.class.getSimpleName()).commitNow();
        }
    }

    private RxLocationSettingsRequestFrag findFragment(@NonNull FragmentManager fragmentManager) {
        return (RxLocationSettingsRequestFrag)fragmentManager.findFragmentByTag(RxLocationSettingsRequestFrag.class.getSimpleName());
    }

    public PublishSubject<Boolean> request(LocationRequest locationRequest, FragmentActivity fragmentActivity) {
        this.addFragment(fragmentActivity.getSupportFragmentManager());
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest);
        builder.setAlwaysShow(true);
        LocationServices.getSettingsClient((Activity)fragmentActivity).checkLocationSettings(builder.build()).addOnSuccessListener((Activity)fragmentActivity, locationSettingsResponse -> this.onResult(true)).addOnFailureListener((Activity)fragmentActivity, e -> {
            e.printStackTrace();
            int statusCode = ((ApiException)e).getStatusCode();
            switch (statusCode) {
                case 6: {
                    try {
                        ResolvableApiException resolvable = (ResolvableApiException)e;
                        this.frag.startIntentSenderForResult(resolvable.getResolution().getIntentSender(), 0, null, 0, 0, 0, null);
                        this.frag.listenToPeResolutionResult(this::onResult);
                    }
                    catch (IntentSender.SendIntentException sendEx) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 8502: {
                    this.onResult(false);
                }
            }
        });
        return this.ps;
    }

    private void onResult(boolean result) {
        this.ps.onNext((Object)result);
        this.ps.onComplete();
    }
}

