/*
 * Decompiled with CFR 0.152.
 */
package com.sha.kamel.rxgallery;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.annimon.stream.function.Consumer;
import com.sha.kamel.rxgallery.Request;
import com.sha.kamel.rxgallery.Result;
import com.sha.kamel.rxgallery.RxGalleryFrag;
import io.reactivex.Single;
import io.reactivex.processors.PublishProcessor;
import java.util.Arrays;
import java.util.List;

public class RxGallery {
    private PublishProcessor<Result> pp = PublishProcessor.create();
    private RxGalleryFrag frag;

    public Single<Uri> image(@NonNull FragmentActivity activity) {
        return this.requestImage(activity, false, MimeType.IMAGE).map(uris -> (Uri)uris.get(0));
    }

    @TargetApi(value=18)
    public Single<List<Uri>> multipleImages(@NonNull FragmentActivity activity) {
        return this.requestImage(activity, true, MimeType.IMAGE);
    }

    public Single<Uri> audio(@NonNull FragmentActivity activity) {
        return this.requestImage(activity, false, MimeType.AUDIO).map(uris -> (Uri)uris.get(0));
    }

    @TargetApi(value=18)
    public Single<List<Uri>> multipleAudio(@NonNull FragmentActivity activity) {
        return this.requestImage(activity, true, MimeType.AUDIO);
    }

    public Single<Uri> video(@NonNull FragmentActivity activity) {
        return this.requestImage(activity, false, MimeType.VIDEO).map(uris -> (Uri)uris.get(0));
    }

    @TargetApi(value=18)
    public Single<List<Uri>> multipleVideos(@NonNull FragmentActivity activity) {
        return this.requestImage(activity, true, MimeType.VIDEO);
    }

    public Single<Uri> requestByType(@NonNull FragmentActivity activity, MimeType ... mimeType) {
        return this.requestImage(activity, false, mimeType).map(uris -> (Uri)uris.get(0));
    }

    @TargetApi(value=18)
    public Single<List<Uri>> requestMultipleByType(@NonNull FragmentActivity activity, MimeType ... mimeType) {
        return this.requestImage(activity, true, mimeType);
    }

    public Single<Bitmap> captureImage(@NonNull FragmentActivity activity) {
        Request request = new Request().setSource(Request.Source.IMAGE_CAPTURE);
        return this.request(activity, request).map(Result::getBitmap);
    }

    public Single<Uri> captureVideo(@NonNull FragmentActivity activity) {
        Request request = new Request().setSource(Request.Source.VIDEO_CAPTURE);
        return this.request(activity, request).map(Result::getUris).map(uris -> (Uri)uris.get(0));
    }

    private Single<Result> request(@NonNull FragmentActivity activity, @NonNull Request request) {
        this.addFragment(activity.getSupportFragmentManager(), request);
        this.frag.listenToResult((Consumer<Result>)((Consumer)result -> {
            this.pp.onNext(result);
            this.pp.onComplete();
        }));
        return Single.fromPublisher(this.pp);
    }

    private Single<List<Uri>> requestImage(@NonNull FragmentActivity activity, boolean multiSelectEnabled, MimeType ... mimeTypes) {
        Request request = new Request().setSource(Request.Source.GALLERY).setMultiSelectEnabled(multiSelectEnabled).setMimeTypes(Arrays.asList(mimeTypes));
        return this.request(activity, request).map(Result::getUris);
    }

    private synchronized void addFragment(@NonNull FragmentManager fragmentManager, Request request) {
        this.frag = this.findFragment(fragmentManager);
        if (this.frag == null) {
            this.frag = RxGalleryFrag.newInstance();
            fragmentManager.beginTransaction().add((Fragment)this.frag, RxGalleryFrag.class.getSimpleName()).commitNowAllowingStateLoss();
        }
        this.startActivityForResult(this.frag, request);
    }

    private void startActivityForResult(RxGalleryFrag frag, @NonNull Request request) {
        try {
            frag.start(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RxGalleryFrag findFragment(@NonNull FragmentManager fragmentManager) {
        return (RxGalleryFrag)fragmentManager.findFragmentByTag(RxGalleryFrag.class.getSimpleName());
    }

    public static enum MimeType {
        IMAGE("image/*"),
        VIDEO("video/*"),
        AUDIO("audio/*");

        private final String value;

        private MimeType(String mimeTypeString) {
            this.value = mimeTypeString;
        }

        public String toString() {
            return this.value;
        }
    }
}

