/*
 * Decompiled with CFR 0.152.
 */
package com.sha.kamel.rxgallery;

import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.Fragment;
import com.sha.kamel.rxgallery.Request;
import com.sha.kamel.rxgallery.Result;
import com.tbruyelle.rxpermissions2.RxPermissions;
import java.util.ArrayList;

class GalleryUtil {
    public static final int REQUEST_CODE = 12;

    GalleryUtil() {
    }

    public static void request(Request request, Fragment fragment) {
        new RxPermissions(fragment.getActivity()).request(new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}).subscribe(granted -> {
            if (granted.booleanValue()) {
                GalleryUtil.doRequest(request, fragment);
            }
        });
    }

    public static Bitmap fromIntent(Intent data, Context context) {
        Uri pickedImage = data.getData();
        String[] filePath = new String[]{"_data"};
        Cursor cursor = context.getContentResolver().query(pickedImage, filePath, null, null, null);
        cursor.moveToFirst();
        String imagePath = cursor.getString(cursor.getColumnIndex(filePath[0]));
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        cursor.close();
        return bitmap;
    }

    public static Result result(Intent data) {
        ClipData clipData;
        ArrayList<Uri> uris = new ArrayList<Uri>();
        if (data.getData() != null) {
            uris.add(data.getData());
        } else if (Build.VERSION.SDK_INT >= 18 && (clipData = data.getClipData()) != null) {
            for (int i = 0; i < clipData.getItemCount(); ++i) {
                uris.add(clipData.getItemAt(i).getUri());
            }
        }
        return new Result().setUris(uris);
    }

    public static void doRequest(Request request, Fragment fragment) {
        Intent intent;
        if (Build.VERSION.SDK_INT >= 19) {
            intent = new Intent("android.intent.action.OPEN_DOCUMENT");
            String[] mimeTypes = new String[request.getMimeTypes().size()];
            for (int i = 0; i < mimeTypes.length; ++i) {
                mimeTypes[i] = request.getMimeTypes().get(i).toString();
            }
            intent.putExtra("android.intent.extra.MIME_TYPES", mimeTypes);
            intent.setType("*/*");
        } else {
            intent = new Intent("android.intent.action.GET_CONTENT");
            intent.setType(request.getMimeTypes().get(0).toString());
        }
        if (Build.VERSION.SDK_INT >= 18) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", request.isMultiSelectEnabled());
        }
        intent.putExtra("android.intent.extra.LOCAL_ONLY", true).addFlags(1);
        fragment.startActivityForResult(intent, 12);
    }
}

