/*
 * Decompiled with CFR 0.152.
 */
package com.sha.kamel.phonefield.shared.ui.adapter;

import android.app.Fragment;
import android.content.Context;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.sha.kamel.phonefield.shared.ui.adapter.BaseViewHolder;
import com.sha.kamel.phonefield.shared.ui.adapter.RecyclerAdapterCallback;
import java.util.List;

public abstract class BaseRecyclerAdapter<M, VH extends BaseViewHolder<M>>
extends RecyclerView.Adapter<VH> {
    protected List<M> list;
    protected boolean isLoadingAdded;
    protected RecyclerAdapterCallback recyclerAdapterCallback;

    protected Context context() {
        return this.recyclerAdapterCallback.context();
    }

    protected AppCompatActivity activity() {
        return this.recyclerAdapterCallback.activity();
    }

    public Fragment findFragmentByTag(String tag) {
        return this.activity().getFragmentManager().findFragmentByTag(tag);
    }

    protected View view() {
        return this.recyclerAdapterCallback.view();
    }

    public BaseRecyclerAdapter(List<M> list, RecyclerAdapterCallback recyclerAdapterCallback) {
        this.list = list;
        this.recyclerAdapterCallback = recyclerAdapterCallback;
    }

    public VH onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.getViewHolder(parent, viewType);
    }

    public abstract VH getViewHolder(ViewGroup var1, int var2);

    public void onBindViewHolder(VH holder, int position) {
        try {
            M item = this.list.get(position);
            ((BaseViewHolder)((Object)holder)).item = item;
            ((BaseViewHolder)((Object)holder)).bindView(item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.list.size();
    }

    public M item(int position) {
        return this.list.get(position);
    }

    public void addAll(List<M> items) {
        this.list.addAll(items);
        this.notifyDataSetChanged();
    }

    public void replace(List<M> items) {
        this.list = items;
        this.notifyDataSetChanged();
    }

    public List<M> list() {
        return this.list;
    }

    public void clear() {
        this.list.clear();
        this.notifyDataSetChanged();
    }

    protected static interface ItemViewType {
        public static final int LOADING = 0;
        public static final int NORMAL = 1;
    }
}

