/*
 * Decompiled with CFR 0.152.
 */
package com.sha.kamel.phonefield;

import android.content.Context;
import android.support.v7.app.AppCompatActivity;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.sha.kamel.andrutil.Callback;
import com.sha.kamel.phonefield.Countries;
import com.sha.kamel.phonefield.Country;
import com.sha.kamel.phonefield.CountryAdapter;
import com.sha.kamel.phonefield.R;
import com.sha.kamel.phonefield.shared.ui.adapter.RecyclerAdapterCallback;
import com.sha.kamel.phonefield.shared.ui.recyclerviewdialog.SearchRecyclerViewDialogFrag;

public abstract class PhoneField
extends LinearLayout
implements RecyclerAdapterCallback {
    private ImageView iv_flag;
    private EditText et_phoneNumber;
    private Country mCountry;
    private PhoneNumberUtil mPhoneUtil = PhoneNumberUtil.getInstance();
    private AppCompatActivity activity;

    public void init(AppCompatActivity activity) {
        this.activity = activity;
    }

    public PhoneField(Context context) {
        this(context, null);
    }

    public PhoneField(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PhoneField(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        PhoneField.inflate((Context)this.getContext(), (int)this.getLayoutResId(), (ViewGroup)this);
        this.updateLayoutAttributes();
        this.prepareView();
    }

    protected void prepareView() {
        this.iv_flag = (ImageView)this.findViewById(R.id.iv_flag);
        this.et_phoneNumber = (EditText)this.findViewById(R.id.et_phoneNumber);
        if (this.iv_flag == null || this.et_phoneNumber == null) {
            throw new IllegalStateException("Please provide a valid xml layout.");
        }
        this.mCountry = Countries.COUNTRIES.get(0);
        this.iv_flag.setImageResource(this.mCountry.getResId(this.getContext()));
        this.iv_flag.setOnClickListener(v -> {
            if (this.activity == null) {
                throw new IllegalStateException("Please, call init first.");
            }
            SearchRecyclerViewDialogFrag.newInstance(new CountryAdapter(Countries.COUNTRIES, this, (Callback<Country>)((Callback)item -> {
                this.mCountry = item;
                this.iv_flag.setImageResource(item.getResId(this.getContext()));
            }))).show(this.activity.getFragmentManager(), SearchRecyclerViewDialogFrag.class.getSimpleName());
        });
    }

    public EditText getEditText() {
        return this.et_phoneNumber;
    }

    public boolean isValid() {
        try {
            return this.mPhoneUtil.isValidNumber(this.parsePhoneNumber(this.getRawInput()));
        }
        catch (NumberParseException e) {
            return false;
        }
    }

    private Phonenumber.PhoneNumber parsePhoneNumber(String number) throws NumberParseException {
        String defaultRegion = this.mCountry != null ? this.mCountry.getCode().toUpperCase() : "";
        return this.mPhoneUtil.parseAndKeepRawInput((CharSequence)number, defaultRegion);
    }

    public String getPhoneNumber() {
        try {
            Phonenumber.PhoneNumber number = this.parsePhoneNumber(this.getRawInput());
            return this.mPhoneUtil.format(number, PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        catch (NumberParseException numberParseException) {
            return this.getRawInput();
        }
    }

    public void setDefaultCountry(String countryCode) {
        for (Country country : Countries.COUNTRIES) {
            if (!country.getCode().equalsIgnoreCase(countryCode)) continue;
            this.mCountry = country;
            this.iv_flag.setImageResource(country.getResId(this.getContext()));
            break;
        }
    }

    private void selectCountry(int dialCode) {
        for (Country country : Countries.COUNTRIES) {
            if (country.getDialCode() != dialCode) continue;
            this.mCountry = country;
            this.iv_flag.setImageResource(country.getResId(this.getContext()));
        }
    }

    public void setPhoneNumber(String rawNumber) {
        try {
            Phonenumber.PhoneNumber number = this.parsePhoneNumber(rawNumber);
            if (this.mCountry == null || this.mCountry.getDialCode() != number.getCountryCode()) {
                this.selectCountry(number.getCountryCode());
            }
            this.et_phoneNumber.setText((CharSequence)this.mPhoneUtil.format(number, PhoneNumberUtil.PhoneNumberFormat.NATIONAL));
        }
        catch (NumberParseException ignored) {
            ignored.printStackTrace();
        }
    }

    private void hideKeyboard() {
        ((InputMethodManager)this.getContext().getSystemService("input_method")).hideSoftInputFromWindow(this.et_phoneNumber.getWindowToken(), 0);
    }

    protected abstract void updateLayoutAttributes();

    public abstract int getLayoutResId();

    public void setHint(int resId) {
        this.et_phoneNumber.setHint(resId);
    }

    public String getRawInput() {
        return this.et_phoneNumber.getText().toString();
    }

    public void setError(String error) {
        this.et_phoneNumber.setError((CharSequence)error);
    }

    public void setTextColor(int resId) {
        this.et_phoneNumber.setTextColor(resId);
    }

    @Override
    public View view() {
        return this;
    }

    @Override
    public Context context() {
        return this.getContext();
    }

    @Override
    public AppCompatActivity activity() {
        return this.activity;
    }
}

