/*
 * Decompiled with CFR 0.152.
 */
package com.sha.kamel.phonefield;

import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import com.sha.kamel.andrutil.Callback;
import com.sha.kamel.phonefield.Country;
import com.sha.kamel.phonefield.R;
import com.sha.kamel.phonefield.shared.ui.adapter.BaseRecyclerAdapter;
import com.sha.kamel.phonefield.shared.ui.adapter.BaseViewHolder;
import com.sha.kamel.phonefield.shared.ui.adapter.RecyclerAdapterCallback;
import com.sha.kamel.phonefield.shared.ui.recyclerviewdialog.SearchRecyclerViewDialogFrag;
import java.util.ArrayList;
import java.util.List;

public class CountryAdapter
extends BaseRecyclerAdapter<Country, Vh>
implements Filterable {
    private List<Country> immutableList = new ArrayList<Country>();
    private Callback<Country> callback;
    private Filter filter = new CustomFilter();

    public CountryAdapter(List<Country> values, RecyclerAdapterCallback recyclerAdapterCallback, Callback<Country> callback) {
        super(values, recyclerAdapterCallback);
        this.immutableList.addAll(values);
        this.callback = callback;
    }

    @Override
    public Vh getViewHolder(ViewGroup viewGroup, int viewType) {
        return new Vh(viewGroup);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public class CustomFilter
    extends Filter {
        private List<Country> filteredList = new ArrayList<Country>();

        protected Filter.FilterResults performFiltering(CharSequence constraint) {
            this.filteredList.clear();
            Filter.FilterResults results = new Filter.FilterResults();
            for (Country item : CountryAdapter.this.immutableList) {
                if (!item.getName(CountryAdapter.this.context()).toLowerCase().contains(constraint.toString().toLowerCase())) continue;
                this.filteredList.add(item);
            }
            results.values = this.filteredList;
            results.count = this.filteredList.size();
            return results;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            CountryAdapter.this.list = this.filteredList;
            CountryAdapter.this.notifyDataSetChanged();
        }
    }

    public class Vh
    extends BaseViewHolder<Country> {
        private TextView tv_countryName;
        private ImageView iv_flag;

        Vh(ViewGroup viewGroup) {
            super(viewGroup, R.layout.viewholder_country);
            this.tv_countryName = (TextView)this.findViewById(R.id.tv_countryName);
            this.iv_flag = (ImageView)this.findViewById(R.id.iv_flag);
            this.itemView.setOnClickListener(v -> {
                CountryAdapter.this.callback.call(this.item);
                ((SearchRecyclerViewDialogFrag)CountryAdapter.this.findFragmentByTag(SearchRecyclerViewDialogFrag.class.getSimpleName())).dismiss();
            });
        }

        @Override
        public void bindView(Country item) {
            this.iv_flag.setImageResource(item.getResId(CountryAdapter.this.context()));
            this.tv_countryName.setText((CharSequence)item.getName(CountryAdapter.this.context()));
        }
    }
}

