/*
 * Decompiled with CFR 0.152.
 */
package com.sha.kamel.phonefield;

import android.content.Context;
import android.content.res.Resources;
import java.util.Locale;

public class Country {
    private String mCode;
    private String nameAr;
    private String nameEn;
    private int mDialCode;

    public Country(String code, String nameEn, String nameAr, int dialCode) {
        this.mCode = code;
        this.nameEn = nameEn;
        this.nameAr = nameAr;
        this.mDialCode = dialCode;
    }

    public String getName(Context context) {
        switch (context.getResources().getConfiguration().locale.getLanguage()) {
            case "ar": {
                return this.nameAr;
            }
        }
        return this.nameEn;
    }

    public String getNameAr() {
        return this.nameAr;
    }

    public String getNameEn() {
        return this.nameEn;
    }

    public String getCode() {
        return this.mCode;
    }

    public int getDialCode() {
        return this.mDialCode;
    }

    public String getDisplayName() {
        return new Locale("", this.mCode).getDisplayCountry(Locale.US);
    }

    public int getResId(Context context) {
        String name = String.format("country_flag_%s", this.mCode.toLowerCase());
        Resources resources = context.getResources();
        return resources.getIdentifier(name, "drawable", context.getPackageName());
    }
}

