/*
 * Decompiled with CFR 0.152.
 */
package com.sergivonavi.materialbanner.internal;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DimenRes;
import androidx.annotation.RestrictTo;
import androidx.core.view.ViewCompat;
import com.google.android.material.button.MaterialButton;
import com.sergivonavi.materialbanner.R;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ButtonsContainer
extends ViewGroup {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private MaterialButton mLeftButton;
    private MaterialButton mRightButton;
    private int mButtonMarginEnd;
    private int mButtonMarginBottom;
    private int mOrientation;

    public ButtonsContainer(Context context) {
        this(context, null);
    }

    public ButtonsContainer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ButtonsContainer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mButtonMarginEnd = this.getDimen(R.dimen.mb_button_margin_end);
        this.mButtonMarginBottom = this.getDimen(R.dimen.mb_button_margin_bottom);
        ViewGroup.MarginLayoutParams layoutParams = new ViewGroup.MarginLayoutParams(-2, -2);
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginEnd(this.mButtonMarginEnd);
        } else {
            layoutParams.rightMargin = this.mButtonMarginEnd;
        }
        layoutParams.bottomMargin = this.mButtonMarginBottom;
        this.mLeftButton = new MaterialButton(context, null, R.attr.borderlessButtonStyle);
        this.mLeftButton.setId(R.id.mb_button_left);
        this.mLeftButton.setSingleLine(true);
        this.mLeftButton.setMaxLines(1);
        this.mLeftButton.setMinWidth(0);
        this.mLeftButton.setMinimumWidth(0);
        this.mLeftButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mLeftButton.setVisibility(8);
        this.mRightButton = new MaterialButton(context, null, R.attr.borderlessButtonStyle);
        this.mRightButton.setId(R.id.mb_button_right);
        this.mRightButton.setSingleLine(true);
        this.mRightButton.setMaxLines(1);
        this.mRightButton.setMinWidth(0);
        this.mRightButton.setMinimumWidth(0);
        this.mRightButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mRightButton.setVisibility(8);
        this.addView((View)this.mLeftButton);
        this.addView((View)this.mRightButton);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthUsed = 0;
        if (this.mLeftButton.getVisibility() != 8) {
            this.measureChildWithMargins((View)this.mLeftButton, widthMeasureSpec, 0, heightMeasureSpec, 0);
            widthUsed += this.mLeftButton.getMeasuredWidth() + this.mButtonMarginEnd;
        }
        if (this.mRightButton.getVisibility() != 8) {
            this.measureChildWithMargins((View)this.mRightButton, widthMeasureSpec, 0, heightMeasureSpec, 0);
            widthUsed += this.mRightButton.getMeasuredWidth() + this.mButtonMarginEnd;
        }
        if (this.mLeftButton.getVisibility() != 8 && this.mRightButton.getVisibility() != 8) {
            this.mOrientation = widthUsed > View.MeasureSpec.getSize((int)widthMeasureSpec) ? 1 : 0;
        }
        if (this.mOrientation == 1) {
            this.measureVertical();
        } else {
            this.measureHorizontal();
        }
    }

    private void measureVertical() {
        int widthUsed = 0;
        int heightUsed = 0;
        if (this.mLeftButton.getVisibility() != 8) {
            widthUsed = this.mLeftButton.getMeasuredWidth() + this.mButtonMarginEnd;
            heightUsed += this.mLeftButton.getMeasuredHeight() + this.mButtonMarginBottom;
        }
        if (this.mRightButton.getVisibility() != 8) {
            widthUsed = Math.max(widthUsed, this.mRightButton.getMeasuredWidth() + this.mButtonMarginEnd);
            heightUsed += this.mRightButton.getMeasuredHeight() + this.mButtonMarginBottom;
        }
        this.setMeasuredDimension(widthUsed, heightUsed);
    }

    private void measureHorizontal() {
        int widthUsed = 0;
        int heightUsed = 0;
        if (this.mLeftButton.getVisibility() != 8) {
            widthUsed += this.mLeftButton.getMeasuredWidth() + this.mButtonMarginEnd;
            heightUsed = this.mLeftButton.getMeasuredHeight() + this.mButtonMarginBottom;
        }
        if (this.mRightButton.getVisibility() != 8) {
            widthUsed += this.mRightButton.getMeasuredWidth() + this.mButtonMarginEnd;
            heightUsed = Math.max(heightUsed, this.mRightButton.getMeasuredHeight() + this.mButtonMarginBottom);
        }
        this.setMeasuredDimension(widthUsed, heightUsed);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mOrientation == 1) {
            this.layoutVertical();
        } else {
            this.layoutHorizontal();
        }
    }

    private void layoutVertical() {
        int top = 0;
        int lBtnRight = this.getMeasuredWidth() - this.mButtonMarginEnd;
        int lBtnLeft = lBtnRight - this.mLeftButton.getMeasuredWidth();
        int rBtnRight = this.getMeasuredWidth() - this.mButtonMarginEnd;
        int rBtnLeft = rBtnRight - this.mRightButton.getMeasuredWidth();
        if (ViewCompat.getLayoutDirection((View)this) == 1) {
            lBtnLeft = this.mButtonMarginEnd;
            lBtnRight = lBtnLeft + this.mLeftButton.getMeasuredWidth();
            rBtnLeft = this.mButtonMarginEnd;
            rBtnRight = rBtnLeft + this.mRightButton.getMeasuredWidth();
        }
        if (this.mRightButton.getVisibility() != 8) {
            this.mRightButton.layout(rBtnLeft, top, rBtnRight, this.mRightButton.getMeasuredHeight());
            top += this.mRightButton.getMeasuredHeight() + this.mButtonMarginBottom;
        }
        if (this.mLeftButton.getVisibility() != 8) {
            this.mLeftButton.layout(lBtnLeft, top, lBtnRight, top + this.mLeftButton.getMeasuredHeight());
        }
    }

    private void layoutHorizontal() {
        int lBtnRight = this.mLeftButton.getMeasuredWidth();
        int lBtnLeft = 0;
        int rBtnRight = this.getMeasuredWidth() - this.mButtonMarginEnd;
        int rBtnLeft = rBtnRight - this.mRightButton.getMeasuredWidth();
        if (ViewCompat.getLayoutDirection((View)this) == 1) {
            rBtnLeft = this.mButtonMarginEnd;
            rBtnRight = rBtnLeft + this.mRightButton.getMeasuredWidth();
            lBtnRight = this.getMeasuredWidth();
            lBtnLeft = lBtnRight - this.mLeftButton.getMeasuredWidth();
        }
        if (this.mLeftButton.getVisibility() != 8) {
            this.mLeftButton.layout(lBtnLeft, 0, lBtnRight, this.mLeftButton.getMeasuredHeight());
        }
        if (this.mRightButton.getVisibility() != 8) {
            this.mRightButton.layout(rBtnLeft, 0, rBtnRight, this.mRightButton.getMeasuredHeight());
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }

    public int getBaseline() {
        if (this.mLeftButton.getVisibility() != 8 && this.mLeftButton.getText() != null) {
            return this.mLeftButton.getBaseline();
        }
        if (this.mRightButton.getVisibility() != 8 && this.mRightButton.getText() != null) {
            return this.mRightButton.getBaseline();
        }
        return -1;
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            this.requestLayout();
        }
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public MaterialButton getLeftButton() {
        return this.mLeftButton;
    }

    public MaterialButton getRightButton() {
        return this.mRightButton;
    }

    private int getDimen(@DimenRes int dimenId) {
        return this.getContext().getResources().getDimensionPixelSize(dimenId);
    }
}

