/*
 * Decompiled with CFR 0.152.
 */
package com.sergivonavi.materialbanner;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Property;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.core.widget.ImageViewCompat;
import com.google.android.material.button.MaterialButton;
import com.sergivonavi.materialbanner.BannerInterface;
import com.sergivonavi.materialbanner.R;
import com.sergivonavi.materialbanner.internal.ButtonsContainer;
import com.sergivonavi.materialbanner.internal.MessageView;

public class Banner
extends ViewGroup
implements BannerInterface {
    private static final boolean DEBUG = false;
    private static final int LAYOUT_UNDEFINED = -1;
    private static final int LAYOUT_SINGLE_LINE = 0;
    private static final int LAYOUT_MULTILINE = 1;
    private RelativeLayout mContentContainer;
    private AppCompatImageView mIconView;
    private MessageView mMessageView;
    private ButtonsContainer mButtonsContainer;
    private MaterialButton mLeftButton;
    private MaterialButton mRightButton;
    private View mLine;
    private Drawable mIcon;
    private String mMessageText;
    private String mLeftButtonText;
    private String mRightButtonText;
    private int mContainerPaddingTopOneLine;
    private int mContainerPaddingTopMultiline;
    private int mIconSize;
    private int mIconMarginStart;
    private int mMessageMarginStart;
    private int mMessageMarginEndSingleLine;
    private int mMessageMarginEndMultiline;
    private int mMessageMarginBottomMultiline;
    private int mMessageMarginBottomWithIcon;
    private int mButtonMarginEnd;
    private int mButtonMarginBottom;
    private int mLineHeight;
    private int mMarginBottom;
    private boolean mWideLayout;
    private int mLayoutType = -1;
    private static final int ANIM_DURATION_DISMISS = 160;
    private static final int ANIM_DURATION_SHOW = 180;
    private boolean mIsAnimating;
    private BannerInterface.OnClickListener mLeftButtonListener;
    private BannerInterface.OnClickListener mRightButtonListener;
    private BannerInterface.OnDismissListener mOnDismissListener;
    private BannerInterface.OnShowListener mOnShowListener;
    private AnimatorListenerAdapter mAnimatorListener = new AnimatorListenerAdapter(){

        public void onAnimationStart(final Animator animation) {
            Banner.this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Banner.this.mIsAnimating = true;
                    if (animation.getDuration() == 180L) {
                        Banner.this.setVisibility(0);
                    }
                }
            }, animation.getStartDelay());
        }

        public void onAnimationEnd(Animator animation) {
            Banner.this.mIsAnimating = false;
            if (animation.getDuration() == 160L) {
                Banner.this.setVisibility(8);
                ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)Banner.this.getLayoutParams();
                layoutParams.bottomMargin = Banner.this.mMarginBottom;
                Banner.this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                Banner.this.setTranslationY(0.0f);
            }
            if (Banner.this.isShown()) {
                Banner.this.dispatchOnShow();
            } else {
                Banner.this.dispatchOnDismiss();
            }
        }
    };

    public Banner(Context context) {
        this(context, null);
    }

    public Banner(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.bannerStyle);
    }

    public Banner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.loadDimens(context);
        this.initViewGroup(context);
        this.retrieveAttrs(context, attrs, defStyleAttr);
    }

    private void loadDimens(Context context) {
        this.mWideLayout = context.getResources().getBoolean(R.bool.mb_wide_layout);
        this.mIconSize = this.getDimen(R.dimen.mb_icon_size);
        this.mIconMarginStart = this.getDimen(R.dimen.mb_icon_margin_start);
        this.mMessageMarginStart = this.getDimen(R.dimen.mb_message_margin_start);
        this.mMessageMarginEndSingleLine = this.getDimen(R.dimen.mb_message_margin_end_singleline);
        this.mMessageMarginEndMultiline = this.getDimen(R.dimen.mb_message_margin_end_multiline);
        this.mMessageMarginBottomMultiline = this.getDimen(R.dimen.mb_message_margin_bottom_multiline);
        this.mMessageMarginBottomWithIcon = this.getDimen(R.dimen.mb_message_margin_bottom_with_icon);
        this.mButtonMarginEnd = this.getDimen(R.dimen.mb_button_margin_end);
        this.mButtonMarginBottom = this.getDimen(R.dimen.mb_button_margin_bottom);
        this.mLineHeight = this.getDimen(R.dimen.mb_line_height);
        this.mContainerPaddingTopOneLine = this.getDimen(R.dimen.mb_container_padding_top_singleline);
        this.mContainerPaddingTopMultiline = this.getDimen(R.dimen.mb_container_padding_top_multiline);
    }

    private void initViewGroup(Context context) {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -2);
        this.mContentContainer = new RelativeLayout(context);
        this.mContentContainer.setId(R.id.mb_container_content);
        this.mContentContainer.setLayoutParams(layoutParams);
        RelativeLayout.LayoutParams relativeLayoutParams = new RelativeLayout.LayoutParams(this.mIconSize, this.mIconSize);
        if (Build.VERSION.SDK_INT >= 17) {
            relativeLayoutParams.setMarginStart(this.mIconMarginStart);
            relativeLayoutParams.addRule(20, -1);
        } else {
            relativeLayoutParams.leftMargin = this.mIconMarginStart;
            relativeLayoutParams.addRule(9, -1);
        }
        this.mIconView = new AppCompatImageView(context);
        this.mIconView.setId(R.id.mb_icon);
        this.mIconView.setLayoutParams((ViewGroup.LayoutParams)relativeLayoutParams);
        this.mIconView.setVisibility(8);
        relativeLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (Build.VERSION.SDK_INT >= 17) {
            relativeLayoutParams.setMarginStart(this.mMessageMarginStart);
            relativeLayoutParams.addRule(20, -1);
        } else {
            relativeLayoutParams.leftMargin = this.mMessageMarginStart;
            relativeLayoutParams.addRule(9, -1);
        }
        this.mMessageView = new MessageView(context);
        this.mMessageView.setId(R.id.mb_message);
        this.mMessageView.setLayoutParams((ViewGroup.LayoutParams)relativeLayoutParams);
        relativeLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (Build.VERSION.SDK_INT >= 17) {
            relativeLayoutParams.addRule(21, -1);
        } else {
            relativeLayoutParams.addRule(11, -1);
        }
        this.mButtonsContainer = new ButtonsContainer(context);
        this.mButtonsContainer.setId(R.id.mb_container_buttons);
        this.mButtonsContainer.setOrientation(0);
        this.mButtonsContainer.setBaselineAligned(false);
        this.mButtonsContainer.setLayoutParams((ViewGroup.LayoutParams)relativeLayoutParams);
        LinearLayout.LayoutParams linearLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        linearLayoutParams.weight = 1.0f;
        if (Build.VERSION.SDK_INT >= 17) {
            linearLayoutParams.setMarginEnd(this.mButtonMarginEnd);
        } else {
            linearLayoutParams.rightMargin = this.mButtonMarginEnd;
        }
        linearLayoutParams.bottomMargin = this.mButtonMarginBottom;
        this.mLeftButton = new MaterialButton(context, null, R.attr.borderlessButtonStyle);
        this.mLeftButton.setId(R.id.mb_button_left);
        this.mLeftButton.setSingleLine(true);
        this.mLeftButton.setMaxLines(1);
        this.mLeftButton.setMinWidth(0);
        this.mLeftButton.setMinimumWidth(0);
        this.mLeftButton.setLayoutParams((ViewGroup.LayoutParams)linearLayoutParams);
        this.mLeftButton.setVisibility(8);
        this.mRightButton = new MaterialButton(context, null, R.attr.borderlessButtonStyle);
        this.mRightButton.setId(R.id.mb_button_right);
        this.mRightButton.setSingleLine(true);
        this.mRightButton.setMaxLines(1);
        this.mRightButton.setMinWidth(0);
        this.mRightButton.setMinimumWidth(0);
        this.mRightButton.setLayoutParams((ViewGroup.LayoutParams)linearLayoutParams);
        this.mRightButton.setVisibility(8);
        layoutParams = new ViewGroup.LayoutParams(-1, this.mLineHeight);
        this.mLine = new View(context);
        this.mLine.setId(R.id.mb_line);
        this.mLine.setLayoutParams(layoutParams);
        this.addView((View)this.mContentContainer);
        this.addView(this.mLine);
        this.mButtonsContainer.addView((View)this.mLeftButton, 0);
        this.mButtonsContainer.addView((View)this.mRightButton, 1);
        this.mContentContainer.addView((View)this.mIconView);
        this.mContentContainer.addView((View)this.mMessageView);
        this.mContentContainer.addView((View)this.mButtonsContainer);
    }

    private void retrieveAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Banner, defStyleAttr, R.style.Widget_Material_Banner);
        if (a.hasValue(R.styleable.Banner_icon)) {
            this.setIcon(a.getDrawable(R.styleable.Banner_icon));
        }
        if (a.hasValue(R.styleable.Banner_iconTint)) {
            this.setIconTintColorInternal(a.getColor(R.styleable.Banner_iconTint, -16777216));
        }
        if (a.hasValue(R.styleable.Banner_messageText)) {
            this.setMessage(a.getString(R.styleable.Banner_messageText));
        }
        if (a.hasValue(R.styleable.Banner_buttonLeftText)) {
            this.setLeftButton(a.getString(R.styleable.Banner_buttonLeftText), null);
        }
        if (a.hasValue(R.styleable.Banner_buttonRightText)) {
            this.setRightButton(a.getString(R.styleable.Banner_buttonRightText), null);
        }
        if (a.hasValue(R.styleable.Banner_messageTextAppearance)) {
            this.mMessageView.setTextAppearance(context, a.getResourceId(R.styleable.Banner_messageTextAppearance, R.style.TextAppearance_Banner_Message));
        }
        if (a.hasValue(R.styleable.Banner_buttonsTextAppearance)) {
            int textAppearance = a.getResourceId(R.styleable.Banner_buttonsTextAppearance, R.style.TextAppearance_Banner_Button);
            this.mLeftButton.setTextAppearance(context, textAppearance);
            this.mRightButton.setTextAppearance(context, textAppearance);
        }
        if (a.hasValue(R.styleable.Banner_messageTextColor)) {
            this.mMessageView.setTextColor(a.getColor(R.styleable.Banner_messageTextColor, -16777216));
        }
        if (a.hasValue(R.styleable.Banner_buttonsTextColor)) {
            this.mLeftButton.setTextColor(a.getColor(R.styleable.Banner_buttonsTextColor, -16777216));
            this.mRightButton.setTextColor(a.getColor(R.styleable.Banner_buttonsTextColor, -16777216));
        }
        if (a.hasValue(R.styleable.Banner_buttonsRippleColor)) {
            this.mLeftButton.setRippleColor(ColorStateList.valueOf((int)a.getColor(R.styleable.Banner_buttonsRippleColor, -16777216)));
            this.mRightButton.setRippleColor(ColorStateList.valueOf((int)a.getColor(R.styleable.Banner_buttonsRippleColor, -16777216)));
        }
        if (a.hasValue(R.styleable.Banner_backgroundColor)) {
            this.setBackgroundColor(a.getColor(R.styleable.Banner_backgroundColor, 0));
        }
        if (a.hasValue(R.styleable.Banner_lineColor)) {
            this.mLine.setBackgroundColor(a.getColor(R.styleable.Banner_lineColor, -16777216));
        }
        if (a.hasValue(R.styleable.Banner_lineOpacity)) {
            this.mLine.setAlpha(a.getFloat(R.styleable.Banner_lineOpacity, 0.12f));
        }
        int contentPaddingStart = a.getDimensionPixelSize(R.styleable.Banner_contentPaddingStart, 0);
        int contentPaddingEnd = a.getDimensionPixelSize(R.styleable.Banner_contentPaddingEnd, 0);
        this.setContainerPadding(contentPaddingStart, -1, contentPaddingEnd);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthUsed = this.getContainerHorizontalPadding();
        int heightUsed = 0;
        this.measureChild((View)this.mMessageView, widthMeasureSpec, heightMeasureSpec);
        int messageViewWidth = this.mMessageView.getMeasuredWidth() + this.mMessageMarginStart + this.mMessageMarginEndMultiline;
        int iconViewWidth = 0;
        if (this.mIcon != null) {
            this.measureChild((View)this.mIconView, widthMeasureSpec, heightMeasureSpec);
            iconViewWidth = this.mIconView.getMeasuredWidth() + this.mIconMarginStart;
        }
        this.measureChild((View)this.mButtonsContainer, widthMeasureSpec, heightMeasureSpec);
        int buttonsWidth = this.mButtonsContainer.getMeasuredWidth();
        if (widthSpecSize - widthUsed - iconViewWidth - buttonsWidth >= messageViewWidth) {
            this.onSingleLine();
        } else {
            this.onMultiline();
        }
        this.measureChild((View)this.mContentContainer, widthMeasureSpec, heightMeasureSpec);
        this.measureChild(this.mLine, widthMeasureSpec, heightMeasureSpec);
        widthUsed = this.mContentContainer.getMeasuredWidth();
        heightUsed = this.mContentContainer.getMeasuredHeight() + this.mLine.getMeasuredHeight();
        this.setMeasuredDimension(widthUsed, heightUsed);
    }

    private void onSingleLine() {
        if (this.mLayoutType == 0) {
            return;
        }
        this.setContainerPadding(-1, this.mContainerPaddingTopOneLine, -1);
        RelativeLayout.LayoutParams messageLayoutParams = (RelativeLayout.LayoutParams)this.mMessageView.getLayoutParams();
        RelativeLayout.LayoutParams buttonsContainerLayoutParams = (RelativeLayout.LayoutParams)this.mButtonsContainer.getLayoutParams();
        if (Build.VERSION.SDK_INT >= 17) {
            messageLayoutParams.addRule(16, this.mButtonsContainer.getId());
            messageLayoutParams.setMarginEnd(this.mMessageMarginEndSingleLine);
        } else {
            messageLayoutParams.addRule(0, this.mButtonsContainer.getId());
            messageLayoutParams.rightMargin = this.mMessageMarginEndSingleLine;
        }
        messageLayoutParams.addRule(4, this.mButtonsContainer.getId());
        messageLayoutParams.bottomMargin = 0;
        this.mMessageView.setLayoutParams((ViewGroup.LayoutParams)messageLayoutParams);
        buttonsContainerLayoutParams.addRule(4, 0);
        buttonsContainerLayoutParams.addRule(3, 0);
        this.mButtonsContainer.setLayoutParams((ViewGroup.LayoutParams)buttonsContainerLayoutParams);
        this.mLayoutType = 0;
    }

    private void onMultiline() {
        if (this.mLayoutType == 1) {
            return;
        }
        this.setContainerPadding(-1, this.mContainerPaddingTopMultiline, -1);
        RelativeLayout.LayoutParams messageLayoutParams = (RelativeLayout.LayoutParams)this.mMessageView.getLayoutParams();
        RelativeLayout.LayoutParams buttonsContainerLayoutParams = (RelativeLayout.LayoutParams)this.mButtonsContainer.getLayoutParams();
        if (this.mWideLayout) {
            if (Build.VERSION.SDK_INT >= 17) {
                messageLayoutParams.addRule(16, this.mButtonsContainer.getId());
            } else {
                messageLayoutParams.addRule(0, this.mButtonsContainer.getId());
            }
            buttonsContainerLayoutParams.addRule(4, this.mMessageView.getId());
        } else {
            if (Build.VERSION.SDK_INT >= 17) {
                messageLayoutParams.addRule(16, 0);
            } else {
                messageLayoutParams.addRule(0, 0);
            }
            messageLayoutParams.bottomMargin = this.mIcon == null ? this.mMessageMarginBottomMultiline : this.mMessageMarginBottomWithIcon;
            buttonsContainerLayoutParams.addRule(3, this.mMessageView.getId());
        }
        if (Build.VERSION.SDK_INT >= 17) {
            messageLayoutParams.setMarginEnd(this.mMessageMarginEndMultiline);
        } else {
            messageLayoutParams.rightMargin = this.mMessageMarginEndMultiline;
        }
        messageLayoutParams.addRule(4, 0);
        this.mMessageView.setLayoutParams((ViewGroup.LayoutParams)messageLayoutParams);
        this.mButtonsContainer.setLayoutParams((ViewGroup.LayoutParams)buttonsContainerLayoutParams);
        this.mLayoutType = 1;
    }

    private void updateParamsOnIconChanged() {
        int toEndOfId;
        RelativeLayout.LayoutParams messageLayoutParams = (RelativeLayout.LayoutParams)this.mMessageView.getLayoutParams();
        int parentStart = this.mIcon == null ? -1 : 0;
        int n = toEndOfId = this.mIcon == null ? 0 : this.mIconView.getId();
        if (Build.VERSION.SDK_INT >= 17) {
            messageLayoutParams.addRule(20, parentStart);
            messageLayoutParams.addRule(17, toEndOfId);
        } else {
            messageLayoutParams.addRule(9, parentStart);
            messageLayoutParams.addRule(1, toEndOfId);
        }
        this.mMessageView.setLayoutParams((ViewGroup.LayoutParams)messageLayoutParams);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int y = this.mContentContainer.getMeasuredHeight();
        this.mContentContainer.layout(0, 0, this.mContentContainer.getMeasuredWidth(), y);
        this.mLine.layout(0, y, this.mLine.getMeasuredWidth(), y + this.mLine.getMeasuredHeight());
    }

    public void setIcon(@Nullable Drawable icon) {
        this.mIcon = icon;
        if (this.mIcon != null) {
            this.mIconView.setVisibility(0);
            this.mIconView.setImageDrawable(icon);
        } else {
            this.mIconView.setVisibility(8);
        }
        this.updateParamsOnIconChanged();
    }

    public void setIcon(@DrawableRes int iconId) {
        this.setIcon(ContextCompat.getDrawable((Context)this.getContext(), (int)iconId));
    }

    public void setMessage(String text) {
        this.mMessageText = text;
        this.mMessageView.setText(text);
    }

    public void setMessage(@StringRes int textId) {
        this.setMessage(this.getContext().getString(textId));
    }

    public void setLeftButton(String text, @Nullable BannerInterface.OnClickListener listener) {
        this.mLeftButtonText = text;
        if (this.mLeftButtonText != null) {
            this.mLeftButton.setVisibility(0);
            this.mLeftButton.setText((CharSequence)text);
            this.setLeftButtonListener(listener);
        } else {
            this.mLeftButton.setVisibility(8);
        }
    }

    public void setLeftButton(@StringRes int textId, @Nullable BannerInterface.OnClickListener listener) {
        this.setLeftButton(this.getContext().getString(textId), listener);
    }

    public void setLeftButtonListener(@Nullable BannerInterface.OnClickListener listener) {
        this.mLeftButtonListener = listener;
        this.mLeftButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (Banner.this.mLeftButtonListener != null) {
                    Banner.this.mLeftButtonListener.onClick(Banner.this);
                }
            }
        });
    }

    public void setRightButton(String text, @Nullable BannerInterface.OnClickListener listener) {
        this.mRightButtonText = text;
        if (this.mRightButtonText != null) {
            this.mRightButton.setVisibility(0);
            this.mRightButton.setText((CharSequence)text);
            this.setRightButtonListener(listener);
        } else {
            this.mRightButton.setVisibility(8);
        }
    }

    public void setRightButton(@StringRes int textId, @Nullable BannerInterface.OnClickListener listener) {
        this.setRightButton(this.getContext().getString(textId), listener);
    }

    public void setRightButtonListener(@Nullable BannerInterface.OnClickListener listener) {
        this.mRightButtonListener = listener;
        this.mRightButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (Banner.this.mRightButtonListener != null) {
                    Banner.this.mRightButtonListener.onClick(Banner.this);
                }
            }
        });
    }

    public void setOnDismissListener(@Nullable BannerInterface.OnDismissListener listener) {
        this.mOnDismissListener = listener;
    }

    public void setOnShowListener(@Nullable BannerInterface.OnShowListener listener) {
        this.mOnShowListener = listener;
    }

    public void setIconTintColor(@ColorRes int colorId) {
        this.setIconTintColorInternal(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
    }

    private void setIconTintColorInternal(@ColorInt int color) {
        ImageViewCompat.setImageTintList((ImageView)this.mIconView, (ColorStateList)ColorStateList.valueOf((int)color));
    }

    public void setMessageTextColor(@ColorRes int colorId) {
        this.mMessageView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
    }

    public void setButtonsTextColor(@ColorRes int colorId) {
        this.mLeftButton.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
        this.mRightButton.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
    }

    public void setButtonsRippleColor(@ColorRes int colorId) {
        this.mLeftButton.setRippleColorResource(colorId);
        this.mRightButton.setRippleColorResource(colorId);
    }

    public void setLineColor(@ColorRes int colorId) {
        this.mLine.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
    }

    public void setLineOpacity(@FloatRange(from=0.0, to=1.0) float lineOpacity) {
        this.mLine.setAlpha(lineOpacity);
    }

    public void setContentPaddingStart(@DimenRes int dimenId) {
        this.setContentPaddingStartPx(this.getDimen(dimenId));
    }

    public void setContentPaddingStartPx(@Dimension int dimenPx) {
        this.setContainerPadding(dimenPx, -1, -1);
    }

    public void setContentPaddingEnd(@DimenRes int dimenId) {
        this.setContentPaddingEndPx(this.getDimen(dimenId));
    }

    public void setContentPaddingEndPx(@Dimension int dimenPx) {
        this.setContainerPadding(-1, -1, dimenPx);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
    }

    public void setBannerVisibility(int visibility) {
        if (visibility == 0) {
            this.dispatchOnShow();
        } else if (visibility == 8) {
            this.dispatchOnDismiss();
        }
        this.setVisibility(visibility);
    }

    public void show() {
        this.show(0L);
    }

    public void show(long delay) {
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)((ViewGroup)this.getParent()).getWidth(), (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.measure(widthSpec, heightSpec);
        int fromY = -this.getMeasuredHeight();
        final ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
        this.mMarginBottom = layoutParams.bottomMargin;
        ObjectAnimator bannerAnimator = ObjectAnimator.ofFloat((Object)this, (Property)View.TRANSLATION_Y, (float[])new float[]{fromY, 0.0f});
        layoutParams.bottomMargin = fromY;
        ValueAnimator marginAnimator = ValueAnimator.ofInt((int[])new int[]{layoutParams.bottomMargin, this.mMarginBottom});
        marginAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                layoutParams.bottomMargin = (Integer)valueAnimator.getAnimatedValue();
                Banner.this.requestLayout();
            }
        });
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{bannerAnimator, marginAnimator});
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animatorSet.setStartDelay(delay);
        animatorSet.setDuration(180L);
        animatorSet.addListener((Animator.AnimatorListener)this.mAnimatorListener);
        animatorSet.start();
    }

    @Override
    public void dismiss() {
        this.dismiss(0L);
    }

    @Override
    public void dismiss(long delay) {
        int toY = -this.getMeasuredHeight();
        final ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
        this.mMarginBottom = layoutParams.bottomMargin;
        ObjectAnimator bannerAnimator = ObjectAnimator.ofFloat((Object)this, (Property)View.TRANSLATION_Y, (float[])new float[]{0.0f, toY});
        ValueAnimator marginAnimator = ValueAnimator.ofInt((int[])new int[]{layoutParams.bottomMargin, toY});
        marginAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                layoutParams.bottomMargin = (Integer)valueAnimator.getAnimatedValue();
                Banner.this.requestLayout();
            }
        });
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{bannerAnimator, marginAnimator});
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animatorSet.setStartDelay(delay);
        animatorSet.setDuration(160L);
        animatorSet.addListener((Animator.AnimatorListener)this.mAnimatorListener);
        animatorSet.start();
    }

    private void dispatchOnShow() {
        if (this.mOnShowListener != null) {
            this.mOnShowListener.onShow();
        }
    }

    private void dispatchOnDismiss() {
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss();
        }
    }

    private int getContainerHorizontalPadding() {
        if (Build.VERSION.SDK_INT >= 17) {
            return this.mContentContainer.getPaddingStart() + this.mContentContainer.getPaddingEnd();
        }
        return this.mContentContainer.getPaddingLeft() + this.mContentContainer.getPaddingRight();
    }

    private void setContainerPadding(int start, int top, int end) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.mContentContainer.setPaddingRelative(start != -1 ? start : this.mContentContainer.getPaddingStart(), top != -1 ? top : this.mContentContainer.getPaddingTop(), end != -1 ? end : this.mContentContainer.getPaddingEnd(), 0);
        } else {
            this.mContentContainer.setPadding(start != -1 ? start : this.mContentContainer.getPaddingLeft(), top != -1 ? top : this.mContentContainer.getPaddingTop(), end != -1 ? end : this.mContentContainer.getPaddingRight(), 0);
        }
    }

    private int getDimen(@DimenRes int dimenRes) {
        return this.getContext().getResources().getDimensionPixelSize(dimenRes);
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.visibility = this.getVisibility();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setVisibility(ss.visibility);
    }

    public static class Builder {
        private Context mContext;
        private ViewGroup mParent;
        private int mChildIndex;
        private ViewGroup.LayoutParams mParams;
        @IdRes
        private int mId;
        private Drawable mIcon;
        private String mMessageText;
        private String mLeftBtnText;
        private String mRightBtnText;
        private BannerInterface.OnClickListener mLeftBtnListener;
        private BannerInterface.OnClickListener mRightBtnListener;
        private BannerInterface.OnDismissListener mOnDismissListener;
        private BannerInterface.OnShowListener mOnShowListener;

        public Builder(@NonNull Context context) {
            this.mContext = context;
        }

        public Builder(@NonNull Context context, @StyleRes int themeResId) {
            this((Context)new ContextThemeWrapper(context, themeResId));
        }

        public Builder setParent(@NonNull ViewGroup parent) {
            this.setParent(parent, 0);
            return this;
        }

        public Builder setParent(@NonNull ViewGroup parent, int index) {
            this.setParent(parent, index, new ViewGroup.LayoutParams(-1, -2));
            return this;
        }

        public Builder setParent(@NonNull ViewGroup parent, int index, ViewGroup.LayoutParams params) {
            this.mParent = parent;
            this.mChildIndex = index;
            this.mParams = params;
            return this;
        }

        public Builder setId(@IdRes int id2) {
            this.mId = id2;
            return this;
        }

        public Builder setIcon(@DrawableRes int iconId) {
            this.mIcon = ContextCompat.getDrawable((Context)this.mContext, (int)iconId);
            return this;
        }

        public Builder setIcon(@Nullable Drawable icon) {
            this.mIcon = icon;
            return this;
        }

        public Builder setMessage(@StringRes int textId) {
            this.mMessageText = this.mContext.getString(textId);
            return this;
        }

        public Builder setMessage(@NonNull String text) {
            this.mMessageText = text;
            return this;
        }

        public Builder setLeftButton(@StringRes int textId, @Nullable BannerInterface.OnClickListener listener) {
            this.setLeftButton(this.mContext.getString(textId), listener);
            return this;
        }

        public Builder setLeftButton(@NonNull String text, @Nullable BannerInterface.OnClickListener listener) {
            this.mLeftBtnText = text;
            this.mLeftBtnListener = listener;
            return this;
        }

        public Builder setRightButton(@StringRes int textId, @Nullable BannerInterface.OnClickListener listener) {
            this.setRightButton(this.mContext.getString(textId), listener);
            return this;
        }

        public Builder setRightButton(@NonNull String text, @Nullable BannerInterface.OnClickListener listener) {
            this.mRightBtnText = text;
            this.mRightBtnListener = listener;
            return this;
        }

        public Builder setOnDismissListener(@Nullable BannerInterface.OnDismissListener listener) {
            this.mOnDismissListener = listener;
            return this;
        }

        public Builder setOnShowListener(@Nullable BannerInterface.OnShowListener listener) {
            this.mOnShowListener = listener;
            return this;
        }

        @NonNull
        public Banner create() {
            if (this.mParent == null) {
                throw new NullPointerException("The parent view must not be null! Call Banner.Builder#setParent() to set the parent view.");
            }
            Banner banner = new Banner(this.mContext);
            banner.setId(this.mId != 0 ? this.mId : R.id.mb_banner);
            banner.setIcon(this.mIcon);
            banner.setMessage(this.mMessageText);
            banner.setLeftButton(this.mLeftBtnText, this.mLeftBtnListener);
            banner.setRightButton(this.mRightBtnText, this.mRightBtnListener);
            banner.setOnDismissListener(this.mOnDismissListener);
            banner.setOnShowListener(this.mOnShowListener);
            banner.setLayoutParams(this.mParams);
            banner.setVisibility(8);
            this.mParent.addView((View)banner, this.mChildIndex);
            return banner;
        }

        public Banner show() {
            Banner banner = this.create();
            banner.show();
            return banner;
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        int visibility;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.visibility = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.visibility);
        }
    }
}

