/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usbcameracommon;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.hardware.usb.UsbDevice;
import android.media.MediaScannerConnection;
import android.media.SoundPool;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.serenegiant.encoder.MediaAudioEncoder;
import com.serenegiant.encoder.MediaEncoder;
import com.serenegiant.encoder.MediaMuxerWrapper;
import com.serenegiant.encoder.MediaSurfaceEncoder;
import com.serenegiant.encoder.MediaVideoBufferEncoder;
import com.serenegiant.encoder.MediaVideoEncoder;
import com.serenegiant.usb.IFrameCallback;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UVCCamera;
import com.serenegiant.usbcameracommon.R;
import com.serenegiant.widget.CameraViewInterface;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

abstract class AbstractUVCCameraHandler
extends Handler {
    private static final boolean DEBUG = true;
    private static final String TAG = "AbsUVCCameraHandler";
    private static final int MSG_OPEN = 0;
    private static final int MSG_CLOSE = 1;
    private static final int MSG_PREVIEW_START = 2;
    private static final int MSG_PREVIEW_STOP = 3;
    private static final int MSG_CAPTURE_STILL = 4;
    private static final int MSG_CAPTURE_START = 5;
    private static final int MSG_CAPTURE_STOP = 6;
    private static final int MSG_MEDIA_UPDATE = 7;
    private static final int MSG_RELEASE = 9;
    private final WeakReference<CameraThread> mWeakThread;
    private volatile boolean mReleased;

    protected AbstractUVCCameraHandler(CameraThread thread) {
        this.mWeakThread = new WeakReference<CameraThread>(thread);
    }

    public int getWidth() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null ? thread.getWidth() : 0;
    }

    public int getHeight() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null ? thread.getHeight() : 0;
    }

    public boolean isOpened() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null && thread.isCameraOpened();
    }

    public boolean isPreviewing() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null && thread.isPreviewing();
    }

    public boolean isRecording() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null && thread.isRecording();
    }

    public boolean isEqual(UsbDevice device) {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null && thread.isEqual(device);
    }

    protected boolean isCameraThread() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null && thread.getId() == Thread.currentThread().getId();
    }

    protected boolean isReleased() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return this.mReleased || thread == null;
    }

    protected void checkReleased() {
        if (this.isReleased()) {
            throw new IllegalStateException("already released");
        }
    }

    public void open(USBMonitor.UsbControlBlock ctrlBlock) {
        this.checkReleased();
        this.sendMessage(this.obtainMessage(0, ctrlBlock));
    }

    public void close() {
        Log.v((String)TAG, (String)"close:");
        if (this.isOpened()) {
            this.stopPreview();
            this.sendEmptyMessage(1);
        }
        Log.v((String)TAG, (String)"close:finished");
    }

    public void resize(int width, int height) {
        this.checkReleased();
        throw new UnsupportedOperationException("does not support now");
    }

    protected void startPreview(Object surface) {
        this.checkReleased();
        if (!(surface instanceof SurfaceHolder || surface instanceof Surface || surface instanceof SurfaceTexture)) {
            throw new IllegalArgumentException("surface should be one of SurfaceHolder, Surface or SurfaceTexture");
        }
        this.sendMessage(this.obtainMessage(2, surface));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPreview() {
        Log.v((String)TAG, (String)"stopPreview:");
        this.removeMessages(2);
        this.stopRecording();
        if (this.isPreviewing()) {
            CameraThread thread = (CameraThread)this.mWeakThread.get();
            if (thread == null) {
                return;
            }
            Object object = thread.mSync;
            synchronized (object) {
                this.sendEmptyMessage(3);
                if (!this.isCameraThread()) {
                    try {
                        thread.mSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        Log.v((String)TAG, (String)"stopPreview:finished");
    }

    protected void captureStill() {
        this.checkReleased();
        this.sendEmptyMessage(4);
    }

    protected void captureStill(String path) {
        this.checkReleased();
        this.sendMessage(this.obtainMessage(4, path));
    }

    public void startRecording() {
        this.checkReleased();
        this.sendEmptyMessage(5);
    }

    public void stopRecording() {
        this.sendEmptyMessage(6);
    }

    public void release() {
        this.mReleased = true;
        this.close();
        this.sendEmptyMessage(9);
    }

    public void addCallback(CameraCallback callback) {
        CameraThread thread;
        this.checkReleased();
        if (!this.mReleased && callback != null && (thread = (CameraThread)this.mWeakThread.get()) != null) {
            thread.mCallbacks.add(callback);
        }
    }

    public void removeCallback(CameraCallback callback) {
        CameraThread thread;
        if (callback != null && (thread = (CameraThread)this.mWeakThread.get()) != null) {
            thread.mCallbacks.remove(callback);
        }
    }

    protected void updateMedia(String path) {
        this.sendMessage(this.obtainMessage(7, path));
    }

    public boolean checkSupportFlag(long flag) {
        this.checkReleased();
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null && thread.mUVCCamera != null && thread.mUVCCamera.checkSupportFlag(flag);
    }

    public int getValue(int flag) {
        UVCCamera camera;
        this.checkReleased();
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        UVCCamera uVCCamera = camera = thread != null ? thread.mUVCCamera : null;
        if (camera != null) {
            if (flag == -2147483647) {
                return camera.getBrightness();
            }
            if (flag == -2147483646) {
                return camera.getContrast();
            }
        }
        throw new IllegalStateException();
    }

    public int setValue(int flag, int value) {
        UVCCamera camera;
        this.checkReleased();
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        UVCCamera uVCCamera = camera = thread != null ? thread.mUVCCamera : null;
        if (camera != null) {
            if (flag == -2147483647) {
                camera.setBrightness(value);
                return camera.getBrightness();
            }
            if (flag == -2147483646) {
                camera.setContrast(value);
                return camera.getContrast();
            }
        }
        throw new IllegalStateException();
    }

    public int resetValue(int flag) {
        UVCCamera camera;
        this.checkReleased();
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        UVCCamera uVCCamera = camera = thread != null ? thread.mUVCCamera : null;
        if (camera != null) {
            if (flag == -2147483647) {
                camera.resetBrightness();
                return camera.getBrightness();
            }
            if (flag == -2147483646) {
                camera.resetContrast();
                return camera.getContrast();
            }
        }
        throw new IllegalStateException();
    }

    public void handleMessage(Message msg) {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        if (thread == null) {
            return;
        }
        switch (msg.what) {
            case 0: {
                thread.handleOpen((USBMonitor.UsbControlBlock)msg.obj);
                break;
            }
            case 1: {
                thread.handleClose();
                break;
            }
            case 2: {
                thread.handleStartPreview(msg.obj);
                break;
            }
            case 3: {
                thread.handleStopPreview();
                break;
            }
            case 4: {
                thread.handleCaptureStill((String)msg.obj);
                break;
            }
            case 5: {
                thread.handleStartRecording();
                break;
            }
            case 6: {
                thread.handleStopRecording();
                break;
            }
            case 7: {
                thread.handleUpdateMedia((String)msg.obj);
                break;
            }
            case 9: {
                thread.handleRelease();
                break;
            }
            default: {
                throw new RuntimeException("unsupported message:what=" + msg.what);
            }
        }
    }

    static final class CameraThread
    extends Thread {
        private static final String TAG_THREAD = "CameraThread";
        private final Object mSync = new Object();
        private final Class<? extends AbstractUVCCameraHandler> mHandlerClass;
        private final WeakReference<Activity> mWeakParent;
        private final WeakReference<CameraViewInterface> mWeakCameraView;
        private final int mEncoderType;
        private final Set<CameraCallback> mCallbacks = new CopyOnWriteArraySet<CameraCallback>();
        private int mWidth;
        private int mHeight;
        private int mPreviewMode;
        private float mBandwidthFactor;
        private boolean mIsPreviewing;
        private boolean mIsRecording;
        private SoundPool mSoundPool;
        private int mSoundId;
        private AbstractUVCCameraHandler mHandler;
        private UVCCamera mUVCCamera;
        private MediaMuxerWrapper mMuxer;
        private MediaVideoBufferEncoder mVideoEncoder;
        private final IFrameCallback mIFrameCallback = new IFrameCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFrame(ByteBuffer frame) {
                MediaVideoBufferEncoder videoEncoder;
                Object object = CameraThread.this.mSync;
                synchronized (object) {
                    videoEncoder = CameraThread.this.mVideoEncoder;
                }
                if (videoEncoder != null) {
                    videoEncoder.frameAvailableSoon();
                    videoEncoder.encode(frame);
                }
            }
        };
        private final MediaEncoder.MediaEncoderListener mMediaEncoderListener = new MediaEncoder.MediaEncoderListener(){

            @Override
            public void onPrepared(MediaEncoder encoder) {
                Log.v((String)AbstractUVCCameraHandler.TAG, (String)("onPrepared:encoder=" + encoder));
                CameraThread.this.mIsRecording = true;
                if (encoder instanceof MediaVideoEncoder) {
                    try {
                        ((CameraViewInterface)CameraThread.this.mWeakCameraView.get()).setVideoEncoder((MediaVideoEncoder)encoder);
                    }
                    catch (Exception e) {
                        Log.e((String)AbstractUVCCameraHandler.TAG, (String)"onPrepared:", (Throwable)e);
                    }
                }
                if (encoder instanceof MediaSurfaceEncoder) {
                    try {
                        ((CameraViewInterface)CameraThread.this.mWeakCameraView.get()).setVideoEncoder((MediaSurfaceEncoder)encoder);
                        CameraThread.this.mUVCCamera.startCapture(((MediaSurfaceEncoder)encoder).getInputSurface());
                    }
                    catch (Exception e) {
                        Log.e((String)AbstractUVCCameraHandler.TAG, (String)"onPrepared:", (Throwable)e);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStopped(MediaEncoder encoder) {
                Log.v((String)CameraThread.TAG_THREAD, (String)("onStopped:encoder=" + encoder));
                if (encoder instanceof MediaVideoEncoder || encoder instanceof MediaSurfaceEncoder) {
                    try {
                        CameraThread.this.mIsRecording = false;
                        Activity parent = (Activity)CameraThread.this.mWeakParent.get();
                        ((CameraViewInterface)CameraThread.this.mWeakCameraView.get()).setVideoEncoder(null);
                        Object object = CameraThread.this.mSync;
                        synchronized (object) {
                            if (CameraThread.this.mUVCCamera != null) {
                                CameraThread.this.mUVCCamera.stopCapture();
                            }
                        }
                        String path = encoder.getOutputPath();
                        if (!TextUtils.isEmpty((CharSequence)path)) {
                            CameraThread.this.mHandler.sendMessageDelayed(CameraThread.this.mHandler.obtainMessage(7, path), 1000L);
                        } else {
                            boolean released;
                            boolean bl = released = CameraThread.this.mHandler == null || CameraThread.this.mHandler.mReleased;
                            if (released || parent == null || parent.isDestroyed()) {
                                CameraThread.this.handleRelease();
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)AbstractUVCCameraHandler.TAG, (String)"onPrepared:", (Throwable)e);
                    }
                }
            }
        };

        CameraThread(Class<? extends AbstractUVCCameraHandler> clazz, Activity parent, CameraViewInterface cameraView, int encoderType, int width, int height, int format, float bandwidthFactor) {
            super(TAG_THREAD);
            this.mHandlerClass = clazz;
            this.mEncoderType = encoderType;
            this.mWidth = width;
            this.mHeight = height;
            this.mPreviewMode = format;
            this.mBandwidthFactor = bandwidthFactor;
            this.mWeakParent = new WeakReference<Activity>(parent);
            this.mWeakCameraView = new WeakReference<CameraViewInterface>(cameraView);
            this.loadShutterSound((Context)parent);
        }

        protected void finalize() throws Throwable {
            Log.i((String)AbstractUVCCameraHandler.TAG, (String)"CameraThread#finalize");
            super.finalize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractUVCCameraHandler getHandler() {
            Log.v((String)TAG_THREAD, (String)"getHandler:");
            Object object = this.mSync;
            synchronized (object) {
                if (this.mHandler == null) {
                    try {
                        this.mSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return this.mHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getWidth() {
            Object object = this.mSync;
            synchronized (object) {
                return this.mWidth;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getHeight() {
            Object object = this.mSync;
            synchronized (object) {
                return this.mHeight;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCameraOpened() {
            Object object = this.mSync;
            synchronized (object) {
                return this.mUVCCamera != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPreviewing() {
            Object object = this.mSync;
            synchronized (object) {
                return this.mUVCCamera != null && this.mIsPreviewing;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRecording() {
            Object object = this.mSync;
            synchronized (object) {
                return this.mUVCCamera != null && this.mMuxer != null;
            }
        }

        public boolean isEqual(UsbDevice device) {
            return this.mUVCCamera != null && this.mUVCCamera.getDevice() != null && this.mUVCCamera.getDevice().equals((Object)device);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleOpen(USBMonitor.UsbControlBlock ctrlBlock) {
            Log.v((String)TAG_THREAD, (String)"handleOpen:");
            this.handleClose();
            try {
                UVCCamera camera = new UVCCamera();
                camera.open(ctrlBlock);
                Object object = this.mSync;
                synchronized (object) {
                    this.mUVCCamera = camera;
                }
                this.callOnOpen();
            }
            catch (Exception e) {
                this.callOnError(e);
            }
            Log.i((String)AbstractUVCCameraHandler.TAG, (String)("supportedSize:" + (this.mUVCCamera != null ? this.mUVCCamera.getSupportedSize() : null)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleClose() {
            UVCCamera camera;
            Log.v((String)TAG_THREAD, (String)"handleClose:");
            this.handleStopRecording();
            Object object = this.mSync;
            synchronized (object) {
                camera = this.mUVCCamera;
                this.mUVCCamera = null;
            }
            if (camera != null) {
                camera.stopPreview();
                camera.destroy();
                this.callOnClose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStartPreview(Object surface) {
            Log.v((String)TAG_THREAD, (String)"handleStartPreview:");
            if (this.mUVCCamera == null || this.mIsPreviewing) {
                return;
            }
            try {
                this.mUVCCamera.setPreviewSize(this.mWidth, this.mHeight, this.mPreviewMode, this.mBandwidthFactor);
            }
            catch (IllegalArgumentException e) {
                try {
                    this.mUVCCamera.setPreviewSize(this.mWidth, this.mHeight, 0, this.mBandwidthFactor);
                }
                catch (IllegalArgumentException e1) {
                    this.callOnError(e1);
                    return;
                }
            }
            if (surface instanceof SurfaceHolder) {
                this.mUVCCamera.setPreviewDisplay((SurfaceHolder)surface);
            }
            if (surface instanceof Surface) {
                this.mUVCCamera.setPreviewDisplay((Surface)surface);
            } else {
                this.mUVCCamera.setPreviewTexture((SurfaceTexture)surface);
            }
            this.mUVCCamera.startPreview();
            this.mUVCCamera.updateCameraParams();
            Object object = this.mSync;
            synchronized (object) {
                this.mIsPreviewing = true;
            }
            this.callOnStartPreview();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStopPreview() {
            Log.v((String)TAG_THREAD, (String)"handleStopPreview:");
            if (this.mIsPreviewing) {
                if (this.mUVCCamera != null) {
                    this.mUVCCamera.stopPreview();
                }
                Object object = this.mSync;
                synchronized (object) {
                    this.mIsPreviewing = false;
                    this.mSync.notifyAll();
                }
                this.callOnStopPreview();
            }
            Log.v((String)TAG_THREAD, (String)"handleStopPreview:finished");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleCaptureStill(String path) {
            Log.v((String)TAG_THREAD, (String)"handleCaptureStill:");
            Activity parent = (Activity)this.mWeakParent.get();
            if (parent == null) {
                return;
            }
            this.mSoundPool.play(this.mSoundId, 0.2f, 0.2f, 0, 0, 1.0f);
            try {
                Bitmap bitmap = ((CameraViewInterface)this.mWeakCameraView.get()).captureStillImage();
                File outputFile = TextUtils.isEmpty((CharSequence)path) ? MediaMuxerWrapper.getCaptureFile(Environment.DIRECTORY_DCIM, ".png") : new File(path);
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outputFile));){
                    try {
                        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
                        os.flush();
                        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, outputFile.getPath()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                this.callOnError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStartRecording() {
            Log.v((String)TAG_THREAD, (String)"handleStartRecording:");
            try {
                if (this.mUVCCamera == null || this.mMuxer != null) {
                    return;
                }
                MediaMuxerWrapper muxer = new MediaMuxerWrapper(".mp4");
                MediaVideoBufferEncoder videoEncoder = null;
                switch (this.mEncoderType) {
                    case 1: {
                        new MediaVideoEncoder(muxer, this.getWidth(), this.getHeight(), this.mMediaEncoderListener);
                        break;
                    }
                    case 2: {
                        videoEncoder = new MediaVideoBufferEncoder(muxer, this.getWidth(), this.getHeight(), this.mMediaEncoderListener);
                        break;
                    }
                    default: {
                        new MediaSurfaceEncoder(muxer, this.getWidth(), this.getHeight(), this.mMediaEncoderListener);
                    }
                }
                new MediaAudioEncoder(muxer, this.mMediaEncoderListener);
                muxer.prepare();
                muxer.startRecording();
                if (videoEncoder != null) {
                    this.mUVCCamera.setFrameCallback(this.mIFrameCallback, 5);
                }
                Object object = this.mSync;
                synchronized (object) {
                    this.mMuxer = muxer;
                    this.mVideoEncoder = videoEncoder;
                }
                this.callOnStartRecording();
            }
            catch (IOException e) {
                this.callOnError(e);
                Log.e((String)AbstractUVCCameraHandler.TAG, (String)"startCapture:", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStopRecording() {
            MediaMuxerWrapper muxer;
            Log.v((String)TAG_THREAD, (String)("handleStopRecording:mMuxer=" + this.mMuxer));
            Object object = this.mSync;
            synchronized (object) {
                muxer = this.mMuxer;
                this.mMuxer = null;
                this.mVideoEncoder = null;
                if (this.mUVCCamera != null) {
                    this.mUVCCamera.stopCapture();
                }
            }
            try {
                ((CameraViewInterface)this.mWeakCameraView.get()).setVideoEncoder(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (muxer != null) {
                muxer.stopRecording();
                this.mUVCCamera.setFrameCallback(null, 0);
                this.callOnStopRecording();
            }
        }

        public void handleUpdateMedia(String path) {
            boolean released;
            Log.v((String)TAG_THREAD, (String)("handleUpdateMedia:path=" + path));
            Activity parent = (Activity)this.mWeakParent.get();
            boolean bl = released = this.mHandler == null || this.mHandler.mReleased;
            if (parent != null && parent.getApplicationContext() != null) {
                try {
                    Log.i((String)AbstractUVCCameraHandler.TAG, (String)"MediaScannerConnection#scanFile");
                    MediaScannerConnection.scanFile((Context)parent.getApplicationContext(), (String[])new String[]{path}, null, null);
                }
                catch (Exception e) {
                    Log.e((String)AbstractUVCCameraHandler.TAG, (String)"handleUpdateMedia:", (Throwable)e);
                }
                if (released || parent.isDestroyed()) {
                    this.handleRelease();
                }
            } else {
                Log.w((String)AbstractUVCCameraHandler.TAG, (String)"MainActivity already destroyed");
                this.handleRelease();
            }
        }

        public void handleRelease() {
            Log.v((String)TAG_THREAD, (String)("handleRelease:mIsRecording=" + this.mIsRecording));
            this.handleClose();
            this.mCallbacks.clear();
            if (!this.mIsRecording) {
                this.mHandler.mReleased = true;
                Looper.myLooper().quit();
            }
            Log.v((String)TAG_THREAD, (String)"handleRelease:finished");
        }

        private void loadShutterSound(Context context) {
            int streamType;
            try {
                Class<?> audioSystemClass = Class.forName("android.media.AudioSystem");
                Field sseField = audioSystemClass.getDeclaredField("STREAM_SYSTEM_ENFORCED");
                streamType = sseField.getInt(null);
            }
            catch (Exception e) {
                streamType = 1;
            }
            if (this.mSoundPool != null) {
                try {
                    this.mSoundPool.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mSoundPool = null;
            }
            this.mSoundPool = new SoundPool(2, streamType, 0);
            this.mSoundId = this.mSoundPool.load(context, R.raw.camera_click, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Looper.prepare();
            AbstractUVCCameraHandler handler = null;
            try {
                Constructor<? extends AbstractUVCCameraHandler> constructor = this.mHandlerClass.getDeclaredConstructor(CameraThread.class);
                handler = constructor.newInstance(this);
            }
            catch (NoSuchMethodException e) {
                Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
            }
            catch (InstantiationException e) {
                Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
            }
            if (handler != null) {
                object = this.mSync;
                synchronized (object) {
                    this.mHandler = handler;
                    this.mSync.notifyAll();
                }
                Looper.loop();
                if (this.mSoundPool != null) {
                    this.mSoundPool.release();
                    this.mSoundPool = null;
                }
                if (this.mHandler != null) {
                    this.mHandler.mReleased = true;
                }
            }
            this.mCallbacks.clear();
            object = this.mSync;
            synchronized (object) {
                this.mHandler = null;
                this.mSync.notifyAll();
            }
        }

        private void callOnOpen() {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onOpen();
                }
                catch (Exception e) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }

        private void callOnClose() {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onClose();
                }
                catch (Exception e) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }

        private void callOnStartPreview() {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onStartPreview();
                }
                catch (Exception e) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }

        private void callOnStopPreview() {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onStopPreview();
                }
                catch (Exception e) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }

        private void callOnStartRecording() {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onStartRecording();
                }
                catch (Exception e) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }

        private void callOnStopRecording() {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onStopRecording();
                }
                catch (Exception e) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }

        private void callOnError(Exception e) {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onError(e);
                }
                catch (Exception e1) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }
    }

    public static interface CameraCallback {
        public void onOpen();

        public void onClose();

        public void onStartPreview();

        public void onStopPreview();

        public void onStartRecording();

        public void onStopRecording();

        public void onError(Exception var1);
    }
}

