/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;

public class MaskImageView
extends ImageView {
    private final Paint mMaskedPaint = new Paint();
    private final Paint mCopyPaint = new Paint();
    private final Rect mMaskBounds = new Rect();
    private final RectF mViewBoundsF = new RectF();
    private Drawable mMaskDrawable;

    public MaskImageView(Context context) {
        this(context, null, 0);
    }

    public MaskImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaskImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mMaskedPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        this.mMaskDrawable = null;
    }

    public synchronized void setMaskDrawable(Drawable mask_drawable) {
        if (this.mMaskDrawable != mask_drawable) {
            this.mMaskDrawable = mask_drawable;
            if (this.mMaskDrawable != null) {
                this.mMaskDrawable.setBounds(this.mMaskBounds);
            }
            this.postInvalidate();
        }
    }

    protected synchronized void onSizeChanged(int width, int height, int old_width, int old_height) {
        super.onSizeChanged(width, height, old_width, old_height);
        if (width == 0 || height == 0) {
            return;
        }
        int padding_left = this.getPaddingLeft();
        int padding_top = this.getPaddingTop();
        int sz = Math.min(width - padding_left - this.getPaddingRight(), height - padding_top - this.getPaddingBottom());
        int left = (width - sz) / 2 + padding_left;
        int top = (height - sz) / 2 + padding_top;
        this.mMaskBounds.set(left, top, left + sz, top + sz);
        if (sz > 3) {
            this.mMaskedPaint.setMaskFilter((MaskFilter)new BlurMaskFilter((float)(sz * 2) / 3.0f, BlurMaskFilter.Blur.NORMAL));
        }
        this.mViewBoundsF.set(0.0f, 0.0f, (float)width, (float)height);
        if (this.mMaskDrawable != null) {
            this.mMaskDrawable.setBounds(this.mMaskBounds);
        }
    }

    protected synchronized void onDraw(Canvas canvas) {
        int saveCount = canvas.saveLayer(this.mViewBoundsF, this.mCopyPaint, 12);
        try {
            if (this.mMaskDrawable != null) {
                this.mMaskDrawable.draw(canvas);
                canvas.saveLayer(this.mViewBoundsF, this.mMaskedPaint, 0);
            }
            super.onDraw(canvas);
        }
        finally {
            canvas.restoreToCount(saveCount);
        }
    }
}

