/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.util.Log;
import com.serenegiant.utils.BuildCheck;
import java.io.File;

public final class UriHelper {
    private static final String TAG = UriHelper.class.getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAbsolutePath(ContentResolver cr, Uri uri) {
        String path;
        block6: {
            path = null;
            try {
                String[] columns = new String[]{"_data"};
                Cursor cursor = cr.query(uri, columns, null, null, null);
                if (cursor == null) break block6;
                try {
                    if (cursor.moveToFirst()) {
                        path = cursor.getString(0);
                    }
                }
                finally {
                    cursor.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return path;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=19)
    public static String getPath(Context context, Uri uri) {
        Log.i((String)TAG, (String)("getPath:uri=" + uri));
        if (BuildCheck.isKitKat() && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            Log.i((String)TAG, (String)("getPath:isDocumentUri,getAuthority=" + uri.getAuthority()));
            if (UriHelper.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                Log.i((String)TAG, (String)("getPath:isDocumentUri,docId=" + docId));
                if (BuildCheck.isLollipop()) {
                    Log.i((String)TAG, (String)("getPath:isDocumentUri,getTreeDocumentId=" + DocumentsContract.getTreeDocumentId((Uri)uri)));
                }
                String[] split = docId.split(":");
                String type = split[0];
                Log.i((String)TAG, (String)("getPath:type=" + type));
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
                String primary = Environment.getExternalStorageDirectory().getAbsolutePath();
                Log.i((String)TAG, (String)("getPath:primary=" + primary));
                File[] dirs = context.getExternalFilesDirs(null);
                int n = dirs != null ? dirs.length : 0;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    int m;
                    File dir = dirs[i];
                    Log.i((String)TAG, (String)("getPath:" + i + ")dir=" + dir));
                    if (dir != null && dir.getAbsolutePath().startsWith(primary)) continue;
                    String dir_path = dir.getAbsolutePath();
                    String[] dir_elements = dir_path.split("/");
                    int n2 = m = dir_elements != null ? dir_elements.length : 0;
                    if (m <= 1 || !"storage".equalsIgnoreCase(dir_elements[1])) continue;
                    boolean found = false;
                    sb.setLength(0);
                    sb.append('/').append(dir_elements[1]);
                    for (int j = 2; j < m; ++j) {
                        if ("Android".equalsIgnoreCase(dir_elements[j])) {
                            found = true;
                            break;
                        }
                        sb.append('/').append(dir_elements[j]);
                    }
                    if (!found) continue;
                    File path = new File(new File(sb.toString()), split[1]);
                    Log.i((String)TAG, (String)("getPath:path=" + path));
                    if (!path.exists() || !path.canWrite()) continue;
                    return path.getAbsolutePath();
                }
            } else {
                if (UriHelper.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    return UriHelper.getDataColumn(context, contentUri, null, null);
                }
                if (UriHelper.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return UriHelper.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (UriHelper.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return UriHelper.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }
}

