/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.net;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.serenegiant.utils.BuildCheck;
import com.serenegiant.utils.ComponentUtils;

public class NetworkChangedReceiver
extends BroadcastReceiver {
    private static final boolean DEBUG = false;
    private static final String TAG = NetworkChangedReceiver.class.getSimpleName();
    public static final String KEY_NETWORK_CHANGED_IS_CONNECTED_OR_CONNECTING = "KEY_NETWORK_CHANGED_IS_CONNECTED_OR_CONNECTING";
    public static final String KEY_NETWORK_CHANGED_IS_CONNECTED = "KEY_NETWORK_CHANGED_IS_CONNECTED";
    public static final String KEY_NETWORK_CHANGED_ACTIVE_NETWORK_MASK = "KEY_NETWORK_CHANGED_ACTIVE_NETWORK_MASK";
    public static final int NETWORK_TYPE_MOBILE = 1;
    public static final int NETWORK_TYPE_WIFI = 2;
    public static final int NETWORK_TYPE_MOBILE_MMS = 4;
    public static final int NETWORK_TYPE_MOBILE_SUPL = 8;
    public static final int NETWORK_TYPE_MOBILE_DUN = 16;
    public static final int NETWORK_TYPE_MOBILE_HIPRI = 32;
    public static final int NETWORK_TYPE_WIMAX = 64;
    public static final int NETWORK_TYPE_BLUETOOTH = 128;
    public static final int NETWORK_TYPE_ETHERNET = 512;
    private static final int NETWORK_MASK_INTERNET_WIFI = 706;
    private static final Object sSync = new Object();
    private static int sGlobalReceiverNum;
    private static int sIsConnectedOrConnecting;
    private static int sIsConnected;
    private static int sActiveNetworkMask;
    private static final String ACTION_GLOBAL_CONNECTIVITY_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE";
    private static final String ACTION_LOCAL_CONNECTIVITY_CHANGE = "com.serenegiant.net.CONNECTIVITY_CHANGE";
    private OnNetworkChangedListener mListener;
    private static final int[] NETWORKS;

    public static void enable(Context context) {
        ComponentUtils.enable(context, NetworkChangedReceiver.class);
    }

    public static void disable(Context context) {
        ComponentUtils.disable(context, NetworkChangedReceiver.class);
    }

    public static NetworkChangedReceiver registerGlobal(Context context) {
        return NetworkChangedReceiver.registerGlobal(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkChangedReceiver registerGlobal(Context context, OnNetworkChangedListener listener) {
        NetworkChangedReceiver receiver = new NetworkChangedReceiver(listener);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ACTION_GLOBAL_CONNECTIVITY_CHANGE);
        Object object = sSync;
        synchronized (object) {
            context.registerReceiver((BroadcastReceiver)receiver, intentFilter);
            ++sGlobalReceiverNum;
        }
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGlobalRegistered() {
        Object object = sSync;
        synchronized (object) {
            return sGlobalReceiverNum > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterGlobal(Context context, NetworkChangedReceiver receiver) {
        Object object = sSync;
        synchronized (object) {
            if (context != null && receiver != null) {
                --sGlobalReceiverNum;
                try {
                    context.unregisterReceiver((BroadcastReceiver)receiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkChangedReceiver registerLocal(Context context, OnNetworkChangedListener listener) {
        int activeNetworkMask;
        int isConnected;
        int isConnectedOrConnecting;
        final NetworkChangedReceiver receiver = new NetworkChangedReceiver(listener);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ACTION_LOCAL_CONNECTIVITY_CHANGE);
        LocalBroadcastManager broadcastManager = LocalBroadcastManager.getInstance((Context)context.getApplicationContext());
        broadcastManager.registerReceiver((BroadcastReceiver)receiver, intentFilter);
        Handler handler = null;
        try {
            handler = new Handler(Looper.getMainLooper());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = sSync;
        synchronized (object) {
            isConnectedOrConnecting = sIsConnectedOrConnecting;
            isConnected = sIsConnected;
            activeNetworkMask = sActiveNetworkMask;
        }
        if (handler != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    receiver.callOnNetworkChanged(isConnectedOrConnecting, isConnected, activeNetworkMask);
                }
            });
        } else {
            receiver.callOnNetworkChanged(isConnectedOrConnecting, isConnected, activeNetworkMask);
        }
        return receiver;
    }

    public static void unregisterLocal(Context context, NetworkChangedReceiver receiver) {
        LocalBroadcastManager broadcastManager = LocalBroadcastManager.getInstance((Context)context.getApplicationContext());
        try {
            broadcastManager.unregisterReceiver((BroadcastReceiver)receiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NetworkChangedReceiver() {
        this.mListener = null;
    }

    private NetworkChangedReceiver(OnNetworkChangedListener listener) {
        this.mListener = listener;
    }

    public void unregister(Context context) {
        try {
            NetworkChangedReceiver.unregisterGlobal(context, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NetworkChangedReceiver.unregisterLocal(context, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onReceive(Context context, Intent intent) {
        String action;
        String string2 = action = intent != null ? intent.getAction() : null;
        if (ACTION_GLOBAL_CONNECTIVITY_CHANGE.equals(action)) {
            this.onReceiveGlobal(context, intent);
        } else if (ACTION_LOCAL_CONNECTIVITY_CHANGE.equals(action)) {
            this.onReceiveLocal(context, intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private void onReceiveGlobal(Context context, Intent intent) {
        NetworkInfo activeNetworkInfo;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        LocalBroadcastManager broadcastManager = LocalBroadcastManager.getInstance((Context)context.getApplicationContext());
        int isConnectedOrConnecting = 0;
        int isConnected = 0;
        if (BuildCheck.isAndroid5()) {
            Network[] networks = connectivityManager.getAllNetworks();
            if (networks != null) {
                for (Network network : networks) {
                    NetworkInfo info = connectivityManager.getNetworkInfo(network);
                    if (info == null) continue;
                    isConnectedOrConnecting |= info.isConnectedOrConnecting() ? 1 << info.getType() : 0;
                    isConnected |= info.isConnected() ? 1 << info.getType() : 0;
                }
            }
        } else {
            int n = NETWORKS.length;
            for (int i = 0; i < n; i += 2) {
                NetworkInfo info = connectivityManager.getNetworkInfo(NETWORKS[i]);
                if (info == null) continue;
                isConnectedOrConnecting |= info.isConnectedOrConnecting() ? NETWORKS[i + 1] : 0;
                isConnected |= info.isConnected() ? NETWORKS[i + 1] : 0;
            }
        }
        int activeNetworkMask = (activeNetworkInfo = connectivityManager.getActiveNetworkInfo()) != null ? 1 << activeNetworkInfo.getType() : 0;
        Object info = sSync;
        synchronized (info) {
            sIsConnectedOrConnecting = isConnectedOrConnecting;
            sIsConnected = isConnected;
            sActiveNetworkMask = activeNetworkMask;
            sSync.notifyAll();
        }
        this.callOnNetworkChanged(isConnectedOrConnecting, isConnected, activeNetworkMask);
        Intent networkChangedIntent = new Intent(ACTION_LOCAL_CONNECTIVITY_CHANGE);
        networkChangedIntent.putExtra(KEY_NETWORK_CHANGED_IS_CONNECTED_OR_CONNECTING, isConnectedOrConnecting);
        networkChangedIntent.putExtra(KEY_NETWORK_CHANGED_IS_CONNECTED, isConnected);
        networkChangedIntent.putExtra(KEY_NETWORK_CHANGED_ACTIVE_NETWORK_MASK, activeNetworkMask);
        broadcastManager.sendBroadcast(networkChangedIntent);
    }

    private void onReceiveLocal(Context context, Intent intent) {
        int isConnectedOrConnecting = intent.getIntExtra(KEY_NETWORK_CHANGED_IS_CONNECTED_OR_CONNECTING, 0);
        int isConnected = intent.getIntExtra(KEY_NETWORK_CHANGED_IS_CONNECTED, 0);
        int activeNetworkInfo = intent.getIntExtra(KEY_NETWORK_CHANGED_ACTIVE_NETWORK_MASK, 0);
        this.callOnNetworkChanged(isConnectedOrConnecting, isConnected, activeNetworkInfo);
    }

    private void callOnNetworkChanged(int isConnectedOrConnecting, int isConnected, int activeNetworkInfo) {
        if (this.mListener != null) {
            try {
                this.mListener.onNetworkChanged(isConnectedOrConnecting, isConnected, activeNetworkInfo);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWifiNetworkReachable() {
        int isConnectedOrConnecting;
        Object object = sSync;
        synchronized (object) {
            isConnectedOrConnecting = sIsConnectedOrConnecting & sActiveNetworkMask;
        }
        return (isConnectedOrConnecting & 0x2C2) != 0;
    }

    public static boolean isWifiNetworkReachable(Context context) {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connMgr.getActiveNetworkInfo();
        if (activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting()) {
            int type = activeNetworkInfo.getType();
            return type == 1 || type == 6 || type == 7 || type == 9;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMobileNetworkReachable() {
        int isConnectedOrConnecting;
        Object object = sSync;
        synchronized (object) {
            isConnectedOrConnecting = sIsConnectedOrConnecting & sActiveNetworkMask;
        }
        return (isConnectedOrConnecting & 1) != 0;
    }

    public static boolean isMobileNetworkReachable(Context context) {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connMgr.getActiveNetworkInfo();
        if (activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting()) {
            int type = activeNetworkInfo.getType();
            return type == 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNetworkReachable() {
        int isConnectedOrConnecting;
        Object object = sSync;
        synchronized (object) {
            isConnectedOrConnecting = sIsConnectedOrConnecting & sActiveNetworkMask;
        }
        return isConnectedOrConnecting != 0;
    }

    public static boolean isNetworkReachable(Context context) {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connMgr.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting();
    }

    static {
        sIsConnectedOrConnecting = 0;
        sIsConnected = 0;
        sActiveNetworkMask = 0;
        NETWORKS = new int[]{0, 1, 1, 2, 2, 4, 3, 8, 4, 16, 5, 32, 6, 64, 7, 128, 9, 512};
    }

    public static interface OnNetworkChangedListener {
        public void onNetworkChanged(int var1, int var2, int var3);
    }
}

