/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

public class VideoConfig {
    public static float BPP = 0.25f;
    public static final int FPS_MIN = 1;
    public static final int FPS_MAX = 30;
    private static float IFRAME_INTERVAL = 10.0f;
    private static final int IFRAME_MIN = 1;
    private static final int IFRAME_MAX = 30;
    private static float IFI = IFRAME_INTERVAL * 30.0f;
    public static int captureFps = 15;
    public static long maxDuration = 30000L;
    public static long repeatInterval = 60000L;
    public static int maxRepeats = 1;

    public static int getCaptureFps() {
        return captureFps > 30 ? 30 : (captureFps < 1 ? 1 : captureFps);
    }

    public static void setIFrame(float iframe_interval) {
        IFRAME_INTERVAL = iframe_interval;
        IFI = IFRAME_INTERVAL * 30.0f;
    }

    public static final int getIFrame() {
        float iframe;
        int fps = VideoConfig.getCaptureFps();
        try {
            iframe = fps < 2 ? 1.0f : (float)Math.ceil(IFI / (float)fps);
        }
        catch (Exception e) {
            iframe = IFRAME_INTERVAL;
        }
        if ((int)iframe < 1) {
            iframe = 1.0f;
        } else if ((int)iframe > 30) {
            iframe = 30.0f;
        }
        return (int)iframe;
    }

    public static int getBitrate(int width, int height) {
        return VideoConfig.getBitrate(width, height, VideoConfig.getCaptureFps(), BPP);
    }

    public static int getBitrate(int width, int height, int frameRate) {
        return VideoConfig.getBitrate(width, height, frameRate, BPP);
    }

    public static int getBitrate(int width, int height, int frameRate, float bpp) {
        int r = (int)(Math.floor(bpp * (float)frameRate * (float)width * (float)height / 1000.0f / 100.0f) * 100.0) * 1000;
        if (r < 200000) {
            r = 200000;
        } else if (r > 14000000) {
            r = 14000000;
        }
        return r;
    }

    public static void setBPP(int width, int height, int bitrate) {
        int captureFps = VideoConfig.getCaptureFps();
        BPP = (float)bitrate / (float)(captureFps * width * height);
    }

    public static void setBPP(float bpp) throws IllegalArgumentException {
        if (bpp < 0.05f || bpp > 0.3f) {
            throw new IllegalArgumentException("bpp should be within [0.05,0.3]");
        }
        BPP = bpp;
    }

    public float bpp() {
        return BPP;
    }

    public static int getSizeRate(int width, int height) {
        int bitrate = VideoConfig.getBitrate(width, height);
        return bitrate * 60 / 8;
    }
}

