/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.media.AudioRecord;
import android.os.Process;
import com.serenegiant.media.AbstractAudioEncoder;
import com.serenegiant.media.AudioData;
import com.serenegiant.media.AudioSampler;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class AudioEncoderBuffered
extends AbstractAudioEncoder {
    private final int MAX_POOL_SIZE = 100;
    private final int MAX_QUEUE_SIZE = 100;
    private AudioThread mAudioThread = null;
    private DequeueThread mDequeueThread = null;
    protected int mBufferSize = 1024;
    protected final LinkedBlockingQueue<AudioData> mPool = new LinkedBlockingQueue(100);
    protected final LinkedBlockingQueue<AudioData> mAudioQueue = new LinkedBlockingQueue(100);
    private int mBufferNum = 0;

    public AudioEncoderBuffered(IRecorder recorder, EncoderListener listener, int audio_source, int audio_channels) {
        super(recorder, listener, audio_source, audio_channels);
        if (audio_source < 0 || audio_source > 7) {
            throw new IllegalArgumentException("invalid audio source:" + audio_source);
        }
    }

    @Override
    public void start() {
        super.start();
        if (this.mAudioThread == null) {
            this.mAudioThread = new AudioThread();
            this.mAudioThread.start();
            this.mDequeueThread = new DequeueThread();
            this.mDequeueThread.start();
        }
    }

    @Override
    public void stop() {
        this.mAudioThread = null;
        this.mDequeueThread = null;
        super.stop();
    }

    private AudioData obtain() {
        AudioData result = null;
        try {
            result = this.mPool.poll(20L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (result == null && this.mBufferNum < 100) {
            result = new AudioData(this.mBufferSize);
            ++this.mBufferNum;
        }
        if (result != null) {
            result.size = 0;
        }
        return result;
    }

    protected void recycle(AudioData data) {
        this.mPool.offer(data);
    }

    private final class DequeueThread
    extends Thread {
        public DequeueThread() {
            super("DequeueThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            int frame_count = 0;
            while (true) {
                AudioData data;
                Object object = AudioEncoderBuffered.this.mSync;
                synchronized (object) {
                    if (!AudioEncoderBuffered.this.mIsCapturing || AudioEncoderBuffered.this.mRequestStop || AudioEncoderBuffered.this.mIsEOS) {
                        break;
                    }
                }
                try {
                    data = AudioEncoderBuffered.this.mAudioQueue.poll(30L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e1) {
                    break;
                }
                if (data == null) continue;
                if (data.size > 0) {
                    AudioEncoderBuffered.this.encode(data.mBuffer, data.size, data.presentationTimeUs);
                    AudioEncoderBuffered.this.frameAvailableSoon();
                    ++frame_count;
                }
                AudioEncoderBuffered.this.recycle(data);
            }
            if (frame_count == 0) {
                ByteBuffer buf = ByteBuffer.allocateDirect(AudioEncoderBuffered.this.mBufferSize).order(ByteOrder.nativeOrder());
                for (int i = 0; AudioEncoderBuffered.this.mIsCapturing && i < 5; ++i) {
                    buf.position(1024);
                    buf.flip();
                    AudioEncoderBuffered.this.encode(buf, 1024, AudioEncoderBuffered.this.getInputPTSUs());
                    AudioEncoderBuffered.this.frameAvailableSoon();
                    DequeueThread dequeueThread = this;
                    synchronized (dequeueThread) {
                        try {
                            this.wait(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
            }
        }
    }

    private final class AudioThread
    extends Thread {
        public AudioThread() {
            super("AudioThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            block18: {
                Process.setThreadPriority((int)-16);
                int buffer_size = AudioSampler.getAudioBufferSize(AudioEncoderBuffered.this.mChannelCount, AudioEncoderBuffered.this.mSampleRate, 1024, 25);
                AudioRecord audioRecord = AudioSampler.createAudioRecord(AudioEncoderBuffered.this.mAudioSource, AudioEncoderBuffered.this.mSampleRate, AudioEncoderBuffered.this.mChannelCount, 2, buffer_size);
                int err_count = 0;
                if (audioRecord != null) {
                    try {
                        if (!AudioEncoderBuffered.this.mIsCapturing) break block18;
                        audioRecord.startRecording();
                        try {
                            do {
                                int readBytes;
                                Object object = AudioEncoderBuffered.this.mSync;
                                synchronized (object) {
                                    if (!AudioEncoderBuffered.this.mIsCapturing || AudioEncoderBuffered.this.mRequestStop || AudioEncoderBuffered.this.mIsEOS) {
                                        break;
                                    }
                                }
                                AudioData data = AudioEncoderBuffered.this.obtain();
                                ByteBuffer buffer = data.mBuffer;
                                buffer.clear();
                                try {
                                    readBytes = audioRecord.read(buffer, 1024);
                                }
                                catch (Exception e) {
                                    break;
                                }
                                if (readBytes == -2) {
                                    ++err_count;
                                    AudioEncoderBuffered.this.recycle(data);
                                    continue;
                                }
                                if (readBytes == -3) {
                                    ++err_count;
                                    AudioEncoderBuffered.this.recycle(data);
                                    continue;
                                }
                                if (readBytes <= 0) continue;
                                err_count = 0;
                                data.presentationTimeUs = AudioEncoderBuffered.this.getInputPTSUs();
                                data.size = readBytes;
                                buffer.position(readBytes);
                                buffer.flip();
                                AudioEncoderBuffered.this.mAudioQueue.offer(data);
                            } while (err_count <= 10);
                        }
                        finally {
                            audioRecord.stop();
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        audioRecord.release();
                    }
                }
            }
        }
    }
}

