/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AudioData {
    ByteBuffer mBuffer;
    int size;
    long presentationTimeUs;

    public AudioData(int size) {
        this.mBuffer = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
    }

    public void set(ByteBuffer buffer, int _size, long _presentationTimeUs) {
        this.presentationTimeUs = _presentationTimeUs;
        this.size = _size;
        if (this.mBuffer == null || this.mBuffer.capacity() < _size) {
            this.mBuffer = ByteBuffer.allocateDirect(_size).order(ByteOrder.nativeOrder());
        }
        this.mBuffer.clear();
        this.mBuffer.put(buffer);
        this.mBuffer.position(_size);
        this.mBuffer.flip();
    }

    public void clear() {
        this.size = 0;
        this.mBuffer.clear();
    }

    public int size() {
        return this.size;
    }

    public long presentationTimeUs() {
        return this.presentationTimeUs;
    }

    public void get(byte[] buffer) {
        if (buffer == null || buffer.length < this.size) {
            throw new ArrayIndexOutOfBoundsException("");
        }
        this.mBuffer.clear();
        this.mBuffer.get(buffer);
    }

    public void get(ByteBuffer buffer) {
        if (buffer == null || buffer.remaining() < this.size) {
            throw new ArrayIndexOutOfBoundsException("");
        }
        this.mBuffer.clear();
        buffer.put(this.mBuffer);
    }
}

