/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Process;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.Surface;
import com.serenegiant.media.Encoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.TimeoutException;
import com.serenegiant.utils.MediaInfo;
import java.nio.ByteBuffer;
import java.util.List;

@TargetApi(value=16)
public abstract class AbstractEncoder
implements Encoder,
Runnable {
    private static final String TAG = AbstractEncoder.class.getSimpleName();
    public static final int TIMEOUT_USEC = 10000;
    private volatile int mRequestDrain;
    protected volatile boolean mIsCapturing;
    protected boolean mRequestStop;
    protected volatile boolean mRecorderStarted;
    protected boolean mIsEOS;
    protected int mTrackIndex;
    protected MediaCodec mMediaCodec;
    private MediaCodec.BufferInfo mBufferInfo;
    private IRecorder mRecorder;
    protected final Object mSync = new Object();
    private final EncoderListener mListener;
    protected final String MIME_TYPE;
    private long prevOutputPTSUs = -1L;
    private long prevInputPTSUs = -1L;
    protected static final byte[] START_MARK = new byte[]{0, 0, 0, 1};

    public static final int getCodecCount() {
        return MediaInfo.getCodecCount();
    }

    public static final List<MediaCodecInfo> getCodecs() {
        return MediaInfo.getCodecs();
    }

    public static final MediaCodecInfo getCodecInfoAt(int ix) {
        return MediaInfo.getCodecInfoAt(ix);
    }

    public static MediaCodecInfo.CodecCapabilities getCodecCapabilities(MediaCodecInfo codecInfo, String mimeType) {
        return MediaInfo.getCodecCapabilities(codecInfo, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractEncoder(String mime_type, IRecorder recorder, EncoderListener listener) {
        if (listener == null) {
            throw new NullPointerException("EncodeListener is null");
        }
        if (recorder == null) {
            throw new NullPointerException("IMuxer is null");
        }
        this.MIME_TYPE = mime_type;
        this.mRecorder = recorder;
        this.mListener = listener;
        recorder.addEncoder(this);
        this.mBufferInfo = new MediaCodec.BufferInfo();
        Object object = this.mSync;
        synchronized (object) {
            new Thread((Runnable)this, this.getClass().getSimpleName()).start();
            try {
                this.mSync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public IRecorder getRecorder() {
        return this.mRecorder;
    }

    @Override
    public String getOutputPath() {
        return this.mRecorder != null ? this.mRecorder.getOutputPath() : null;
    }

    protected void finalize() throws Throwable {
        this.mRecorder = null;
        this.release();
        super.finalize();
    }

    protected void callOnStartEncode(Surface source, int captureFormat, boolean mayFail) {
        try {
            this.mListener.onStartEncode(this, source, captureFormat, mayFail);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    protected void callOnError(Exception e) {
        try {
            this.mListener.onError(e);
        }
        catch (Exception e2) {
            Log.w((String)TAG, (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.mSync;
        synchronized (object) {
            this.mIsCapturing = true;
            this.mRequestStop = false;
            this.mRequestDrain = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRequestStop) {
                return;
            }
            this.mRequestStop = true;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void frameAvailableSoon() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
            ++this.mRequestDrain;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Process.setThreadPriority((int)-4);
        Object object2 = this.mSync;
        synchronized (object2) {
            this.mRequestStop = false;
            this.mRequestDrain = 0;
            this.mSync.notify();
        }
        while (true) {
            boolean localRequestDrain;
            boolean localRequestStop;
            object = this.mSync;
            synchronized (object) {
                localRequestStop = this.mRequestStop;
                boolean bl = localRequestDrain = this.mRequestDrain > 0;
                if (localRequestDrain) {
                    --this.mRequestDrain;
                }
            }
            if (localRequestStop) {
                this.drain();
                this.signalEndOfInputStream();
                this.drain();
                this.release();
                break;
            }
            if (localRequestDrain) {
                this.drain();
                continue;
            }
            object = this.mSync;
            synchronized (object) {
                try {
                    this.mSync.wait(50L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        object = this.mSync;
        synchronized (object) {
            this.mRequestStop = true;
            this.mIsCapturing = false;
        }
    }

    @Override
    public void release() {
        if (this.mIsCapturing) {
            try {
                this.mListener.onStopEncode(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mIsCapturing = false;
        if (this.mMediaCodec != null) {
            try {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mRecorderStarted) {
            this.mRecorderStarted = false;
            if (this.mRecorder != null) {
                try {
                    this.mRecorder.stop(this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            this.mListener.onDestroy(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mBufferInfo = null;
        this.mRecorder = null;
    }

    @Override
    public void signalEndOfInputStream() {
        this.encode(null, 0, this.getInputPTSUs());
    }

    @Override
    public void encode(ByteBuffer buffer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCapturing() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mIsCapturing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(ByteBuffer buffer, int length, long presentationTimeUs) {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
            if (this.mMediaCodec == null) {
                return;
            }
        }
        ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
        while (this.mIsCapturing) {
            int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(10000L);
            if (inputBufferIndex >= 0) {
                ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
                inputBuffer.clear();
                if (buffer != null) {
                    inputBuffer.put(buffer);
                }
                if (length <= 0) {
                    this.mIsEOS = true;
                    this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                    break;
                }
                this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, length, presentationTimeUs, 0);
                break;
            }
            if (inputBufferIndex != -1) continue;
            this.frameAvailableSoon();
        }
    }

    private final void drain() {
        ByteBuffer[] encoderOutputBuffers;
        if (this.mMediaCodec == null) {
            return;
        }
        try {
            encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
        }
        catch (IllegalStateException e) {
            return;
        }
        int count = 0;
        IRecorder recorder = this.mRecorder;
        if (recorder == null) {
            return;
        }
        while (this.mIsCapturing) {
            int encoderStatus = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 10000L);
            if (encoderStatus == -1) {
                if (this.mIsEOS || ++count <= 5) continue;
                break;
            }
            if (encoderStatus == -3) {
                encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
                continue;
            }
            if (encoderStatus == -2) {
                if (this.mRecorderStarted) {
                    throw new RuntimeException("format changed twice");
                }
                MediaFormat format = this.mMediaCodec.getOutputFormat();
                if (this.startRecorder(recorder, format)) continue;
                break;
            }
            if (encoderStatus < 0) continue;
            ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
            if (encodedData == null) {
                throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
            }
            if ((this.mBufferInfo.flags & 2) != 0) {
                if (!this.mRecorderStarted) {
                    byte[] tmp = new byte[this.mBufferInfo.size];
                    encodedData.position(0);
                    encodedData.get(tmp, this.mBufferInfo.offset, this.mBufferInfo.size);
                    encodedData.position(0);
                    int ix0 = this.byteComp(tmp, 0, START_MARK, START_MARK.length);
                    int ix1 = this.byteComp(tmp, ix0 + 1, START_MARK, START_MARK.length);
                    MediaFormat outFormat = this.createOutputFormat(tmp, this.mBufferInfo.size, ix0, ix1);
                    if (!this.startRecorder(recorder, outFormat)) break;
                }
                this.mBufferInfo.size = 0;
            }
            if (this.mBufferInfo.size != 0) {
                count = 0;
                if (!this.mRecorderStarted) {
                    throw new RuntimeException("drain:muxer hasn't started");
                }
                try {
                    this.mBufferInfo.presentationTimeUs = this.getNextOutputPTSUs(this.mBufferInfo.presentationTimeUs);
                    recorder.writeSampleData(this.mTrackIndex, encodedData, this.mBufferInfo);
                }
                catch (TimeoutException e) {
                    recorder.stopRecording();
                }
                catch (Exception e) {
                    recorder.stopRecording();
                }
            }
            this.mMediaCodec.releaseOutputBuffer(encoderStatus, false);
            if ((this.mBufferInfo.flags & 4) == 0) continue;
            this.stopRecorder(recorder);
            break;
        }
    }

    protected abstract MediaFormat createOutputFormat(byte[] var1, int var2, int var3, int var4);

    public boolean startRecorder(IRecorder recorder, MediaFormat outFormat) {
        this.mTrackIndex = recorder.addTrack(this, outFormat);
        if (this.mTrackIndex >= 0) {
            this.mRecorderStarted = true;
            if (!recorder.start(this)) {
                // empty if block
            }
        } else {
            recorder.removeEncoder(this);
        }
        return recorder.isStarted();
    }

    public void stopRecorder(IRecorder recorder) {
        this.mIsCapturing = false;
        this.mRecorderStarted = false;
    }

    protected long getInputPTSUs() {
        long result = System.nanoTime() / 1000L;
        if (result <= this.prevInputPTSUs) {
            result = this.prevInputPTSUs + 9643L;
        }
        this.prevInputPTSUs = result;
        return result;
    }

    protected long getNextOutputPTSUs(long presentationTimeUs) {
        if (presentationTimeUs <= this.prevOutputPTSUs) {
            presentationTimeUs = this.prevOutputPTSUs + 9643L;
        }
        this.prevOutputPTSUs = presentationTimeUs;
        return presentationTimeUs;
    }

    public static boolean checkProfileLevel(String mimeType, MediaCodecInfo info) {
        if (info != null && mimeType.equalsIgnoreCase("video/avc")) {
            MediaCodecInfo.CodecCapabilities caps = AbstractEncoder.getCodecCapabilities(info, mimeType);
            MediaCodecInfo.CodecProfileLevel[] profileLevel = caps.profileLevels;
            for (int j = 0; j < profileLevel.length; ++j) {
                if (profileLevel[j].level < 16384) continue;
                return false;
            }
        }
        return true;
    }

    public static void dumpProfileLevel(String mimeType, MediaCodecInfo info) {
        if (info != null) {
            // empty if block
        }
    }

    public static String getProfileLevelString(String mimeType, MediaCodecInfo.CodecProfileLevel profileLevel) {
        String result = null;
        if (mimeType.equalsIgnoreCase("video/avc")) {
            switch (profileLevel.profile) {
                case 1: {
                    result = "profile:AVCProfileBaseline";
                    break;
                }
                case 2: {
                    result = "profile:AVCProfileMain";
                    break;
                }
                case 4: {
                    result = "profile:AVCProfileExtended";
                    break;
                }
                case 8: {
                    result = "profile:AVCProfileHigh";
                    break;
                }
                case 16: {
                    result = "profile:AVCProfileHigh10";
                    break;
                }
                case 32: {
                    result = "profile:AVCProfileHigh422";
                    break;
                }
                case 64: {
                    result = "profile:AVCProfileHigh444";
                    break;
                }
                default: {
                    result = "profile:unknown " + profileLevel.profile;
                }
            }
            switch (profileLevel.level) {
                case 1: {
                    result = result + ",level=AVCLevel1";
                    break;
                }
                case 2: {
                    result = result + ",level=AVCLevel1b";
                    break;
                }
                case 4: {
                    result = result + ",level=AVCLevel11";
                    break;
                }
                case 8: {
                    result = result + ",level=AVCLevel12";
                    break;
                }
                case 16: {
                    result = result + ",level=AVCLevel13";
                    break;
                }
                case 32: {
                    result = result + ",level=AVCLevel2";
                    break;
                }
                case 64: {
                    result = result + ",level=AVCLevel21";
                    break;
                }
                case 128: {
                    result = result + ",level=AVCLevel22";
                    break;
                }
                case 256: {
                    result = result + ",level=AVCLevel3";
                    break;
                }
                case 512: {
                    result = result + ",level=AVCLevel31";
                    break;
                }
                case 1024: {
                    result = result + ",level=AVCLevel32";
                    break;
                }
                case 2048: {
                    result = result + ",level=AVCLevel4";
                    break;
                }
                case 4096: {
                    result = result + ",level=AVCLevel41";
                    break;
                }
                case 8192: {
                    result = result + ",level=AVCLevel42";
                    break;
                }
                case 16384: {
                    result = result + ",level=AVCLevel5";
                    break;
                }
                case 32768: {
                    result = result + ",level=AVCLevel51";
                    break;
                }
                default: {
                    result = result + ",level=unknown " + profileLevel.level;
                    break;
                }
            }
        } else if (mimeType.equalsIgnoreCase("video/h263")) {
            switch (profileLevel.profile) {
                default: 
            }
            result = "profile:unknown " + profileLevel.profile;
            switch (profileLevel.level) {
                default: 
            }
            result = result + ",level=unknown " + profileLevel.level;
        } else if (mimeType.equalsIgnoreCase("video/mpeg4")) {
            switch (profileLevel.profile) {
                default: 
            }
            result = "profile:unknown " + profileLevel.profile;
            switch (profileLevel.level) {
                default: 
            }
            result = result + ",level=unknown " + profileLevel.level;
        } else if (mimeType.equalsIgnoreCase("ausio/aac")) {
            switch (profileLevel.level) {
                default: 
            }
            result = "profile:unknown " + profileLevel.profile;
        } else if (mimeType.equalsIgnoreCase("video/vp8")) {
            switch (profileLevel.profile) {
                default: 
            }
            result = "profile:unknown " + profileLevel.profile;
            switch (profileLevel.level) {
                default: 
            }
            result = result + ",level=unknown " + profileLevel.level;
        }
        return result;
    }

    protected final int byteComp(@NonNull byte[] array, int offset, @NonNull byte[] search, int len) {
        int index = -1;
        int n0 = array.length;
        int ns = search.length;
        if (n0 >= offset + len && ns >= len) {
            for (int i = offset; i < n0 - len; ++i) {
                int j;
                for (j = len - 1; j >= 0 && array[i + j] == search[j]; --j) {
                }
                if (j >= 0) continue;
                index = i;
                break;
            }
        }
        return index;
    }
}

