/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.support.annotation.NonNull;
import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class BufferHelper {
    private static final int BUF_LEN = 256;
    public static final byte[] ANNEXB_START_MARK = new byte[]{0, 0, 0, 1};
    private static final int SIZEOF_FLOAT = 4;

    public static final void dumpByteBuffer(String tag, ByteBuffer buffer, int offset, int size) {
        BufferHelper.dumpByteBuffer(tag, buffer, offset, size, false);
    }

    public static final void dumpByteBuffer(String tag, ByteBuffer buffer, int offset, int _size, boolean findAnnexB) {
        byte[] dump = new byte[256];
        if (buffer == null) {
            return;
        }
        int n = buffer.limit();
        int pos = buffer.position();
        int size = _size;
        if (size > n) {
            size = n;
        }
        buffer.position(offset);
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < size; i += 256) {
            int sz = i + 256 < size ? 256 : size - i;
            buffer.get(dump, 0, sz);
            sb.setLength(0);
            for (int j = 0; j < sz; ++j) {
                sb.append(String.format("%02x", dump[j]));
            }
            if (!findAnnexB) continue;
            int index = -1;
            do {
                if ((index = BufferHelper.byteComp(dump, index + 1, ANNEXB_START_MARK, ANNEXB_START_MARK.length)) < 0) continue;
                Log.i((String)tag, (String)("found ANNEXB: start index=" + index));
            } while (index >= 0);
        }
        Log.i((String)tag, (String)("dumpByteBuffer:" + sb.toString()));
        buffer.position(pos);
    }

    public static final int byteComp(@NonNull byte[] array, int offset, @NonNull byte[] search, int len) {
        int index = -1;
        int n0 = array.length;
        int ns = search.length;
        if (n0 >= offset + len && ns >= len) {
            for (int i = offset; i < n0 - len; ++i) {
                int j;
                for (j = len - 1; j >= 0 && array[i + j] == search[j]; --j) {
                }
                if (j >= 0) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static final int findAnnexB(byte[] data, int offset) {
        int result = -1;
        if (data != null) {
            int len = data.length - 4;
            for (int i = offset; i < len; ++i) {
                if (data[i] != 0 || data[i + 1] != 0 || data[i + 2] != 1) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public static FloatBuffer createFloatBuffer(float[] coords) {
        ByteBuffer bb = ByteBuffer.allocateDirect(coords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(coords);
        fb.position(0);
        return fb;
    }
}

