/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediaeffect;

import android.media.effect.Effect;
import android.media.effect.EffectContext;
import android.media.effect.EffectFactory;
import android.text.TextUtils;
import com.serenegiant.mediaeffect.IEffect;
import com.serenegiant.mediaeffect.ISource;

public class MediaEffect
implements IEffect {
    protected final EffectContext mEffectContext;
    protected Effect mEffect;
    protected boolean mEnabled = true;

    public MediaEffect(EffectContext effect_context, String effectName) {
        this.mEffectContext = effect_context;
        EffectFactory factory = effect_context.getFactory();
        this.mEffect = TextUtils.isEmpty((CharSequence)effectName) ? null : factory.createEffect(effectName);
    }

    @Override
    public void apply(int[] src_tex_ids, int width, int height, int out_tex_id) {
        if (this.mEnabled && this.mEffect != null) {
            this.mEffect.apply(src_tex_ids[0], width, height, out_tex_id);
        }
    }

    @Override
    public void apply(ISource src) {
        if (this.mEnabled && this.mEffect != null) {
            this.mEffect.apply(src.getSourceTexId()[0], src.getWidth(), src.getHeight(), src.getOutputTexId());
        }
    }

    @Override
    public void release() {
        if (this.mEffect != null) {
            this.mEffect.release();
            this.mEffect = null;
        }
    }

    @Override
    public MediaEffect resize(int width, int height) {
        return this;
    }

    protected MediaEffect setParameter(String parameterKey, Object value) {
        if (this.mEffect != null && value != null) {
            this.mEffect.setParameter(parameterKey, value);
        }
        return this;
    }

    @Override
    public boolean enabled() {
        return this.mEnabled;
    }

    @Override
    public IEffect setEnable(boolean enable) {
        this.mEnabled = enable;
        return this;
    }
}

